/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.IContentsListener;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.laser.TileEntityLaserReceptor;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityLaserAmplifier
extends TileEntityLaserReceptor
implements IHasMode {
    private long minThreshold = 0L;
    private long maxThreshold;
    private int ticks;
    private int delay;
    private boolean emittingRedstone;
    private RedstoneOutput outputMode;

    public TileEntityLaserAmplifier(BlockPos pos, BlockState state) {
        super(MekanismBlocks.LASER_AMPLIFIER, pos, state);
        this.maxThreshold = MekanismConfig.storage.laserAmplifier.get();
        this.ticks = 0;
        this.delay = 0;
        this.outputMode = RedstoneOutput.OFF;
    }

    @Override
    protected void addInitialEnergyContainers(EnergyContainerHelper builder, IContentsListener listener) {
        this.energyContainer = LaserEnergyContainer.create(BasicEnergyContainer.alwaysTrue, BasicEnergyContainer.internalOnly, this, listener);
        builder.addContainer(this.energyContainer);
    }

    @Override
    protected boolean onUpdateServer() {
        this.setEmittingRedstone(false);
        this.ticks = this.ticks < this.delay ? ++this.ticks : 0;
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.outputMode != RedstoneOutput.ENTITY_DETECTION) {
            this.setEmittingRedstone(false);
        }
        return sendUpdatePacket;
    }

    @Override
    protected void setEmittingRedstone(boolean foundEntity) {
        this.emittingRedstone = foundEntity;
    }

    private boolean shouldFire() {
        return this.ticks >= this.delay && this.energyContainer.getEnergy() >= this.minThreshold && this.canFunction();
    }

    @Override
    protected long toFire() {
        return this.shouldFire() ? Math.min(super.toFire(), this.maxThreshold) : 0L;
    }

    @Override
    public int getRedstoneLevel() {
        if (this.outputMode == RedstoneOutput.ENERGY_CONTENTS) {
            return MekanismUtils.redstoneLevelFromContents(this.energyContainer.getEnergy(), this.energyContainer.getMaxEnergy());
        }
        return this.emittingRedstone ? 15 : 0;
    }

    @Override
    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.ENERGY;
    }

    @Override
    protected void notifyComparatorChange() {
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockType());
    }

    public void setDelay(int delay) {
        if (this.delay != (delay = Math.max(0, delay))) {
            this.delay = delay;
            this.markForSave();
        }
    }

    @Override
    public void nextMode() {
        this.outputMode = (RedstoneOutput)this.outputMode.getNext();
        this.setChanged();
    }

    @Override
    public void previousMode() {
        this.outputMode = (RedstoneOutput)this.outputMode.getPrevious();
        this.setChanged();
    }

    public void setMinThresholdFromPacket(long target) {
        if (this.updateMinThreshold(target)) {
            this.markForSave();
        }
    }

    public void setMaxThresholdFromPacket(long target) {
        if (this.updateMaxThreshold(target)) {
            this.markForSave();
        }
    }

    private boolean updateMinThreshold(long target) {
        long threshold = this.getThreshold(target);
        if (this.minThreshold != threshold) {
            this.minThreshold = threshold;
            if (this.minThreshold > this.maxThreshold) {
                this.maxThreshold = this.minThreshold;
            }
            return true;
        }
        return false;
    }

    private boolean updateMaxThreshold(long target) {
        long threshold = this.getThreshold(target);
        if (this.maxThreshold != threshold) {
            this.maxThreshold = threshold;
            if (this.maxThreshold < this.minThreshold) {
                this.minThreshold = this.maxThreshold;
            }
            return true;
        }
        return false;
    }

    private long getThreshold(long target) {
        return Math.min(target, this.energyContainer.getMaxEnergy());
    }

    @Override
    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag data) {
        super.readSustainedData(provider, data);
        NBTUtils.setLegacyEnergyIfPresent(data, "min", this::updateMinThreshold);
        NBTUtils.setLegacyEnergyIfPresent(data, "max", this::updateMaxThreshold);
        NBTUtils.setIntIfPresent(data, "time", value -> {
            this.delay = value;
        });
        NBTUtils.setEnumIfPresent(data, "output_mode", RedstoneOutput.BY_ID, mode -> {
            this.outputMode = mode;
        });
    }

    @Override
    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        super.writeSustainedData(provider, data);
        data.putLong("min", this.minThreshold);
        data.putLong("max", this.maxThreshold);
        data.putInt("time", this.delay);
        NBTUtils.writeEnum(data, "output_mode", this.outputMode);
    }

    @Override
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.updateMinThreshold((Long)input.getOrDefault(MekanismDataComponents.MIN_THRESHOLD, (Object)this.minThreshold));
        this.updateMaxThreshold((Long)input.getOrDefault(MekanismDataComponents.MAX_THRESHOLD, (Object)this.maxThreshold));
        this.setDelay((Integer)input.getOrDefault(MekanismDataComponents.DELAY, (Object)this.delay));
        this.outputMode = (RedstoneOutput)input.getOrDefault(MekanismDataComponents.REDSTONE_OUTPUT, (Object)this.outputMode);
    }

    @Override
    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MekanismDataComponents.MIN_THRESHOLD, (Object)this.minThreshold);
        builder.set(MekanismDataComponents.MAX_THRESHOLD, (Object)this.maxThreshold);
        builder.set(MekanismDataComponents.DELAY, (Object)this.delay);
        builder.set(MekanismDataComponents.REDSTONE_OUTPUT, (Object)this.outputMode);
    }

    @Override
    public boolean supportsMode(IRedstoneControl.RedstoneControl mode) {
        return true;
    }

    @ComputerMethod(nameOverride="getRedstoneOutputMode")
    public RedstoneOutput getOutputMode() {
        return this.outputMode;
    }

    @ComputerMethod
    public int getDelay() {
        return this.delay;
    }

    @ComputerMethod
    public long getMinThreshold() {
        return this.minThreshold;
    }

    @ComputerMethod
    public long getMaxThreshold() {
        return this.maxThreshold;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableLong.create(this::getMinThreshold, value -> {
            this.minThreshold = value;
        }));
        container.track(SyncableLong.create(this::getMaxThreshold, value -> {
            this.maxThreshold = value;
        }));
        container.track(SyncableInt.create(this::getDelay, value -> {
            this.delay = value;
        }));
        container.track(SyncableEnum.create(RedstoneOutput.BY_ID, RedstoneOutput.OFF, this::getOutputMode, value -> {
            this.outputMode = value;
        }));
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setRedstoneOutputMode(RedstoneOutput mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.outputMode != mode) {
            this.outputMode = mode;
            this.setChanged();
        }
    }

    @ComputerMethod(nameOverride="setDelay", requiresPublicSecurity=true)
    void computerSetDelay(int delay) throws ComputerException {
        this.validateSecurityIsPublic();
        if (delay < 0) {
            throw new ComputerException("Delay cannot be negative. Received: %d", delay);
        }
        this.setDelay(delay);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setMinThreshold(long threshold) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setMinThresholdFromPacket(threshold);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setMaxThreshold(long threshold) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setMaxThresholdFromPacket(threshold);
    }

    @NothingNullByDefault
    public static enum RedstoneOutput implements IIncrementalEnum<RedstoneOutput>,
    IHasTranslationKey.IHasEnumNameTranslationKey,
    StringRepresentable
    {
        OFF(MekanismLang.OFF),
        ENTITY_DETECTION(MekanismLang.ENTITY_DETECTION),
        ENERGY_CONTENTS(MekanismLang.ENERGY_CONTENTS);

        public static final Codec<RedstoneOutput> CODEC;
        public static final IntFunction<RedstoneOutput> BY_ID;
        public static final StreamCodec<ByteBuf, RedstoneOutput> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final ILangEntry langEntry;

        private RedstoneOutput(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        public RedstoneOutput byIndex(int index) {
            return BY_ID.apply(index);
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(RedstoneOutput::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])RedstoneOutput.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

