/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collection;
import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.client.sound.SoundHandler;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.item.CursedTransporterItemHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.SortableFilterManager;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.InternalInventorySlot;
import mekanism.common.lib.SidedBlockPos;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.IAdvancedTransportEjector;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.base.WrenchResult;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLogisticalSorter
extends TileEntityMekanism
implements ITileFilterHolder<SorterFilter<?>>,
IAdvancedTransportEjector {
    private final SortableFilterManager<SorterFilter<?>> filterManager = new SortableFilterManager<SorterFilter>(SorterFilter.class, this::markForSave);
    private final Finder strictFinder = stack -> {
        for (SorterFilter filter : this.filterManager.getEnabledFilters()) {
            if (filter.allowDefault || !filter.getFinder().test(stack)) continue;
            return false;
        }
        return true;
    };
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> homeInventory;
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> targetInventory;
    @SyntheticComputerMethod(getter="getDefaultColor")
    public EnumColor color;
    private boolean autoEject;
    private boolean roundRobin;
    private boolean singleItem;
    @Nullable
    private SidedBlockPos rrTarget;
    private int delayTicks;
    private long nextSound = 0L;

    public TileEntityLogisticalSorter(BlockPos pos, BlockState state) {
        super(MekanismBlocks.LOGISTICAL_SORTER, pos, state);
        this.delaySupplier = () -> 3;
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this.facingSupplier);
        builder.addSlot(InternalInventorySlot.create(listener), RelativeSide.FRONT);
        return builder.build();
    }

    @Override
    public boolean persists(ContainerType<?, ?, ?> type) {
        return type != ContainerType.ITEM && super.persists(type);
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.delayTicks = Math.max(0, this.delayTicks - 1);
        if (this.delayTicks == 6) {
            this.setActive(false);
        }
        if (this.canFunction() && this.delayTicks == 0) {
            IItemHandler back = this.getHomeInventory();
            if (back != null) {
                IItemHandler frontCap;
                Direction direction = this.getDirection();
                if (this.targetInventory == null) {
                    this.targetInventory = Capabilities.ITEM.createCache((ServerLevel)this.level, this.worldPosition.relative(direction), direction.getOpposite());
                }
                if ((frontCap = (IItemHandler)this.targetInventory.getCapability()) != null) {
                    TransitRequest request;
                    TransitRequest.TransitResponse response;
                    boolean sentItems = false;
                    for (SorterFilter filter : this.filterManager.getEnabledFilters()) {
                        int min;
                        TransitRequest.TransitResponse response2;
                        TransitRequest request2 = filter.mapInventory(back, this.singleItem);
                        if (request2.isEmpty() || (response2 = this.emitItemToTransporter(frontCap, request2, filter.color, min = this.singleItem ? 1 : (filter.sizeMode ? filter.min : 0))).isEmpty()) continue;
                        response2.useAll();
                        this.setActive(true);
                        sentItems = true;
                        break;
                    }
                    if (!sentItems && this.autoEject && !(response = this.emitItemToTransporter(frontCap, request = TransitRequest.definedItem(back, this.singleItem ? 1 : 99, this.strictFinder), this.color, 0)).isEmpty()) {
                        response.useAll();
                        this.setActive(true);
                    }
                }
            }
            this.delayTicks = 10;
        }
        return sendUpdatePacket;
    }

    private TransitRequest.TransitResponse emitItemToTransporter(IItemHandler target, TransitRequest request, EnumColor filterColor, int min) {
        if (request.isEmpty()) {
            return request.getEmptyResponse();
        }
        if (target instanceof CursedTransporterItemHandler) {
            CursedTransporterItemHandler cursed = (CursedTransporterItemHandler)target;
            return cursed.getTransporter().insertMaybeRR(this, this.getBlockPos(), request, filterColor, true, min);
        }
        return request.addToInventoryUnchecked(target, min);
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        SidedBlockPos rrTarget = this.getRoundRobinTarget();
        if (rrTarget != null) {
            nbtTags.put("rr_target", (Tag)rrTarget.serialize());
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("rr_target", 10)) {
            this.setRoundRobinTarget(SidedBlockPos.deserialize(nbt.getCompound("rr_target")));
        }
    }

    @Override
    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("rr_target");
    }

    @Override
    protected boolean canPlaySound() {
        return false;
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (MekanismConfig.client.enableMachineSounds.get() && this.getActive() && this.soundEvent != null && this.level.getGameTime() >= this.nextSound) {
            if (!this.isFullyMuffled()) {
                SoundHandler.startTileSound((SoundEvent)this.soundEvent.get(), this.getSoundCategory(), this.getInitialVolume(), this.level.getRandom(), this.getSoundPos(), false);
            }
            this.nextSound = this.level.getGameTime() + 20L * (long)this.level.random.nextInt(5, 15);
        }
    }

    @ComputerMethod(nameOverride="getAutoMode")
    public boolean getAutoEject() {
        return this.autoEject;
    }

    @Override
    @ComputerMethod(nameOverride="isRoundRobin")
    public boolean getRoundRobin() {
        return this.roundRobin;
    }

    @ComputerMethod(nameOverride="isSingle")
    public boolean getSingleItem() {
        return this.singleItem;
    }

    public void toggleAutoEject() {
        this.autoEject = !this.autoEject;
        this.markForSave();
    }

    public void toggleSingleItem() {
        this.singleItem = !this.singleItem;
        this.markForSave();
    }

    public void changeColor(@Nullable EnumColor color) {
        if (this.color != color) {
            this.color = color;
            this.markForSave();
        }
    }

    public boolean hasConnectedInventory() {
        Direction oppositeDirection = this.getOppositeDirection();
        return TransporterUtils.isValidAcceptorOnSide(this.getLevel(), this.worldPosition.relative(oppositeDirection), oppositeDirection);
    }

    @Nullable
    private IItemHandler getHomeInventory() {
        if (this.homeInventory == null) {
            Direction direction = this.getDirection();
            BlockPos pos = this.worldPosition.relative(direction.getOpposite());
            this.homeInventory = Capabilities.ITEM.createCache((ServerLevel)this.level, pos, direction);
        }
        return (IItemHandler)this.homeInventory.getCapability();
    }

    @Override
    protected void invalidateDirectionCaches(Direction newDirection) {
        super.invalidateDirectionCaches(newDirection);
        this.homeInventory = null;
        this.targetInventory = null;
    }

    @Override
    public void toggleRoundRobin() {
        this.roundRobin = !this.roundRobin;
        this.setRoundRobinTarget((SidedBlockPos)null);
        this.markForSave();
    }

    @Override
    @Nullable
    public SidedBlockPos getRoundRobinTarget() {
        return this.rrTarget;
    }

    @Override
    public void setRoundRobinTarget(@Nullable SidedBlockPos target) {
        this.rrTarget = target;
    }

    @Override
    public boolean canSendHome(@NotNull ItemStack stack) {
        Direction oppositeDirection = this.getOppositeDirection();
        return TransporterUtils.canInsert(this.level, this.worldPosition.relative(oppositeDirection), null, stack, oppositeDirection, true);
    }

    @Override
    @NotNull
    public TransitRequest.TransitResponse sendHome(@NotNull TransitRequest request) {
        Direction direction = this.getDirection();
        BlockPos pos = this.worldPosition.relative(direction.getOpposite());
        return request.addToInventory(this.getLevel(), pos, this.getHomeInventory(), 0, false);
    }

    @Override
    public boolean supportsMode(IRedstoneControl.RedstoneControl mode) {
        return true;
    }

    @Override
    protected WrenchResult tryWrenchRotate(BlockState state, Player player, ItemStack stack) {
        Direction change = MekanismUtils.rotate(this.getDirection(), true);
        if (!this.hasConnectedInventory()) {
            for (Direction dir : EnumUtils.DIRECTIONS) {
                Direction opposite = dir.getOpposite();
                if (!InventoryUtils.isItemHandler(this.level, this.worldPosition.relative(dir), opposite)) continue;
                change = opposite;
                break;
            }
        }
        this.setFacing(change);
        this.level.updateNeighborsAt(this.worldPosition, state.getBlock());
        return WrenchResult.SUCCESS;
    }

    @Override
    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        if (this.color != null) {
            NBTUtils.writeEnum(dataMap, "color", this.color);
        }
        dataMap.putBoolean("eject", this.autoEject);
        dataMap.putBoolean("round_robin", this.roundRobin);
        dataMap.putBoolean("single_item", this.singleItem);
        this.filterManager.writeToNBT(provider, dataMap);
    }

    @Override
    public void readSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.readSustainedData(provider, dataMap);
        this.color = NBTUtils.getEnum(dataMap, "color", EnumColor.BY_ID);
        this.autoEject = dataMap.getBoolean("eject");
        this.roundRobin = dataMap.getBoolean("round_robin");
        this.singleItem = dataMap.getBoolean("single_item");
        this.filterManager.readFromNBT(provider, dataMap);
    }

    @Override
    public List<DataComponentType<?>> getRemapEntries() {
        List<DataComponentType<?>> remapEntries = super.getRemapEntries();
        remapEntries.add((DataComponentType)MekanismDataComponents.COLOR.get());
        return remapEntries;
    }

    @Override
    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        if (this.color != null) {
            builder.set(MekanismDataComponents.COLOR, (Object)this.color);
        }
        builder.set(MekanismDataComponents.EJECT, (Object)this.autoEject);
        builder.set(MekanismDataComponents.ROUND_ROBIN, (Object)this.roundRobin);
        builder.set(MekanismDataComponents.SINGLE_ITEM, (Object)this.singleItem);
    }

    @Override
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.color = (EnumColor)input.get(MekanismDataComponents.COLOR);
        this.autoEject = (Boolean)input.getOrDefault(MekanismDataComponents.EJECT, (Object)this.autoEject);
        this.roundRobin = (Boolean)input.getOrDefault(MekanismDataComponents.ROUND_ROBIN, (Object)this.roundRobin);
        this.singleItem = (Boolean)input.getOrDefault(MekanismDataComponents.SINGLE_ITEM, (Object)this.singleItem);
    }

    @Override
    public int getRedstoneLevel() {
        return this.getActive() ? 15 : 0;
    }

    @Override
    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return false;
    }

    @Override
    public int getCurrentRedstoneLevel() {
        return this.getRedstoneLevel();
    }

    @Override
    public SortableFilterManager<SorterFilter<?>> getFilterManager() {
        return this.filterManager;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getAutoEject, value -> {
            this.autoEject = value;
        }));
        container.track(SyncableBoolean.create(this::getRoundRobin, value -> {
            this.roundRobin = value;
        }));
        container.track(SyncableBoolean.create(this::getSingleItem, value -> {
            this.singleItem = value;
        }));
        container.track(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.color), value -> {
            this.color = TransporterUtils.readColor(value);
        }));
        this.filterManager.addContainerTrackers(container);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setSingle(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.singleItem != value) {
            this.toggleSingleItem();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setRoundRobin(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.roundRobin != value) {
            this.toggleRoundRobin();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setAutoMode(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.autoEject != value) {
            this.toggleAutoEject();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void clearDefaultColor() throws ComputerException {
        this.validateSecurityIsPublic();
        this.changeColor(null);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementDefaultColor() throws ComputerException {
        this.validateSecurityIsPublic();
        this.color = TransporterUtils.increment(this.color);
        this.markForSave();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementDefaultColor() throws ComputerException {
        this.validateSecurityIsPublic();
        this.color = TransporterUtils.decrement(this.color);
        this.markForSave();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setDefaultColor(EnumColor color) throws ComputerException {
        this.validateSecurityIsPublic();
        this.changeColor(color);
    }

    @ComputerMethod
    Collection<SorterFilter<?>> getFilters() {
        return this.filterManager.getFilters();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    boolean addFilter(SorterFilter<?> filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filterManager.addFilter(filter);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    boolean removeFilter(SorterFilter<?> filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filterManager.removeFilter(filter);
    }
}

