/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.tier.ITier;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.FilterAware;
import mekanism.common.attachments.OverflowAware;
import mekanism.common.attachments.StabilizedChunks;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.attachments.component.AttachedSideConfig;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.ChemicalTanksBuilder;
import mekanism.common.attachments.containers.chemical.ComponentBackedChemicalTankTank;
import mekanism.common.attachments.containers.fluid.ComponentBackedFluidTankFluidTank;
import mekanism.common.attachments.containers.fluid.FluidTanksBuilder;
import mekanism.common.attachments.containers.heat.HeatCapacitorsBuilder;
import mekanism.common.attachments.containers.item.ComponentBackedBinInventorySlot;
import mekanism.common.attachments.containers.item.ItemSlotsBuilder;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.BlockCardboardBox;
import mekanism.common.block.BlockEnergyCube;
import mekanism.common.block.BlockIndustrialAlarm;
import mekanism.common.block.BlockOre;
import mekanism.common.block.BlockPersonalBarrel;
import mekanism.common.block.BlockPersonalChest;
import mekanism.common.block.BlockQIOComponent;
import mekanism.common.block.BlockRadioactiveWasteBarrel;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.basic.BlockBin;
import mekanism.common.block.basic.BlockChargepad;
import mekanism.common.block.basic.BlockFluidTank;
import mekanism.common.block.basic.BlockLogisticalSorter;
import mekanism.common.block.basic.BlockResource;
import mekanism.common.block.basic.BlockStructuralGlass;
import mekanism.common.block.prefab.BlockBase;
import mekanism.common.block.prefab.BlockBasicMultiblock;
import mekanism.common.block.prefab.BlockFactoryMachine;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.Factory;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.content.gear.IModuleItem;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.item.block.ItemBlockCardboardBox;
import mekanism.common.item.block.ItemBlockChemicalTank;
import mekanism.common.item.block.ItemBlockEnergyCube;
import mekanism.common.item.block.ItemBlockInductionCell;
import mekanism.common.item.block.ItemBlockInductionProvider;
import mekanism.common.item.block.ItemBlockLaserAmplifier;
import mekanism.common.item.block.ItemBlockMekanism;
import mekanism.common.item.block.ItemBlockPersonalStorage;
import mekanism.common.item.block.ItemBlockRadioactiveWasteBarrel;
import mekanism.common.item.block.ItemBlockSecurityDesk;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.block.machine.ItemBlockFactory;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.item.block.machine.ItemBlockLaserTractorBeam;
import mekanism.common.item.block.machine.ItemBlockQIOComponent;
import mekanism.common.item.block.machine.ItemBlockQuantumEntangloporter;
import mekanism.common.item.block.machine.ItemBlockResistiveHeater;
import mekanism.common.item.block.machine.ItemBlockTeleporter;
import mekanism.common.item.block.transmitter.ItemBlockLogisticalTransporter;
import mekanism.common.item.block.transmitter.ItemBlockMechanicalPipe;
import mekanism.common.item.block.transmitter.ItemBlockPressurizedTube;
import mekanism.common.item.block.transmitter.ItemBlockThermodynamicConductor;
import mekanism.common.item.block.transmitter.ItemBlockTransporter;
import mekanism.common.item.block.transmitter.ItemBlockUniversalCable;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.EitherSideInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.cache.RotaryInputRecipeCache;
import mekanism.common.recipe.lookup.cache.SingleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.TripleInputRecipeCache;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.resource.IResource;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ore.OreBlockType;
import mekanism.common.resource.ore.OreType;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityModificationStation;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.laser.TileEntityLaser;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.laser.TileEntityLaserTractorBeam;
import mekanism.common.tile.machine.TileEntityAntiprotonicNucleosynthesizer;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import mekanism.common.tile.machine.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.machine.TileEntityChemicalInfuser;
import mekanism.common.tile.machine.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.machine.TileEntityChemicalOxidizer;
import mekanism.common.tile.machine.TileEntityChemicalWasher;
import mekanism.common.tile.machine.TileEntityCombiner;
import mekanism.common.tile.machine.TileEntityCrusher;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityDimensionalStabilizer;
import mekanism.common.tile.machine.TileEntityElectricPump;
import mekanism.common.tile.machine.TileEntityElectrolyticSeparator;
import mekanism.common.tile.machine.TileEntityEnergizedSmelter;
import mekanism.common.tile.machine.TileEntityEnrichmentChamber;
import mekanism.common.tile.machine.TileEntityFluidicPlenisher;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.machine.TileEntityFuelwoodHeater;
import mekanism.common.tile.machine.TileEntityIsotopicCentrifuge;
import mekanism.common.tile.machine.TileEntityMetallurgicInfuser;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.tile.machine.TileEntityOsmiumCompressor;
import mekanism.common.tile.machine.TileEntityPaintingMachine;
import mekanism.common.tile.machine.TileEntityPigmentExtractor;
import mekanism.common.tile.machine.TileEntityPigmentMixer;
import mekanism.common.tile.machine.TileEntityPrecisionSawmill;
import mekanism.common.tile.machine.TileEntityPressurizedReactionChamber;
import mekanism.common.tile.machine.TileEntityPurificationChamber;
import mekanism.common.tile.machine.TileEntityResistiveHeater;
import mekanism.common.tile.machine.TileEntityRotaryCondensentrator;
import mekanism.common.tile.machine.TileEntitySeismicVibrator;
import mekanism.common.tile.machine.TileEntitySolarNeutronActivator;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.tile.multiblock.TileEntityBoilerValve;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import mekanism.common.tile.multiblock.TileEntityDynamicValve;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.tile.multiblock.TileEntityInductionCell;
import mekanism.common.tile.multiblock.TileEntityInductionPort;
import mekanism.common.tile.multiblock.TileEntityInductionProvider;
import mekanism.common.tile.multiblock.TileEntitySPSCasing;
import mekanism.common.tile.multiblock.TileEntitySPSPort;
import mekanism.common.tile.multiblock.TileEntityStructuralGlass;
import mekanism.common.tile.multiblock.TileEntitySuperchargedCoil;
import mekanism.common.tile.multiblock.TileEntitySuperheatingElement;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationController;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationValve;
import mekanism.common.tile.qio.TileEntityQIODashboard;
import mekanism.common.tile.qio.TileEntityQIODriveArray;
import mekanism.common.tile.qio.TileEntityQIOExporter;
import mekanism.common.tile.qio.TileEntityQIOImporter;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.tile.transmitter.TileEntityDiversionTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityRestrictiveTransporter;
import mekanism.common.tile.transmitter.TileEntityThermodynamicConductor;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import mekanism.common.util.EnumUtils;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class MekanismBlocks {
    public static final BlockDeferredRegister BLOCKS = new BlockDeferredRegister("mekanism");
    public static final Map<IResource, BlockRegistryObject<?, ?>> PROCESSED_RESOURCE_BLOCKS = new LinkedHashMap();
    public static final Map<OreType, OreBlockType> ORES = new LinkedHashMap<OreType, OreBlockType>();
    private static final Table<FactoryTier, FactoryType, BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory>> FACTORIES = HashBasedTable.create();
    public static final BlockRegistryObject<BlockResource, ItemBlockMekanism<BlockResource>> BRONZE_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockMekanism<BlockResource>> REFINED_OBSIDIAN_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockMekanism<BlockResource>> CHARCOAL_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockMekanism<BlockResource>> REFINED_GLOWSTONE_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockMekanism<BlockResource>> STEEL_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockMekanism<BlockResource>> FLUORITE_BLOCK;
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> BASIC_BIN;
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> ADVANCED_BIN;
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> ELITE_BIN;
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> ULTIMATE_BIN;
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> CREATIVE_BIN;
    public static final BlockRegistryObject<BlockBase<BlockType>, ItemBlockTooltip<BlockBase<BlockType>>> TELEPORTER_FRAME;
    public static final BlockRegistryObject<BlockBase<BlockType>, ItemBlockTooltip<BlockBase<BlockType>>> STEEL_CASING;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityDynamicTank>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityDynamicTank>>> DYNAMIC_TANK;
    public static final BlockRegistryObject<BlockStructuralGlass<TileEntityStructuralGlass>, ItemBlockTooltip<BlockStructuralGlass<TileEntityStructuralGlass>>> STRUCTURAL_GLASS;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityDynamicValve>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityDynamicValve>>> DYNAMIC_VALVE;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityThermalEvaporationController>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityThermalEvaporationController>>> THERMAL_EVAPORATION_CONTROLLER;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityThermalEvaporationValve>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityThermalEvaporationValve>>> THERMAL_EVAPORATION_VALVE;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityThermalEvaporationBlock>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityThermalEvaporationBlock>>> THERMAL_EVAPORATION_BLOCK;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityInductionCasing>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityInductionCasing>>> INDUCTION_CASING;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityInductionPort>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityInductionPort>>> INDUCTION_PORT;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> BASIC_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> ADVANCED_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> ELITE_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> ULTIMATE_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> BASIC_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> ADVANCED_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> ELITE_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> ULTIMATE_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntitySuperheatingElement, BlockTypeTile<TileEntitySuperheatingElement>>, ItemBlockTooltip<BlockTile<TileEntitySuperheatingElement, BlockTypeTile<TileEntitySuperheatingElement>>>> SUPERHEATING_ELEMENT;
    public static final BlockRegistryObject<BlockTile<TileEntityPressureDisperser, BlockTypeTile<TileEntityPressureDisperser>>, ItemBlockTooltip<BlockTile<TileEntityPressureDisperser, BlockTypeTile<TileEntityPressureDisperser>>>> PRESSURE_DISPERSER;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityBoilerCasing>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityBoilerCasing>>> BOILER_CASING;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityBoilerValve>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityBoilerValve>>> BOILER_VALVE;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntitySecurityDesk, BlockTypeTile<TileEntitySecurityDesk>>, ItemBlockSecurityDesk> SECURITY_DESK;
    public static final BlockRegistryObject<BlockRadioactiveWasteBarrel, ItemBlockRadioactiveWasteBarrel> RADIOACTIVE_WASTE_BARREL;
    public static final BlockRegistryObject<BlockIndustrialAlarm, ItemBlockTooltip<BlockIndustrialAlarm>> INDUSTRIAL_ALARM;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityEnrichmentChamber, Machine.FactoryMachine<TileEntityEnrichmentChamber>>, ItemBlockTooltip<BlockFactoryMachine<TileEntityEnrichmentChamber, Machine.FactoryMachine<TileEntityEnrichmentChamber>>>> ENRICHMENT_CHAMBER;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityOsmiumCompressor, Machine.FactoryMachine<TileEntityOsmiumCompressor>>, ItemBlockTooltip<BlockFactoryMachine<TileEntityOsmiumCompressor, Machine.FactoryMachine<TileEntityOsmiumCompressor>>>> OSMIUM_COMPRESSOR;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityCombiner, Machine.FactoryMachine<TileEntityCombiner>>, ItemBlockTooltip<BlockFactoryMachine<TileEntityCombiner, Machine.FactoryMachine<TileEntityCombiner>>>> COMBINER;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityCrusher, Machine.FactoryMachine<TileEntityCrusher>>, ItemBlockTooltip<BlockFactoryMachine<TileEntityCrusher, Machine.FactoryMachine<TileEntityCrusher>>>> CRUSHER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityDigitalMiner, Machine<TileEntityDigitalMiner>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityDigitalMiner, Machine<TileEntityDigitalMiner>>>> DIGITAL_MINER;
    public static final BlockRegistryObject<BlockFactoryMachine.BlockFactoryMachineModel<TileEntityMetallurgicInfuser, Machine.FactoryMachine<TileEntityMetallurgicInfuser>>, ItemBlockTooltip<BlockFactoryMachine.BlockFactoryMachineModel<TileEntityMetallurgicInfuser, Machine.FactoryMachine<TileEntityMetallurgicInfuser>>>> METALLURGIC_INFUSER;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityPurificationChamber, Machine.FactoryMachine<TileEntityPurificationChamber>>, ItemBlockTooltip<BlockFactoryMachine<TileEntityPurificationChamber, Machine.FactoryMachine<TileEntityPurificationChamber>>>> PURIFICATION_CHAMBER;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityEnergizedSmelter, Machine.FactoryMachine<TileEntityEnergizedSmelter>>, ItemBlockTooltip<BlockFactoryMachine<TileEntityEnergizedSmelter, Machine.FactoryMachine<TileEntityEnergizedSmelter>>>> ENERGIZED_SMELTER;
    public static final BlockRegistryObject<BlockTile<TileEntityTeleporter, Machine<TileEntityTeleporter>>, ItemBlockTeleporter> TELEPORTER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityElectricPump, Machine<TileEntityElectricPump>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityElectricPump, Machine<TileEntityElectricPump>>>> ELECTRIC_PUMP;
    public static final BlockRegistryObject<BlockPersonalBarrel, ItemBlockPersonalStorage<BlockPersonalBarrel>> PERSONAL_BARREL;
    public static final BlockRegistryObject<BlockPersonalChest, ItemBlockPersonalStorage<BlockPersonalChest>> PERSONAL_CHEST;
    public static final BlockRegistryObject<BlockChargepad, ItemBlockTooltip<BlockChargepad>> CHARGEPAD;
    public static final BlockRegistryObject<BlockLogisticalSorter, ItemBlockTooltip<BlockLogisticalSorter>> LOGISTICAL_SORTER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityRotaryCondensentrator, Machine<TileEntityRotaryCondensentrator>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityRotaryCondensentrator, Machine<TileEntityRotaryCondensentrator>>>> ROTARY_CONDENSENTRATOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalOxidizer, Machine<TileEntityChemicalOxidizer>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityChemicalOxidizer, Machine<TileEntityChemicalOxidizer>>>> CHEMICAL_OXIDIZER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalInfuser, Machine<TileEntityChemicalInfuser>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityChemicalInfuser, Machine<TileEntityChemicalInfuser>>>> CHEMICAL_INFUSER;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityChemicalInjectionChamber, Machine.FactoryMachine<TileEntityChemicalInjectionChamber>>, ItemBlockTooltip<BlockFactoryMachine<TileEntityChemicalInjectionChamber, Machine.FactoryMachine<TileEntityChemicalInjectionChamber>>>> CHEMICAL_INJECTION_CHAMBER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityElectrolyticSeparator, Machine<TileEntityElectrolyticSeparator>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityElectrolyticSeparator, Machine<TileEntityElectrolyticSeparator>>>> ELECTROLYTIC_SEPARATOR;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityPrecisionSawmill, Machine.FactoryMachine<TileEntityPrecisionSawmill>>, ItemBlockTooltip<BlockFactoryMachine<TileEntityPrecisionSawmill, Machine.FactoryMachine<TileEntityPrecisionSawmill>>>> PRECISION_SAWMILL;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalDissolutionChamber, Machine<TileEntityChemicalDissolutionChamber>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityChemicalDissolutionChamber, Machine<TileEntityChemicalDissolutionChamber>>>> CHEMICAL_DISSOLUTION_CHAMBER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalWasher, Machine<TileEntityChemicalWasher>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityChemicalWasher, Machine<TileEntityChemicalWasher>>>> CHEMICAL_WASHER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalCrystallizer, Machine<TileEntityChemicalCrystallizer>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityChemicalCrystallizer, Machine<TileEntityChemicalCrystallizer>>>> CHEMICAL_CRYSTALLIZER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntitySeismicVibrator, Machine<TileEntitySeismicVibrator>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntitySeismicVibrator, Machine<TileEntitySeismicVibrator>>>> SEISMIC_VIBRATOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityPressurizedReactionChamber, Machine<TileEntityPressurizedReactionChamber>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityPressurizedReactionChamber, Machine<TileEntityPressurizedReactionChamber>>>> PRESSURIZED_REACTION_CHAMBER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityIsotopicCentrifuge, Machine<TileEntityIsotopicCentrifuge>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityIsotopicCentrifuge, Machine<TileEntityIsotopicCentrifuge>>>> ISOTOPIC_CENTRIFUGE;
    public static final BlockRegistryObject<BlockTile<TileEntityNutritionalLiquifier, Machine<TileEntityNutritionalLiquifier>>, ItemBlockTooltip<BlockTile<TileEntityNutritionalLiquifier, Machine<TileEntityNutritionalLiquifier>>>> NUTRITIONAL_LIQUIFIER;
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> BASIC_FLUID_TANK;
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> ADVANCED_FLUID_TANK;
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> ELITE_FLUID_TANK;
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> ULTIMATE_FLUID_TANK;
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> CREATIVE_FLUID_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityFluidicPlenisher, Machine<TileEntityFluidicPlenisher>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityFluidicPlenisher, Machine<TileEntityFluidicPlenisher>>>> FLUIDIC_PLENISHER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityLaser, BlockTypeTile<TileEntityLaser>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityLaser, BlockTypeTile<TileEntityLaser>>>> LASER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityLaserAmplifier, BlockTypeTile<TileEntityLaserAmplifier>>, ItemBlockLaserAmplifier> LASER_AMPLIFIER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityLaserTractorBeam, BlockTypeTile<TileEntityLaserTractorBeam>>, ItemBlockLaserTractorBeam> LASER_TRACTOR_BEAM;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityQuantumEntangloporter, BlockTypeTile<TileEntityQuantumEntangloporter>>, ItemBlockQuantumEntangloporter> QUANTUM_ENTANGLOPORTER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntitySolarNeutronActivator, Machine<TileEntitySolarNeutronActivator>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntitySolarNeutronActivator, Machine<TileEntitySolarNeutronActivator>>>> SOLAR_NEUTRON_ACTIVATOR;
    public static final BlockRegistryObject<BlockTile<TileEntityOredictionificator, BlockTypeTile<TileEntityOredictionificator>>, ItemBlockTooltip<BlockTile<TileEntityOredictionificator, BlockTypeTile<TileEntityOredictionificator>>>> OREDICTIONIFICATOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityResistiveHeater, Machine<TileEntityResistiveHeater>>, ItemBlockResistiveHeater> RESISTIVE_HEATER;
    public static final BlockRegistryObject<BlockTile<TileEntityFormulaicAssemblicator, Machine<TileEntityFormulaicAssemblicator>>, ItemBlockTooltip<BlockTile<TileEntityFormulaicAssemblicator, Machine<TileEntityFormulaicAssemblicator>>>> FORMULAIC_ASSEMBLICATOR;
    public static final BlockRegistryObject<BlockTile<TileEntityFuelwoodHeater, BlockTypeTile<TileEntityFuelwoodHeater>>, ItemBlockTooltip<BlockTile<TileEntityFuelwoodHeater, BlockTypeTile<TileEntityFuelwoodHeater>>>> FUELWOOD_HEATER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityModificationStation, BlockTypeTile<TileEntityModificationStation>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityModificationStation, BlockTypeTile<TileEntityModificationStation>>>> MODIFICATION_STATION;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityAntiprotonicNucleosynthesizer, Machine<TileEntityAntiprotonicNucleosynthesizer>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityAntiprotonicNucleosynthesizer, Machine<TileEntityAntiprotonicNucleosynthesizer>>>> ANTIPROTONIC_NUCLEOSYNTHESIZER;
    public static final BlockRegistryObject<BlockTile<TileEntityPigmentExtractor, Machine<TileEntityPigmentExtractor>>, ItemBlockTooltip<BlockTile<TileEntityPigmentExtractor, Machine<TileEntityPigmentExtractor>>>> PIGMENT_EXTRACTOR;
    public static final BlockRegistryObject<BlockTile<TileEntityPigmentMixer, Machine<TileEntityPigmentMixer>>, ItemBlockTooltip<BlockTile<TileEntityPigmentMixer, Machine<TileEntityPigmentMixer>>>> PIGMENT_MIXER;
    public static final BlockRegistryObject<BlockTile<TileEntityPaintingMachine, Machine<TileEntityPaintingMachine>>, ItemBlockTooltip<BlockTile<TileEntityPaintingMachine, Machine<TileEntityPaintingMachine>>>> PAINTING_MACHINE;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntitySPSCasing>, ItemBlockTooltip<BlockBasicMultiblock<TileEntitySPSCasing>>> SPS_CASING;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntitySPSPort>, ItemBlockTooltip<BlockBasicMultiblock<TileEntitySPSPort>>> SPS_PORT;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntitySuperchargedCoil, BlockTypeTile<TileEntitySuperchargedCoil>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntitySuperchargedCoil, BlockTypeTile<TileEntitySuperchargedCoil>>>> SUPERCHARGED_COIL;
    public static final BlockRegistryObject<BlockTile<TileEntityDimensionalStabilizer, Machine<TileEntityDimensionalStabilizer>>, ItemBlockTooltip<BlockTile<TileEntityDimensionalStabilizer, Machine<TileEntityDimensionalStabilizer>>>> DIMENSIONAL_STABILIZER;
    public static final BlockRegistryObject<BlockQIOComponent<TileEntityQIODriveArray, BlockTypeTile<TileEntityQIODriveArray>>, ItemBlockQIOComponent> QIO_DRIVE_ARRAY;
    public static final BlockRegistryObject<BlockQIOComponent<TileEntityQIODashboard, BlockTypeTile<TileEntityQIODashboard>>, ItemBlockQIOComponent> QIO_DASHBOARD;
    public static final BlockRegistryObject<BlockQIOComponent<TileEntityQIOImporter, BlockTypeTile<TileEntityQIOImporter>>, ItemBlockQIOComponent> QIO_IMPORTER;
    public static final BlockRegistryObject<BlockQIOComponent<TileEntityQIOExporter, BlockTypeTile<TileEntityQIOExporter>>, ItemBlockQIOComponent> QIO_EXPORTER;
    public static final BlockRegistryObject<BlockQIOComponent<TileEntityQIORedstoneAdapter, BlockTypeTile<TileEntityQIORedstoneAdapter>>, ItemBlockQIOComponent> QIO_REDSTONE_ADAPTER;
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> BASIC_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> ADVANCED_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> ELITE_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> ULTIMATE_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> CREATIVE_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityUniversalCable>, ItemBlockUniversalCable> BASIC_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityUniversalCable>, ItemBlockUniversalCable> ADVANCED_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityUniversalCable>, ItemBlockUniversalCable> ELITE_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityUniversalCable>, ItemBlockUniversalCable> ULTIMATE_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityMechanicalPipe>, ItemBlockMechanicalPipe> BASIC_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityMechanicalPipe>, ItemBlockMechanicalPipe> ADVANCED_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityMechanicalPipe>, ItemBlockMechanicalPipe> ELITE_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityMechanicalPipe>, ItemBlockMechanicalPipe> ULTIMATE_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityPressurizedTube>, ItemBlockPressurizedTube> BASIC_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityPressurizedTube>, ItemBlockPressurizedTube> ADVANCED_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityPressurizedTube>, ItemBlockPressurizedTube> ELITE_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityPressurizedTube>, ItemBlockPressurizedTube> ULTIMATE_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityLogisticalTransporter>, ItemBlockLogisticalTransporter> BASIC_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityLogisticalTransporter>, ItemBlockLogisticalTransporter> ADVANCED_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityLogisticalTransporter>, ItemBlockLogisticalTransporter> ELITE_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityLogisticalTransporter>, ItemBlockLogisticalTransporter> ULTIMATE_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityRestrictiveTransporter>, ItemBlockTransporter<TileEntityRestrictiveTransporter>> RESTRICTIVE_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityDiversionTransporter>, ItemBlockTransporter<TileEntityDiversionTransporter>> DIVERSION_TRANSPORTER;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityThermodynamicConductor>, ItemBlockThermodynamicConductor> BASIC_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityThermodynamicConductor>, ItemBlockThermodynamicConductor> ADVANCED_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityThermodynamicConductor>, ItemBlockThermodynamicConductor> ELITE_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityThermodynamicConductor>, ItemBlockThermodynamicConductor> ULTIMATE_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockBounding, BlockItem> BOUNDING_BLOCK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> BASIC_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> ADVANCED_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> ELITE_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> ULTIMATE_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> CREATIVE_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockCardboardBox, ItemBlockCardboardBox> CARDBOARD_BOX;
    public static final BlockRegistryObject<Block, BlockItem> SALT_BLOCK;
    public static final BlockRegistryObject<Block, BlockItem> BIO_FUEL_BLOCK;

    private MekanismBlocks() {
    }

    private static BlockRegistryObject<BlockResource, ItemBlockMekanism<BlockResource>> registerResourceBlock(BlockResourceInfo resource) {
        return BLOCKS.register("block_" + resource.getRegistrySuffix(), () -> new BlockResource(resource), (block, properties) -> {
            if (!block.getResourceInfo().burnsInFire()) {
                properties = properties.fireResistant();
            }
            return new ItemBlockMekanism<BlockResource>((BlockResource)((Object)block), (Item.Properties)properties);
        });
    }

    private static BlockRegistryObject<BlockBin, ItemBlockBin> registerBin(BlockTypeTile<TileEntityBin> type) {
        return MekanismBlocks.registerTieredBlock(type, "_bin", (MapColor color) -> new BlockBin(type, properties -> properties.mapColor(color)), ItemBlockBin::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addSlot(ComponentBackedBinInventorySlot::create).build()));
    }

    private static BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> registerInductionCell(BlockTypeTile<TileEntityInductionCell> type) {
        return MekanismBlocks.registerTieredBlock(type, "_induction_cell", (MapColor color) -> new BlockTile(type, properties -> properties.mapColor(color)), ItemBlockInductionCell::new);
    }

    private static BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> registerInductionProvider(BlockTypeTile<TileEntityInductionProvider> type) {
        return MekanismBlocks.registerTieredBlock(type, "_induction_provider", (MapColor color) -> new BlockTile(type, properties -> properties.mapColor(color)), ItemBlockInductionProvider::new);
    }

    private static BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> registerFluidTank(Machine<TileEntityFluidTank> type) {
        return MekanismBlocks.registerTieredBlock(type, "_fluid_tank", () -> new BlockFluidTank(type), ItemBlockFluidTank::new).forItemHolder(holder -> holder.addAttachedContainerCapabilities(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addTank(ComponentBackedFluidTankFluidTank::create).build(), new IMekanismConfig[0]).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidInputSlot(0).addOutput().build()));
    }

    private static BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> registerEnergyCube(Machine<TileEntityEnergyCube> type) {
        return MekanismBlocks.registerTieredBlock(type, "_energy_cube", () -> new BlockEnergyCube(type), ItemBlockEnergyCube::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addEnergy().addDrainEnergy().build()));
    }

    private static BlockRegistryObject<BlockSmallTransmitter<TileEntityUniversalCable>, ItemBlockUniversalCable> registerUniversalCable(BlockTypeTile<TileEntityUniversalCable> type) {
        return MekanismBlocks.registerTieredBlock(type, "_universal_cable", () -> new BlockSmallTransmitter(type), ItemBlockUniversalCable::new);
    }

    private static BlockRegistryObject<BlockLargeTransmitter<TileEntityMechanicalPipe>, ItemBlockMechanicalPipe> registerMechanicalPipe(BlockTypeTile<TileEntityMechanicalPipe> type) {
        return MekanismBlocks.registerTieredBlock(type, "_mechanical_pipe", () -> new BlockLargeTransmitter(type), ItemBlockMechanicalPipe::new);
    }

    private static BlockRegistryObject<BlockSmallTransmitter<TileEntityPressurizedTube>, ItemBlockPressurizedTube> registerPressurizedTube(BlockTypeTile<TileEntityPressurizedTube> type) {
        return MekanismBlocks.registerTieredBlock(type, "_pressurized_tube", () -> new BlockSmallTransmitter(type), ItemBlockPressurizedTube::new);
    }

    private static BlockRegistryObject<BlockLargeTransmitter<TileEntityLogisticalTransporter>, ItemBlockLogisticalTransporter> registerLogisticalTransporter(BlockTypeTile<TileEntityLogisticalTransporter> type) {
        return MekanismBlocks.registerTieredBlock(type, "_logistical_transporter", () -> new BlockLargeTransmitter(type), ItemBlockLogisticalTransporter::new);
    }

    private static BlockRegistryObject<BlockSmallTransmitter<TileEntityThermodynamicConductor>, ItemBlockThermodynamicConductor> registerThermodynamicConductor(BlockTypeTile<TileEntityThermodynamicConductor> type) {
        return MekanismBlocks.registerTieredBlock(type, "_thermodynamic_conductor", () -> new BlockSmallTransmitter(type), ItemBlockThermodynamicConductor::new);
    }

    private static BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> registerChemicalTank(Machine<TileEntityChemicalTank> type) {
        return MekanismBlocks.registerTieredBlock(type, "_chemical_tank", (MapColor color) -> new BlockTile.BlockTileModel(type, properties -> properties.mapColor(color)), ItemBlockChemicalTank::new).forItemHolder(holder -> holder.addAttachedContainerCapabilities(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addTank(ComponentBackedChemicalTankTank::create).build(), new IMekanismConfig[0]).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalDrainSlot(0).addChemicalFillSlot(0).build()));
    }

    private static <TILE extends TileEntityFactory<?>> BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory> registerFactory(Factory<TILE> type) {
        FactoryTier tier = (FactoryTier)type.get(AttributeTier.class).tier();
        BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory> factory = MekanismBlocks.registerTieredBlock(tier, "_" + type.getFactoryType().getRegistryNameComponent() + "_factory", () -> new BlockFactoryMachine.BlockFactory(type), ItemBlockFactory::new);
        factory.forItemHolder(holder -> {
            int processes = tier.processes;
            Predicate<ItemStack> recipeInputPredicate = switch (type.getFactoryType()) {
                default -> throw new MatchException(null, null);
                case FactoryType.SMELTING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.SMELTING.getInputCache()).containsInput(null, s);
                case FactoryType.ENRICHING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.ENRICHING.getInputCache()).containsInput(null, s);
                case FactoryType.CRUSHING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.CRUSHING.getInputCache()).containsInput(null, s);
                case FactoryType.COMPRESSING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.COMPRESSING.getInputCache()).containsInputA(null, s);
                case FactoryType.COMBINING -> s -> ((InputRecipeCache.DoubleItem)MekanismRecipeType.COMBINING.getInputCache()).containsInputA(null, s);
                case FactoryType.PURIFYING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.PURIFYING.getInputCache()).containsInputA(null, s);
                case FactoryType.INJECTING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.INJECTING.getInputCache()).containsInputA(null, s);
                case FactoryType.INFUSING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.METALLURGIC_INFUSING.getInputCache()).containsInputA(null, s);
                case FactoryType.SAWING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.SAWING.getInputCache()).containsInput(null, s);
            };
            switch (type.getFactoryType()) {
                case SMELTING: 
                case ENRICHING: 
                case CRUSHING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addEnergy().build());
                    break;
                }
                case COMPRESSING: 
                case PURIFYING: 
                case INJECTING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> {
                        ChemicalTanksBuilder chemicalTanksBuilder = ChemicalTanksBuilder.builder();
                        long l = 210L * (long)processes;
                        return chemicalTanksBuilder.addBasic(l, switch (type.getFactoryType()) {
                            case FactoryType.COMPRESSING -> MekanismRecipeType.COMPRESSING;
                            case FactoryType.INJECTING -> MekanismRecipeType.INJECTING;
                            case FactoryType.PURIFYING -> MekanismRecipeType.PURIFYING;
                            default -> throw new IllegalStateException("Factory type doesn't have a known gas recipe");
                        }, DoubleInputRecipeCache::containsInputB).build();
                    }).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addChemicalFillOrConvertSlot(0).addEnergy().build());
                    break;
                }
                case COMBINING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addInput(MekanismRecipeType.COMBINING, DoubleInputRecipeCache::containsInputB).addEnergy().build());
                    break;
                }
                case INFUSING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(1000L * (long)processes, MekanismRecipeType.METALLURGIC_INFUSING, DoubleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addInfusionFillOrConvertSlot(0).addEnergy().build());
                    break;
                }
                case SAWING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate, true).addEnergy().build());
                }
            }
        });
        return factory;
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(BlockType type, String suffix, Function<MapColor, ? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        Object tier = type.get(AttributeTier.class).tier();
        return MekanismBlocks.registerTieredBlock(tier, suffix, () -> (Block)blockSupplier.apply(tier.getBaseTier().getMapColor()), itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(BlockType type, String suffix, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return MekanismBlocks.registerTieredBlock(type.get(AttributeTier.class).tier(), suffix, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(ITier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return BLOCKS.register(tier.getBaseTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }

    private static OreBlockType registerOre(OreType ore) {
        String name = ore.getResource().getRegistrySuffix() + "_ore";
        BlockRegistryObject<BlockOre, ItemBlockTooltip<BlockOre>> stoneOre = MekanismBlocks.registerBlock(name, () -> new BlockOre(ore));
        BlockRegistryObject<BlockOre, ItemBlockTooltip<BlockOre>> deepslateOre = BLOCKS.register("deepslate_" + name, () -> new BlockOre(ore, BlockBehaviour.Properties.ofLegacyCopy(stoneOre.getBlock()).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE)), ItemBlockTooltip::new);
        return new OreBlockType(stoneOre, deepslateOre);
    }

    private static <BLOCK extends Block> BlockRegistryObject<BLOCK, ItemBlockTooltip<BLOCK>> registerBlock(String name, Supplier<? extends BLOCK> blockSupplier) {
        return BLOCKS.register(name, blockSupplier, (x$0, x$1) -> new ItemBlockTooltip<Block>((Block)x$0, (Item.Properties)x$1));
    }

    private static <BLOCK extends Block> BlockRegistryObject<BLOCK, ItemBlockTooltip<BLOCK>> registerBlock(String name, Supplier<? extends BLOCK> blockSupplier, Rarity rarity) {
        return BLOCKS.register(name, blockSupplier, (block, props) -> new ItemBlockTooltip<Block>((Block)block, props.rarity(rarity)));
    }

    public static BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory> getFactory(@NotNull FactoryTier tier, @NotNull FactoryType type) {
        return (BlockRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory>[] getFactoryBlocks() {
        return FACTORIES.values().toArray(new BlockRegistryObject[0]);
    }

    static {
        for (FactoryTier factoryTier : EnumUtils.FACTORY_TIERS) {
            for (FactoryType type : EnumUtils.FACTORY_TYPES) {
                FACTORIES.put((Object)factoryTier, (Object)type, MekanismBlocks.registerFactory(MekanismBlockTypes.getFactory(factoryTier, type)));
            }
        }
        for (Enum enum_ : EnumUtils.PRIMARY_RESOURCES) {
            BlockResourceInfo rawResource;
            if (((PrimaryResource)enum_).getResourceBlockInfo() != null) {
                PROCESSED_RESOURCE_BLOCKS.put((IResource)((Object)enum_), MekanismBlocks.registerResourceBlock(((PrimaryResource)enum_).getResourceBlockInfo()));
            }
            if ((rawResource = ((PrimaryResource)enum_).getRawResourceBlockInfo()) == null) continue;
            PROCESSED_RESOURCE_BLOCKS.put(rawResource, MekanismBlocks.registerResourceBlock(rawResource));
        }
        for (Enum enum_ : EnumUtils.ORE_TYPES) {
            ORES.put((OreType)enum_, MekanismBlocks.registerOre((OreType)enum_));
        }
        BRONZE_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.BRONZE);
        REFINED_OBSIDIAN_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.REFINED_OBSIDIAN);
        CHARCOAL_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.CHARCOAL);
        REFINED_GLOWSTONE_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.REFINED_GLOWSTONE);
        STEEL_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.STEEL);
        FLUORITE_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.FLUORITE);
        BASIC_BIN = MekanismBlocks.registerBin(MekanismBlockTypes.BASIC_BIN);
        ADVANCED_BIN = MekanismBlocks.registerBin(MekanismBlockTypes.ADVANCED_BIN);
        ELITE_BIN = MekanismBlocks.registerBin(MekanismBlockTypes.ELITE_BIN);
        ULTIMATE_BIN = MekanismBlocks.registerBin(MekanismBlockTypes.ULTIMATE_BIN);
        CREATIVE_BIN = MekanismBlocks.registerBin(MekanismBlockTypes.CREATIVE_BIN);
        TELEPORTER_FRAME = MekanismBlocks.registerBlock("teleporter_frame", () -> new BlockBase<BlockType>(MekanismBlockTypes.TELEPORTER_FRAME, properties -> properties.strength(5.0f, 6.0f).mapColor(BlockResourceInfo.STEEL.getMapColor())));
        STEEL_CASING = MekanismBlocks.registerBlock("steel_casing", () -> new BlockBase<BlockType>(MekanismBlockTypes.STEEL_CASING, properties -> properties.strength(3.5f, 9.0f).mapColor(BlockResourceInfo.STEEL.getMapColor())));
        DYNAMIC_TANK = MekanismBlocks.registerBlock("dynamic_tank", () -> new BlockBasicMultiblock<TileEntityDynamicTank>(MekanismBlockTypes.DYNAMIC_TANK, properties -> properties.mapColor(MapColor.COLOR_GRAY)));
        STRUCTURAL_GLASS = MekanismBlocks.registerBlock("structural_glass", () -> new BlockStructuralGlass<TileEntityStructuralGlass>(MekanismBlockTypes.STRUCTURAL_GLASS));
        DYNAMIC_VALVE = MekanismBlocks.registerBlock("dynamic_valve", () -> new BlockBasicMultiblock<TileEntityDynamicValve>(MekanismBlockTypes.DYNAMIC_VALVE, properties -> properties.mapColor(MapColor.COLOR_GRAY)));
        THERMAL_EVAPORATION_CONTROLLER = MekanismBlocks.registerBlock("thermal_evaporation_controller", () -> new BlockBasicMultiblock<TileEntityThermalEvaporationController>(MekanismBlockTypes.THERMAL_EVAPORATION_CONTROLLER, properties -> properties.mapColor(BlockResourceInfo.BRONZE.getMapColor())));
        THERMAL_EVAPORATION_VALVE = MekanismBlocks.registerBlock("thermal_evaporation_valve", () -> new BlockBasicMultiblock<TileEntityThermalEvaporationValve>(MekanismBlockTypes.THERMAL_EVAPORATION_VALVE, properties -> properties.mapColor(BlockResourceInfo.BRONZE.getMapColor())));
        THERMAL_EVAPORATION_BLOCK = MekanismBlocks.registerBlock("thermal_evaporation_block", () -> new BlockBasicMultiblock<TileEntityThermalEvaporationBlock>(MekanismBlockTypes.THERMAL_EVAPORATION_BLOCK, properties -> properties.mapColor(BlockResourceInfo.BRONZE.getMapColor())));
        INDUCTION_CASING = MekanismBlocks.registerBlock("induction_casing", () -> new BlockBasicMultiblock<TileEntityInductionCasing>(MekanismBlockTypes.INDUCTION_CASING, properties -> properties.mapColor(MapColor.COLOR_LIGHT_GRAY)));
        INDUCTION_PORT = MekanismBlocks.registerBlock("induction_port", () -> new BlockBasicMultiblock<TileEntityInductionPort>(MekanismBlockTypes.INDUCTION_PORT, properties -> properties.mapColor(MapColor.COLOR_LIGHT_GRAY)));
        BASIC_INDUCTION_CELL = MekanismBlocks.registerInductionCell(MekanismBlockTypes.BASIC_INDUCTION_CELL);
        ADVANCED_INDUCTION_CELL = MekanismBlocks.registerInductionCell(MekanismBlockTypes.ADVANCED_INDUCTION_CELL);
        ELITE_INDUCTION_CELL = MekanismBlocks.registerInductionCell(MekanismBlockTypes.ELITE_INDUCTION_CELL);
        ULTIMATE_INDUCTION_CELL = MekanismBlocks.registerInductionCell(MekanismBlockTypes.ULTIMATE_INDUCTION_CELL);
        BASIC_INDUCTION_PROVIDER = MekanismBlocks.registerInductionProvider(MekanismBlockTypes.BASIC_INDUCTION_PROVIDER);
        ADVANCED_INDUCTION_PROVIDER = MekanismBlocks.registerInductionProvider(MekanismBlockTypes.ADVANCED_INDUCTION_PROVIDER);
        ELITE_INDUCTION_PROVIDER = MekanismBlocks.registerInductionProvider(MekanismBlockTypes.ELITE_INDUCTION_PROVIDER);
        ULTIMATE_INDUCTION_PROVIDER = MekanismBlocks.registerInductionProvider(MekanismBlockTypes.ULTIMATE_INDUCTION_PROVIDER);
        SUPERHEATING_ELEMENT = MekanismBlocks.registerBlock("superheating_element", () -> new BlockTile(MekanismBlockTypes.SUPERHEATING_ELEMENT, properties -> properties.mapColor(MapColor.COLOR_GRAY)));
        PRESSURE_DISPERSER = MekanismBlocks.registerBlock("pressure_disperser", () -> new BlockTile(MekanismBlockTypes.PRESSURE_DISPERSER, properties -> properties.mapColor(MapColor.DEEPSLATE)));
        BOILER_CASING = MekanismBlocks.registerBlock("boiler_casing", () -> new BlockBasicMultiblock<TileEntityBoilerCasing>(MekanismBlockTypes.BOILER_CASING, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())));
        BOILER_VALVE = MekanismBlocks.registerBlock("boiler_valve", () -> new BlockBasicMultiblock<TileEntityBoilerValve>(MekanismBlockTypes.BOILER_VALVE, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())));
        SECURITY_DESK = BLOCKS.register("security_desk", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.SECURITY_DESK, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), ItemBlockSecurityDesk::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addUnlockSlot().addLockSlot().build()));
        RADIOACTIVE_WASTE_BARREL = BLOCKS.register("radioactive_waste_barrel", BlockRadioactiveWasteBarrel::new, ItemBlockRadioactiveWasteBarrel::new);
        INDUSTRIAL_ALARM = BLOCKS.registerDetails("industrial_alarm", BlockIndustrialAlarm::new);
        ENRICHMENT_CHAMBER = BLOCKS.register("enrichment_chamber", () -> new BlockFactoryMachine(MekanismBlockTypes.ENRICHMENT_CHAMBER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockFactoryMachine>((BlockFactoryMachine)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ELECTRIC_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.ENRICHING, SingleInputRecipeCache::containsInput).addOutput().addEnergy().build()));
        OSMIUM_COMPRESSOR = BLOCKS.register("osmium_compressor", () -> new BlockFactoryMachine(MekanismBlockTypes.OSMIUM_COMPRESSOR, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockFactoryMachine>((BlockFactoryMachine)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ADVANCED_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(210L, MekanismRecipeType.COMPRESSING, DoubleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.COMPRESSING, DoubleInputRecipeCache::containsInputA).addChemicalFillOrConvertSlot(0).addOutput().addEnergy().build()));
        COMBINER = BLOCKS.register("combiner", () -> new BlockFactoryMachine(MekanismBlockTypes.COMBINER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockFactoryMachine>((BlockFactoryMachine)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.EXTRA_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.COMBINING, DoubleInputRecipeCache::containsInputA).addInput(MekanismRecipeType.COMBINING, DoubleInputRecipeCache::containsInputB).addOutput().addEnergy().build()));
        CRUSHER = BLOCKS.register("crusher", () -> new BlockFactoryMachine(MekanismBlockTypes.CRUSHER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockFactoryMachine>((BlockFactoryMachine)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ELECTRIC_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.CRUSHING, SingleInputRecipeCache::containsInput).addOutput().addEnergy().build()));
        DIGITAL_MINER = BLOCKS.register("digital_miner", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.DIGITAL_MINER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.EJECT, (Object)false).component(MekanismDataComponents.PULL, (Object)false).component(MekanismDataComponents.SILK_TOUCH, (Object)false).component(MekanismDataComponents.INVERSE, (Object)false).component(MekanismDataComponents.INVERSE_REQUIRES_REPLACE, (Object)false).component(MekanismDataComponents.RADIUS, (Object)10).component(MekanismDataComponents.MIN_Y, (Object)0).component(MekanismDataComponents.MAX_Y, (Object)60).component(MekanismDataComponents.REPLACE_STACK, (Object)Items.AIR).component(MekanismDataComponents.OVERFLOW_AWARE, (Object)OverflowAware.EMPTY).component(MekanismDataComponents.FILTER_AWARE, (Object)FilterAware.EMPTY))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addMinerSlots(27).addEnergy().build()));
        METALLURGIC_INFUSER = BLOCKS.register("metallurgic_infuser", () -> new BlockFactoryMachine.BlockFactoryMachineModel(MekanismBlockTypes.METALLURGIC_INFUSER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockFactoryMachine.BlockFactoryMachineModel>((BlockFactoryMachine.BlockFactoryMachineModel)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ADVANCED_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(1000L, MekanismRecipeType.METALLURGIC_INFUSING, DoubleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInfusionFillOrConvertSlot(0).addInput(MekanismRecipeType.METALLURGIC_INFUSING, DoubleInputRecipeCache::containsInputA).addOutput().addEnergy().build()));
        PURIFICATION_CHAMBER = BLOCKS.register("purification_chamber", () -> new BlockFactoryMachine(MekanismBlockTypes.PURIFICATION_CHAMBER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockFactoryMachine>((BlockFactoryMachine)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ADVANCED_MACHINE_INPUT_ONLY))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(210L, MekanismRecipeType.PURIFYING, DoubleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.PURIFYING, DoubleInputRecipeCache::containsInputA).addChemicalFillOrConvertSlot(0).addOutput().addEnergy().build()));
        ENERGIZED_SMELTER = BLOCKS.register("energized_smelter", () -> new BlockFactoryMachine(MekanismBlockTypes.ENERGIZED_SMELTER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockFactoryMachine>((BlockFactoryMachine)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ELECTRIC_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.SMELTING, SingleInputRecipeCache::containsInput).addOutput().addEnergy().build()));
        TELEPORTER = BLOCKS.register("teleporter", () -> new BlockTile(MekanismBlockTypes.TELEPORTER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), ItemBlockTeleporter::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addEnergy().build()));
        ELECTRIC_PUMP = BLOCKS.registerDetails("electric_pump", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.ELECTRIC_PUMP, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(10000).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidDrainSlot(0).addOutput().addEnergy().build()));
        PERSONAL_BARREL = BLOCKS.register("personal_barrel", BlockPersonalBarrel::new, (block, properties) -> new ItemBlockPersonalStorage<BlockPersonalBarrel>((BlockPersonalBarrel)block, (Item.Properties)properties, Stats.OPEN_BARREL));
        PERSONAL_CHEST = BLOCKS.register("personal_chest", BlockPersonalChest::new, (block, properties) -> new ItemBlockPersonalStorage<BlockPersonalChest>((BlockPersonalChest)block, (Item.Properties)properties, Stats.OPEN_CHEST));
        CHARGEPAD = BLOCKS.registerDetails("chargepad", BlockChargepad::new);
        LOGISTICAL_SORTER = BLOCKS.register("logistical_sorter", BlockLogisticalSorter::new, (block, properties) -> new ItemBlockTooltip<BlockLogisticalSorter>((BlockLogisticalSorter)block, true, properties.component(MekanismDataComponents.EJECT, (Object)false).component(MekanismDataComponents.ROUND_ROBIN, (Object)false).component(MekanismDataComponents.SINGLE_ITEM, (Object)false).component(MekanismDataComponents.FILTER_AWARE, (Object)FilterAware.EMPTY)));
        ROTARY_CONDENSENTRATOR = BLOCKS.register("rotary_condensentrator", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.ROTARY_CONDENSENTRATOR, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.ROTARY_MODE, (Object)false).component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ROTARY))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(10000, MekanismRecipeType.ROTARY, RotaryInputRecipeCache::containsInput).build()).addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L, MekanismRecipeType.ROTARY, RotaryInputRecipeCache::containsInput).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalRotaryDrainSlot(0).addChemicalRotaryFillSlot(0).addFluidRotarySlot(0).addOutput().addEnergy().build()));
        CHEMICAL_OXIDIZER = BLOCKS.register("chemical_oxidizer", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHEMICAL_OXIDIZER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.CHEMICAL_OUT_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.OXIDIZING, SingleInputRecipeCache::containsInput).addChemicalDrainSlot(0).addEnergy().build()));
        CHEMICAL_INFUSER = BLOCKS.register("chemical_infuser", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHEMICAL_INFUSER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.CHEMICAL_INFUSING))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L, MekanismRecipeType.CHEMICAL_INFUSING, EitherSideInputRecipeCache::containsInput).addBasic(10000L, MekanismRecipeType.CHEMICAL_INFUSING, EitherSideInputRecipeCache::containsInput).addBasic(10000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalFillSlot(0).addChemicalFillSlot(1).addChemicalDrainSlot(2).addEnergy().build()));
        CHEMICAL_INJECTION_CHAMBER = BLOCKS.register("chemical_injection_chamber", () -> new BlockFactoryMachine(MekanismBlockTypes.CHEMICAL_INJECTION_CHAMBER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockFactoryMachine>((BlockFactoryMachine)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ADVANCED_MACHINE_INPUT_ONLY))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(210L, MekanismRecipeType.INJECTING, DoubleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.INJECTING, DoubleInputRecipeCache::containsInputA).addChemicalFillOrConvertSlot(0).addOutput().addEnergy().build()));
        ELECTROLYTIC_SEPARATOR = BLOCKS.register("electrolytic_separator", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.ELECTROLYTIC_SEPARATOR, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.DUMP_MODE, (Object)TileEntityChemicalTank.GasMode.IDLE).component(MekanismDataComponents.SECONDARY_DUMP_MODE, (Object)TileEntityChemicalTank.GasMode.IDLE).component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.SEPARATOR))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(24000, MekanismRecipeType.SEPARATING, SingleInputRecipeCache::containsInput).build()).addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(2400L).addBasic(2400L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidFillSlot(0).addChemicalDrainSlot(0).addChemicalDrainSlot(1).addEnergy().build()));
        PRECISION_SAWMILL = BLOCKS.register("precision_sawmill", () -> new BlockFactoryMachine(MekanismBlockTypes.PRECISION_SAWMILL, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockFactoryMachine>((BlockFactoryMachine)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ELECTRIC_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.SAWING, SingleInputRecipeCache::containsInput).addOutput().addOutput().addEnergy().build()));
        CHEMICAL_DISSOLUTION_CHAMBER = BLOCKS.register("chemical_dissolution_chamber", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHEMICAL_DISSOLUTION_CHAMBER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.DISSOLUTION))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L, MekanismRecipeType.DISSOLUTION, DoubleInputRecipeCache::containsInputB).addBasic(() -> 10000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalFillOrConvertSlot(0).addInput(MekanismRecipeType.DISSOLUTION, DoubleInputRecipeCache::containsInputA).addChemicalDrainSlot(1).addEnergy().build()));
        CHEMICAL_WASHER = BLOCKS.register("chemical_washer", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHEMICAL_WASHER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.WASHER))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(10000, MekanismRecipeType.WASHING, DoubleInputRecipeCache::containsInputA).build()).addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L, MekanismRecipeType.WASHING, DoubleInputRecipeCache::containsInputB).addBasic(10000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidFillSlot(0).addOutput().addChemicalDrainSlot(1).addEnergy().build()));
        CHEMICAL_CRYSTALLIZER = BLOCKS.register("chemical_crystallizer", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHEMICAL_CRYSTALLIZER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.CRYSTALLIZER))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L, MekanismRecipeType.CRYSTALLIZING, SingleInputRecipeCache::containsInput).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalFillSlot(0).addOutput().addEnergy().build()));
        SEISMIC_VIBRATOR = BLOCKS.registerDetails("seismic_vibrator", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.SEISMIC_VIBRATOR, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addEnergy().build()));
        PRESSURIZED_REACTION_CHAMBER = BLOCKS.register("pressurized_reaction_chamber", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.PRESSURIZED_REACTION_CHAMBER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.REACTION))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(10000, MekanismRecipeType.REACTION, TripleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L, MekanismRecipeType.REACTION, TripleInputRecipeCache::containsInputC).addBasic(10000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.REACTION, TripleInputRecipeCache::containsInputA).addOutput().addEnergy().build()));
        ISOTOPIC_CENTRIFUGE = BLOCKS.register("isotopic_centrifuge", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.ISOTOPIC_CENTRIFUGE, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.CENTRIFUGE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L, MekanismRecipeType.CENTRIFUGING, SingleInputRecipeCache::containsInput).addBasic(10000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalFillSlot(0).addChemicalDrainSlot(1).addEnergy().build()));
        NUTRITIONAL_LIQUIFIER = BLOCKS.register("nutritional_liquifier", () -> new BlockTile(MekanismBlockTypes.NUTRITIONAL_LIQUIFIER, properties -> properties.noOcclusion().mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile>((BlockTile)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.LIQUIFIER))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(10000).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(TileEntityNutritionalLiquifier::isValidInput).addOutput().addFluidDrainSlot(0).addOutput().addEnergy().build()));
        BASIC_FLUID_TANK = MekanismBlocks.registerFluidTank(MekanismBlockTypes.BASIC_FLUID_TANK);
        ADVANCED_FLUID_TANK = MekanismBlocks.registerFluidTank(MekanismBlockTypes.ADVANCED_FLUID_TANK);
        ELITE_FLUID_TANK = MekanismBlocks.registerFluidTank(MekanismBlockTypes.ELITE_FLUID_TANK);
        ULTIMATE_FLUID_TANK = MekanismBlocks.registerFluidTank(MekanismBlockTypes.ULTIMATE_FLUID_TANK);
        CREATIVE_FLUID_TANK = MekanismBlocks.registerFluidTank(MekanismBlockTypes.CREATIVE_FLUID_TANK);
        FLUIDIC_PLENISHER = BLOCKS.registerDetails("fluidic_plenisher", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.FLUIDIC_PLENISHER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(10000).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidFillSlot(0).addOutput().addEnergy().build()));
        LASER = BLOCKS.registerDetails("laser", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.LASER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())));
        LASER_AMPLIFIER = BLOCKS.register("laser_amplifier", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.LASER_AMPLIFIER, properties -> properties.mapColor(MapColor.COLOR_GRAY)), ItemBlockLaserAmplifier::new);
        LASER_TRACTOR_BEAM = BLOCKS.register("laser_tractor_beam", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.LASER_TRACTOR_BEAM, properties -> properties.mapColor(MapColor.COLOR_GRAY)), ItemBlockLaserTractorBeam::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addOutput(27).build()));
        QUANTUM_ENTANGLOPORTER = BLOCKS.register("quantum_entangloporter", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.QUANTUM_ENTANGLOPORTER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), ItemBlockQuantumEntangloporter::new);
        SOLAR_NEUTRON_ACTIVATOR = BLOCKS.register("solar_neutron_activator", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.SOLAR_NEUTRON_ACTIVATOR, properties -> properties.mapColor(MapColor.COLOR_BLUE)), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.SNA))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L, MekanismRecipeType.ACTIVATING, SingleInputRecipeCache::containsInput).addBasic(10000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalFillSlot(0).addChemicalDrainSlot(1).build()));
        OREDICTIONIFICATOR = BLOCKS.register("oredictionificator", () -> new BlockTile(MekanismBlockTypes.OREDICTIONIFICATOR, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile>((BlockTile)block, true, properties.component(MekanismDataComponents.FILTER_AWARE, (Object)FilterAware.EMPTY).component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)new AttachedSideConfig(Map.of(TransmissionType.ITEM, AttachedSideConfig.LightConfigInfo.OUT_NO_EJECT))))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addOredictionificatorInput().addOutput().build()));
        RESISTIVE_HEATER = BLOCKS.register("resistive_heater", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.RESISTIVE_HEATER, properties -> properties.mapColor(MapColor.METAL)), ItemBlockResistiveHeater::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.HEAT, () -> HeatCapacitorsBuilder.builder().addBasic(100.0, 5.0, 10.0).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addEnergy().build()));
        FORMULAIC_ASSEMBLICATOR = BLOCKS.register("formulaic_assemblicator", () -> new BlockTile(MekanismBlockTypes.FORMULAIC_ASSEMBLICATOR, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile>((BlockTile)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.EXTRA_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFormulaSlot().addInput(18).addFormulaCraftingSlot(9).addOutput(6).addEnergy().build()));
        FUELWOOD_HEATER = BLOCKS.registerDetails("fuelwood_heater", () -> new BlockTile(MekanismBlockTypes.FUELWOOD_HEATER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.HEAT, () -> HeatCapacitorsBuilder.builder().addBasic(100.0, 5.0, 10.0).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFuelSlot().build()));
        MODIFICATION_STATION = BLOCKS.registerDetails("modification_station", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.MODIFICATION_STATION, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(s -> s.getItem() instanceof IModuleItem).addInput(IModuleHelper.INSTANCE::isModuleContainer).addEnergy().build()));
        ANTIPROTONIC_NUCLEOSYNTHESIZER = BLOCKS.register("antiprotonic_nucleosynthesizer", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.ANTIPROTONIC_NUCLEOSYNTHESIZER, properties -> properties.mapColor(MapColor.METAL)), (block, properties) -> new ItemBlockTooltip<BlockTile.BlockTileModel>((BlockTile.BlockTileModel)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ADVANCED_MACHINE_INPUT_ONLY))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L, MekanismRecipeType.NUCLEOSYNTHESIZING, DoubleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalFillOrConvertSlot(0).addInput(MekanismRecipeType.NUCLEOSYNTHESIZING, DoubleInputRecipeCache::containsInputA).addOutput().addEnergy().build()));
        PIGMENT_EXTRACTOR = BLOCKS.register("pigment_extractor", () -> new BlockTile(MekanismBlockTypes.PIGMENT_EXTRACTOR, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile>((BlockTile)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.CHEMICAL_OUT_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(20000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MekanismRecipeType.PIGMENT_EXTRACTING, SingleInputRecipeCache::containsInput).addChemicalDrainSlot(0).addEnergy().build()));
        PIGMENT_MIXER = BLOCKS.register("pigment_mixer", () -> new BlockTile(MekanismBlockTypes.PIGMENT_MIXER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile>((BlockTile)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.PIGMENT_MIXER))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(1000L, MekanismRecipeType.PIGMENT_MIXING, EitherSideInputRecipeCache::containsInput).addBasic(1000L, MekanismRecipeType.PIGMENT_MIXING, EitherSideInputRecipeCache::containsInput).addBasic(2000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalFillSlot(0).addChemicalFillSlot(1).addChemicalDrainSlot(2).addEnergy().build()));
        PAINTING_MACHINE = BLOCKS.register("painting_machine", () -> new BlockTile(MekanismBlockTypes.PAINTING_MACHINE, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile>((BlockTile)block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.PAINTING))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(15000L, MekanismRecipeType.PAINTING, DoubleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalFillSlot(0).addInput(MekanismRecipeType.PAINTING, DoubleInputRecipeCache::containsInputA).addOutput().addEnergy().build()));
        SPS_CASING = MekanismBlocks.registerBlock("sps_casing", () -> new BlockBasicMultiblock<TileEntitySPSCasing>(MekanismBlockTypes.SPS_CASING, properties -> properties.mapColor(MapColor.COLOR_LIGHT_GRAY)), Rarity.EPIC);
        SPS_PORT = MekanismBlocks.registerBlock("sps_port", () -> new BlockBasicMultiblock<TileEntitySPSPort>(MekanismBlockTypes.SPS_PORT, properties -> properties.mapColor(MapColor.COLOR_LIGHT_GRAY)), Rarity.EPIC);
        SUPERCHARGED_COIL = MekanismBlocks.registerBlock("supercharged_coil", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.SUPERCHARGED_COIL, properties -> properties.mapColor(MapColor.COLOR_ORANGE)), Rarity.EPIC);
        DIMENSIONAL_STABILIZER = BLOCKS.register("dimensional_stabilizer", () -> new BlockTile(MekanismBlockTypes.DIMENSIONAL_STABILIZER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip<BlockTile>((BlockTile)block, true, properties.component(MekanismDataComponents.STABILIZER_CHUNKS, (Object)StabilizedChunks.NONE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addEnergy().build()));
        QIO_DRIVE_ARRAY = BLOCKS.register("qio_drive_array", () -> new BlockQIOComponent(MekanismBlockTypes.QIO_DRIVE_ARRAY, properties -> properties.mapColor(MapColor.METAL)), ItemBlockQIOComponent::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addQIODriveSlots(12).build()));
        QIO_DASHBOARD = BLOCKS.register("qio_dashboard", () -> new BlockQIOComponent(MekanismBlockTypes.QIO_DASHBOARD, properties -> properties.mapColor(MapColor.COLOR_GRAY)), (block, properties) -> new ItemBlockQIOComponent((BlockTile<?, ?>)block, properties.component(MekanismDataComponents.INSERT_INTO_FREQUENCY, (Object)true))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addQIODashboardSlots().build()));
        QIO_IMPORTER = BLOCKS.register("qio_importer", () -> new BlockQIOComponent(MekanismBlockTypes.QIO_IMPORTER, properties -> properties.mapColor(MapColor.COLOR_GRAY)), (block, properties) -> new ItemBlockQIOComponent((BlockTile<?, ?>)block, properties.component(MekanismDataComponents.AUTO, (Object)false).component(MekanismDataComponents.FILTER_AWARE, (Object)FilterAware.EMPTY)));
        QIO_EXPORTER = BLOCKS.register("qio_exporter", () -> new BlockQIOComponent(MekanismBlockTypes.QIO_EXPORTER, properties -> properties.mapColor(MapColor.COLOR_GRAY)), (block, properties) -> new ItemBlockQIOComponent((BlockTile<?, ?>)block, properties.component(MekanismDataComponents.AUTO, (Object)false).component(MekanismDataComponents.ROUND_ROBIN, (Object)false).component(MekanismDataComponents.FILTER_AWARE, (Object)FilterAware.EMPTY)));
        QIO_REDSTONE_ADAPTER = BLOCKS.register("qio_redstone_adapter", () -> new BlockQIOComponent(MekanismBlockTypes.QIO_REDSTONE_ADAPTER, properties -> properties.mapColor(MapColor.COLOR_GRAY)), (block, properties) -> new ItemBlockQIOComponent((BlockTile<?, ?>)block, properties.component(MekanismDataComponents.FUZZY, (Object)false).component(MekanismDataComponents.INVERSE, (Object)false).component(MekanismDataComponents.LONG_AMOUNT, (Object)0L).component(MekanismDataComponents.ITEM_TARGET, Optional.empty())));
        BASIC_ENERGY_CUBE = MekanismBlocks.registerEnergyCube(MekanismBlockTypes.BASIC_ENERGY_CUBE);
        ADVANCED_ENERGY_CUBE = MekanismBlocks.registerEnergyCube(MekanismBlockTypes.ADVANCED_ENERGY_CUBE);
        ELITE_ENERGY_CUBE = MekanismBlocks.registerEnergyCube(MekanismBlockTypes.ELITE_ENERGY_CUBE);
        ULTIMATE_ENERGY_CUBE = MekanismBlocks.registerEnergyCube(MekanismBlockTypes.ULTIMATE_ENERGY_CUBE);
        CREATIVE_ENERGY_CUBE = MekanismBlocks.registerEnergyCube(MekanismBlockTypes.CREATIVE_ENERGY_CUBE);
        BASIC_UNIVERSAL_CABLE = MekanismBlocks.registerUniversalCable(MekanismBlockTypes.BASIC_UNIVERSAL_CABLE);
        ADVANCED_UNIVERSAL_CABLE = MekanismBlocks.registerUniversalCable(MekanismBlockTypes.ADVANCED_UNIVERSAL_CABLE);
        ELITE_UNIVERSAL_CABLE = MekanismBlocks.registerUniversalCable(MekanismBlockTypes.ELITE_UNIVERSAL_CABLE);
        ULTIMATE_UNIVERSAL_CABLE = MekanismBlocks.registerUniversalCable(MekanismBlockTypes.ULTIMATE_UNIVERSAL_CABLE);
        BASIC_MECHANICAL_PIPE = MekanismBlocks.registerMechanicalPipe(MekanismBlockTypes.BASIC_MECHANICAL_PIPE);
        ADVANCED_MECHANICAL_PIPE = MekanismBlocks.registerMechanicalPipe(MekanismBlockTypes.ADVANCED_MECHANICAL_PIPE);
        ELITE_MECHANICAL_PIPE = MekanismBlocks.registerMechanicalPipe(MekanismBlockTypes.ELITE_MECHANICAL_PIPE);
        ULTIMATE_MECHANICAL_PIPE = MekanismBlocks.registerMechanicalPipe(MekanismBlockTypes.ULTIMATE_MECHANICAL_PIPE);
        BASIC_PRESSURIZED_TUBE = MekanismBlocks.registerPressurizedTube(MekanismBlockTypes.BASIC_PRESSURIZED_TUBE);
        ADVANCED_PRESSURIZED_TUBE = MekanismBlocks.registerPressurizedTube(MekanismBlockTypes.ADVANCED_PRESSURIZED_TUBE);
        ELITE_PRESSURIZED_TUBE = MekanismBlocks.registerPressurizedTube(MekanismBlockTypes.ELITE_PRESSURIZED_TUBE);
        ULTIMATE_PRESSURIZED_TUBE = MekanismBlocks.registerPressurizedTube(MekanismBlockTypes.ULTIMATE_PRESSURIZED_TUBE);
        BASIC_LOGISTICAL_TRANSPORTER = MekanismBlocks.registerLogisticalTransporter(MekanismBlockTypes.BASIC_LOGISTICAL_TRANSPORTER);
        ADVANCED_LOGISTICAL_TRANSPORTER = MekanismBlocks.registerLogisticalTransporter(MekanismBlockTypes.ADVANCED_LOGISTICAL_TRANSPORTER);
        ELITE_LOGISTICAL_TRANSPORTER = MekanismBlocks.registerLogisticalTransporter(MekanismBlockTypes.ELITE_LOGISTICAL_TRANSPORTER);
        ULTIMATE_LOGISTICAL_TRANSPORTER = MekanismBlocks.registerLogisticalTransporter(MekanismBlockTypes.ULTIMATE_LOGISTICAL_TRANSPORTER);
        RESTRICTIVE_TRANSPORTER = BLOCKS.register("restrictive_transporter", () -> new BlockLargeTransmitter<TileEntityRestrictiveTransporter>(MekanismBlockTypes.RESTRICTIVE_TRANSPORTER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTransporter(block, (Item.Properties)properties, MekanismLang.DESCRIPTION_RESTRICTIVE));
        DIVERSION_TRANSPORTER = BLOCKS.register("diversion_transporter", () -> new BlockLargeTransmitter<TileEntityDiversionTransporter>(MekanismBlockTypes.DIVERSION_TRANSPORTER, properties -> properties.mapColor(MapColor.COLOR_ORANGE)), (block, properties) -> new ItemBlockTransporter(block, (Item.Properties)properties, MekanismLang.DESCRIPTION_DIVERSION));
        BASIC_THERMODYNAMIC_CONDUCTOR = MekanismBlocks.registerThermodynamicConductor(MekanismBlockTypes.BASIC_THERMODYNAMIC_CONDUCTOR);
        ADVANCED_THERMODYNAMIC_CONDUCTOR = MekanismBlocks.registerThermodynamicConductor(MekanismBlockTypes.ADVANCED_THERMODYNAMIC_CONDUCTOR);
        ELITE_THERMODYNAMIC_CONDUCTOR = MekanismBlocks.registerThermodynamicConductor(MekanismBlockTypes.ELITE_THERMODYNAMIC_CONDUCTOR);
        ULTIMATE_THERMODYNAMIC_CONDUCTOR = MekanismBlocks.registerThermodynamicConductor(MekanismBlockTypes.ULTIMATE_THERMODYNAMIC_CONDUCTOR);
        BOUNDING_BLOCK = BLOCKS.register("bounding_block", BlockBounding::new);
        BASIC_CHEMICAL_TANK = MekanismBlocks.registerChemicalTank(MekanismBlockTypes.BASIC_CHEMICAL_TANK);
        ADVANCED_CHEMICAL_TANK = MekanismBlocks.registerChemicalTank(MekanismBlockTypes.ADVANCED_CHEMICAL_TANK);
        ELITE_CHEMICAL_TANK = MekanismBlocks.registerChemicalTank(MekanismBlockTypes.ELITE_CHEMICAL_TANK);
        ULTIMATE_CHEMICAL_TANK = MekanismBlocks.registerChemicalTank(MekanismBlockTypes.ULTIMATE_CHEMICAL_TANK);
        CREATIVE_CHEMICAL_TANK = MekanismBlocks.registerChemicalTank(MekanismBlockTypes.CREATIVE_CHEMICAL_TANK);
        CARDBOARD_BOX = BLOCKS.register("cardboard_box", BlockCardboardBox::new, ItemBlockCardboardBox::new);
        SALT_BLOCK = BLOCKS.register("block_salt", BlockBehaviour.Properties.of().strength(0.5f).sound(SoundType.SAND).instrument(NoteBlockInstrument.SNARE));
        BIO_FUEL_BLOCK = BLOCKS.register("block_bio_fuel", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(0.5f).sound(SoundType.GRASS).instrument(NoteBlockInstrument.BANJO));
    }
}

