/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.Mekanism;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.registration.MekanismDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityTypeDeferredRegister
extends MekanismDeferredRegister<BlockEntityType<?>> {
    public TileEntityTypeDeferredRegister(String modid) {
        super(Registries.BLOCK_ENTITY_TYPE, modid, TileEntityTypeRegistryObject::new);
    }

    public <BE extends TileEntityMekanism> BlockEntityTypeBuilder<BE> mekBuilder(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
        BooleanSupplier hasSecurity = () -> Attribute.has(block.getBlock(), Attributes.AttributeSecurity.class);
        BlockEntityTypeBuilder<CapabilityTileEntity> builder = this.builder(block, factory).withSimple(IBlockSecurityUtils.INSTANCE.ownerCapability(), hasSecurity).withSimple(IBlockSecurityUtils.INSTANCE.securityCapability(), hasSecurity).with(Capabilities.CHEMICAL.block(), CapabilityTileEntity.CHEMICAL_HANDLER_PROVIDER).with(Capabilities.HEAT, CapabilityTileEntity.HEAT_HANDLER_PROVIDER).with(Capabilities.ITEM.block(), CapabilityTileEntity.ITEM_HANDLER_PROVIDER).with(Capabilities.FLUID.block(), CapabilityTileEntity.FLUID_HANDLER_PROVIDER);
        EnergyCompatUtils.addBlockCapabilities(builder);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities(builder, () -> Attribute.has(block.getBlock(), Attributes.AttributeComputerIntegration.class));
        }
        return builder;
    }

    public <BE extends BlockEntity> BlockEntityTypeBuilder<BE> builder(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
        return new BlockEntityTypeBuilder<BE>(block, factory);
    }

    private <BE extends BlockEntity> TileEntityTypeRegistryObject<BE> registerMek(String name, Supplier<? extends BlockEntityType<BE>> sup) {
        return (TileEntityTypeRegistryObject)super.register(name, sup);
    }

    public void register(@NotNull IEventBus bus) {
        super.register(bus);
        bus.addListener(this::registerCapabilities);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (DeferredHolder entry : this.getEntries()) {
            if (entry instanceof TileEntityTypeRegistryObject) {
                TileEntityTypeRegistryObject tileRO = (TileEntityTypeRegistryObject)entry;
                tileRO.registerCapabilityProviders(event);
                continue;
            }
            if (FMLEnvironment.production) continue;
            throw new IllegalStateException("Expected entry to be a TileEntityTypeRegistryObject");
        }
    }

    public class BlockEntityTypeBuilder<BE extends BlockEntity> {
        private final BlockRegistryObject<?, ?> block;
        private final BlockEntityType.BlockEntitySupplier<? extends BE> factory;
        private final List<TileEntityTypeRegistryObject.CapabilityData<BE, ?, ?>> capabilityProviders = new ArrayList();
        @Nullable
        private BlockEntityTicker<BE> clientTicker;
        @Nullable
        private BlockEntityTicker<BE> serverTicker;

        BlockEntityTypeBuilder(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
            this.block = block;
            this.factory = factory;
        }

        public <CAP, CONTEXT> BlockEntityTypeBuilder<BE> withSimple(BlockCapability<CAP, CONTEXT> capability) {
            return this.withSimple(capability, ConstantPredicates.ALWAYS_TRUE);
        }

        public <CAP, CONTEXT> BlockEntityTypeBuilder<BE> withSimple(BlockCapability<CAP, CONTEXT> capability, BooleanSupplier shouldApply) {
            return this.with(capability, Capabilities.SIMPLE_PROVIDER, shouldApply);
        }

        public <CAP, CONTEXT> BlockEntityTypeBuilder<BE> with(BlockCapability<CAP, CONTEXT> capability, Function<BlockCapability<CAP, CONTEXT>, ICapabilityProvider<? super BE, CONTEXT, CAP>> provider) {
            return this.with(capability, provider.apply(capability));
        }

        public <CAP, CONTEXT> BlockEntityTypeBuilder<BE> with(BlockCapability<CAP, CONTEXT> capability, ICapabilityProvider<? super BE, CONTEXT, CAP> provider) {
            return this.with(capability, provider, ConstantPredicates.ALWAYS_TRUE);
        }

        public <CAP, CONTEXT> BlockEntityTypeBuilder<BE> with(BlockCapability<CAP, CONTEXT> capability, ICapabilityProvider<? super BE, CONTEXT, CAP> provider, BooleanSupplier shouldApply) {
            this.capabilityProviders.add(new TileEntityTypeRegistryObject.CapabilityData<BE, CAP, CONTEXT>(capability, provider, shouldApply));
            return this;
        }

        public BlockEntityTypeBuilder<BE> without(BlockCapability<?, ?> ... capabilities) {
            for (BlockCapability<?, ?> capability : capabilities) {
                Iterator<TileEntityTypeRegistryObject.CapabilityData<BE, ?, ?>> iterator = this.capabilityProviders.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().capability() != capability) continue;
                    iterator.remove();
                }
            }
            return this;
        }

        public BlockEntityTypeBuilder<BE> without(Collection<? extends BlockCapability<?, ?>> capabilities) {
            Iterator<TileEntityTypeRegistryObject.CapabilityData<BE, ?, ?>> iterator = this.capabilityProviders.iterator();
            while (iterator.hasNext()) {
                if (!capabilities.contains(iterator.next().capability())) continue;
                iterator.remove();
            }
            return this;
        }

        public BlockEntityTypeBuilder<BE> clientTicker(BlockEntityTicker<BE> ticker) {
            Preconditions.checkState((this.clientTicker == null ? 1 : 0) != 0, (Object)"Client ticker may only be set once.");
            this.clientTicker = ticker;
            return this;
        }

        public BlockEntityTypeBuilder<BE> serverTicker(BlockEntityTicker<BE> ticker) {
            Preconditions.checkState((this.serverTicker == null ? 1 : 0) != 0, (Object)"Server ticker may only be set once.");
            this.serverTicker = ticker;
            return this;
        }

        public BlockEntityTypeBuilder<BE> commonTicker(BlockEntityTicker<BE> ticker) {
            return this.clientTicker(ticker).serverTicker(ticker);
        }

        public TileEntityTypeRegistryObject<BE> build() {
            TileEntityTypeRegistryObject<BE> holder = TileEntityTypeDeferredRegister.this.registerMek(this.block.getName(), () -> BlockEntityType.Builder.of(this.factory, (Block[])new Block[]{this.block.getBlock()}).build(null));
            holder.tickers(this.clientTicker, this.serverTicker);
            holder.capabilities(this.capabilityProviders.isEmpty() ? null : this.capabilityProviders);
            return holder;
        }
    }
}

