/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup;

import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public interface IDoubleRecipeLookupHandler<INPUT_A, INPUT_B, RECIPE extends MekanismRecipe<?>, INPUT_CACHE extends DoubleInputRecipeCache<INPUT_A, ?, INPUT_B, ?, RECIPE, ?, ?>>
extends IRecipeLookupHandler.IRecipeTypedLookupHandler<RECIPE, INPUT_CACHE> {
    default public boolean containsRecipeAB(INPUT_A inputA, INPUT_B inputB) {
        return ((DoubleInputRecipeCache)this.getRecipeType().getInputCache()).containsInputAB(this.getLevel(), inputA, inputB);
    }

    default public boolean containsRecipeBA(INPUT_A inputA, INPUT_B inputB) {
        return ((DoubleInputRecipeCache)this.getRecipeType().getInputCache()).containsInputBA(this.getLevel(), inputA, inputB);
    }

    default public boolean containsRecipeA(INPUT_A input) {
        return ((DoubleInputRecipeCache)this.getRecipeType().getInputCache()).containsInputA(this.getLevel(), input);
    }

    default public boolean containsRecipeB(INPUT_B input) {
        return ((DoubleInputRecipeCache)this.getRecipeType().getInputCache()).containsInputB(this.getLevel(), input);
    }

    @Nullable
    default public RECIPE findFirstRecipe(INPUT_A inputA, INPUT_B inputB) {
        return ((DoubleInputRecipeCache)this.getRecipeType().getInputCache()).findFirstRecipe(this.getLevel(), inputA, inputB);
    }

    @Nullable
    default public RECIPE findFirstRecipe(IInputHandler<INPUT_A> inputAHandler, IInputHandler<INPUT_B> inputBHandler) {
        return this.findFirstRecipe(inputAHandler.getInput(), inputBHandler.getInput());
    }

    public static interface FluidChemicalRecipeLookupHandler<RECIPE extends MekanismRecipe<?>>
    extends ObjectChemicalRecipeLookupHandler<FluidStack, RECIPE, InputRecipeCache.FluidChemical<RECIPE>> {
    }

    public static interface ItemChemicalRecipeLookupHandler<RECIPE extends MekanismRecipe<?>>
    extends ObjectChemicalRecipeLookupHandler<ItemStack, RECIPE, InputRecipeCache.ItemChemical<RECIPE>> {
    }

    public static interface ObjectChemicalRecipeLookupHandler<INPUT, RECIPE extends MekanismRecipe<?>, INPUT_CACHE extends DoubleInputRecipeCache<INPUT, ?, ChemicalStack, ?, RECIPE, ?, ?>>
    extends IDoubleRecipeLookupHandler<INPUT, ChemicalStack, RECIPE, INPUT_CACHE> {
        @Override
        default public boolean containsRecipeBA(INPUT inputA, Chemical inputB) {
            return this.containsRecipeBA(inputA, inputB.getStack(1L));
        }

        @Override
        default public boolean containsRecipeB(Chemical input) {
            return this.containsRecipeB(input.getStack(1L));
        }
    }

    public static interface DoubleItemRecipeLookupHandler<RECIPE extends MekanismRecipe<?>>
    extends IDoubleRecipeLookupHandler<ItemStack, ItemStack, RECIPE, InputRecipeCache.DoubleItem<RECIPE>> {
    }
}

