/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.qio;

import io.netty.buffer.ByteBuf;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketQIOItemViewerSlotPlace(int count) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketQIOItemViewerSlotPlace> TYPE = new CustomPacketPayload.Type(Mekanism.rl("qio_place"));
    public static final StreamCodec<ByteBuf, PacketQIOItemViewerSlotPlace> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(PacketQIOItemViewerSlotPlace::new, PacketQIOItemViewerSlotPlace::count);

    @NotNull
    public CustomPacketPayload.Type<PacketQIOItemViewerSlotPlace> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        ItemStack curStack;
        QIOItemViewerContainer container;
        QIOFrequency freq;
        AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
        if (abstractContainerMenu instanceof QIOItemViewerContainer && (freq = (container = (QIOItemViewerContainer)abstractContainerMenu).getFrequency()) != null && !(curStack = container.getCarried()).isEmpty() && this.count > 0) {
            ItemStack toAdd = this.count < curStack.getCount() ? curStack.copyWithCount(this.count) : curStack;
            ItemStack rejects = freq.addItem(toAdd);
            int placed = toAdd.getCount() - rejects.getCount();
            if (placed > 0) {
                curStack.shrink(placed);
            }
        }
    }
}

