/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import io.netty.handler.codec.DecoderException;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public record PacketUpdateModuleSettings(int slotId, ModuleConfigTarget<?> target) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketUpdateModuleSettings> TYPE = new CustomPacketPayload.Type(Mekanism.rl("update_module"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateModuleSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PacketUpdateModuleSettings::slotId, ModuleConfigTarget.STREAM_CODEC, PacketUpdateModuleSettings::target, PacketUpdateModuleSettings::new);

    public static PacketUpdateModuleSettings create(int slotId, ModuleData<?> moduleType, int installed, ModuleConfig<?> config) {
        return new PacketUpdateModuleSettings(slotId, new ModuleConfigTarget(moduleType, installed, config));
    }

    @NotNull
    public CustomPacketPayload.Type<PacketUpdateModuleSettings> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getInventory().getItem(this.slotId);
        ModuleContainer container = ModuleHelper.get().getModuleContainer(stack);
        if (container != null && container.has(this.target.moduleType())) {
            try {
                container.replaceModuleConfig((HolderLookup.Provider)player.registryAccess(), stack, this.target.moduleType(), this.target.config(), true);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                context.disconnect((Component)MekanismLang.INVALID_PACKET.translate(e.getMessage()));
            }
        }
    }

    public record ModuleConfigTarget<C>(ModuleData<?> moduleType, int installed, ModuleConfig<C> config) {
        private static final StreamCodec<RegistryFriendlyByteBuf, ModuleData<?>> REGISTRY_CODEC = ByteBufCodecs.registry(MekanismAPI.MODULE_REGISTRY_NAME);
        public static final StreamCodec<RegistryFriendlyByteBuf, ModuleConfigTarget<?>> STREAM_CODEC = StreamCodec.ofMember(ModuleConfigTarget::encode, ModuleConfigTarget::decode);

        private static ModuleConfigTarget<?> decode(RegistryFriendlyByteBuf buffer) {
            ResourceLocation name;
            int installed;
            ModuleData moduleType = (ModuleData)REGISTRY_CODEC.decode((Object)buffer);
            ModuleConfig<?> defaultConfig = moduleType.getNamedConfig(installed = buffer.readVarInt(), name = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer));
            if (defaultConfig == null) {
                throw new DecoderException("Unknown config " + String.valueOf(name) + " for module type: " + String.valueOf(moduleType) + " with " + installed + " modules installed");
            }
            return new ModuleConfigTarget(moduleType, installed, (ModuleConfig)defaultConfig.namedStreamCodec(name).decode((Object)buffer));
        }

        private void encode(RegistryFriendlyByteBuf buffer) {
            REGISTRY_CODEC.encode((Object)buffer, this.moduleType);
            buffer.writeVarInt(this.installed);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)this.config.name());
            this.config.namedStreamCodec(this.config.name()).encode((Object)buffer, this.config);
        }
    }
}

