/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.item.CursedTransporterItemHandler;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.lib.inventory.CollectionTransitRequest;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.HandlerTransitRequest;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.inventory.IAdvancedTransportEjector;
import mekanism.common.util.StackUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransitRequest
implements Iterable<ItemData> {
    private final TransitResponse EMPTY = new TransitResponse(ItemStack.EMPTY, null);

    public static SimpleTransitRequest simple(ItemStack stack) {
        return new SimpleTransitRequest(stack);
    }

    public static TransitRequest anyItem(IItemHandler inventory, int amount) {
        return TransitRequest.definedItem(inventory, amount, Finder.ANY);
    }

    public static TransitRequest definedItem(IItemHandler inventory, int amount, Finder finder) {
        return TransitRequest.definedItem(inventory, 1, amount, finder);
    }

    public static TransitRequest definedItem(IItemHandler inventory, int min, int max, Finder finder) {
        HandlerTransitRequest ret = new HandlerTransitRequest(inventory);
        if (inventory == null) {
            return ret;
        }
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = inventory.extractItem(i, max, true);
            if (stack.isEmpty() || !finder.test(stack)) continue;
            HashedItem hashed = HashedItem.raw(stack);
            int toUse = Math.min(stack.getCount(), max - ret.getCount(hashed));
            if (toUse == 0) continue;
            ret.addItem(StackUtils.size(stack, toUse), i);
        }
        Iterator<ItemData> iterator = ret.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getTotalCount() >= min) continue;
            iterator.remove();
        }
        return ret;
    }

    @NotNull
    public TransitResponse eject(BlockEntity outputter, @Nullable IItemHandler target, int min, Function<LogisticalTransporterBase, EnumColor> outputColor) {
        return this.eject(outputter, outputter.getBlockPos(), target, min, outputColor);
    }

    @NotNull
    public TransitResponse eject(BlockEntity outputter, BlockPos outputterPos, @Nullable IItemHandler target, int min, Function<LogisticalTransporterBase, EnumColor> outputColor) {
        if (this.isEmpty()) {
            return this.getEmptyResponse();
        }
        if (target instanceof CursedTransporterItemHandler) {
            CursedTransporterItemHandler cursed = (CursedTransporterItemHandler)target;
            LogisticalTransporterBase transporter = cursed.getTransporter();
            return transporter.insert(outputter, outputterPos, this, outputColor.apply(transporter), true, min);
        }
        return this.addToInventoryUnchecked(target, min);
    }

    @NotNull
    public TransitResponse addToInventory(Level level, BlockPos pos, @Nullable IItemHandler inventory, int min, boolean force) {
        BlockEntity blockEntity;
        if (this.isEmpty()) {
            return this.getEmptyResponse();
        }
        if (force && (blockEntity = WorldUtils.getTileEntity((BlockGetter)level, pos)) instanceof IAdvancedTransportEjector) {
            IAdvancedTransportEjector sorter = (IAdvancedTransportEjector)blockEntity;
            return sorter.sendHome(this);
        }
        return this.addToInventoryUnchecked(inventory, min);
    }

    @NotNull
    public TransitResponse addToInventoryUnchecked(@Nullable IItemHandler inventory, int min) {
        TransitResponse response;
        if (inventory == null) {
            return this.getEmptyResponse();
        }
        int slots = inventory.getSlots();
        if (slots == 0) {
            return this.getEmptyResponse();
        }
        if (min > 1 && ((response = TransporterManager.getPredictedInsert(inventory, this)).isEmpty() || response.getSendingAmount() < min)) {
            return this.getEmptyResponse();
        }
        for (ItemData data : this) {
            ItemStack origInsert = StackUtils.size(data.getStack(), data.getTotalCount());
            ItemStack toInsert = origInsert.copy();
            for (int i = 0; i < slots; ++i) {
                if (!(toInsert = inventory.insertItem(i, toInsert, false)).isEmpty()) continue;
                return this.createResponse(origInsert, data);
            }
            if (!TransporterManager.didEmit(origInsert, toInsert)) continue;
            return this.createResponse(TransporterManager.getToUse(origInsert, toInsert), data);
        }
        return this.getEmptyResponse();
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @NotNull
    public TransitResponse createResponse(ItemStack inserted, ItemData data) {
        return new TransitResponse(inserted, data);
    }

    @NotNull
    public TransitResponse createSimpleResponse() {
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            ItemData data = (ItemData)iterator.next();
            return this.createResponse(data.getStack(), data);
        }
        return this.getEmptyResponse();
    }

    @NotNull
    public TransitResponse getEmptyResponse() {
        return this.EMPTY;
    }

    public static class TransitResponse {
        private final ItemStack inserted;
        private final ItemData slotData;

        public TransitResponse(@NotNull ItemStack inserted, ItemData slotData) {
            this.inserted = inserted;
            this.slotData = slotData;
        }

        public int getSendingAmount() {
            return this.inserted.getCount();
        }

        public ItemData getSlotData() {
            return this.slotData;
        }

        public ItemStack getStack() {
            return this.inserted;
        }

        public boolean isEmpty() {
            return this.inserted.isEmpty() || this.slotData.getTotalCount() == 0;
        }

        public ItemStack getRejected() {
            if (this.isEmpty()) {
                return ItemStack.EMPTY;
            }
            return this.slotData.getItemType().createStack(this.slotData.getTotalCount() - this.getSendingAmount());
        }

        public ItemStack use(int amount) {
            return this.slotData.use(amount);
        }

        public ItemStack useAll() {
            return this.use(this.getSendingAmount());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransitResponse other = (TransitResponse)o;
            return (this.inserted == other.inserted || ItemStack.matches((ItemStack)this.inserted, (ItemStack)other.inserted)) && this.slotData.equals(other.slotData);
        }

        public int hashCode() {
            int code = ItemStack.hashItemAndComponents((ItemStack)this.inserted);
            code = 31 * code + this.inserted.getCount();
            code = 31 * code + this.slotData.hashCode();
            return code;
        }
    }

    public static class ItemData {
        private final HashedItem itemType;
        protected int totalCount;

        public ItemData(HashedItem itemType) {
            this.itemType = itemType;
        }

        public HashedItem getItemType() {
            return this.itemType;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public ItemStack getStack() {
            return this.getItemType().createStack(this.getTotalCount());
        }

        public ItemStack use(int amount) {
            Mekanism.logger.error("Can't 'use' with this type of TransitResponse: {}", (Object)this.getClass().getName());
            return ItemStack.EMPTY;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemData itemData = (ItemData)o;
            return this.getTotalCount() == itemData.getTotalCount() && this.getItemType().equals(itemData.getItemType());
        }

        public int hashCode() {
            return Objects.hash(this.getItemType(), this.getTotalCount());
        }
    }

    public static class SimpleTransitRequest
    extends CollectionTransitRequest {
        private final List<ItemData> slotData;

        protected SimpleTransitRequest(ItemStack stack) {
            this.slotData = Collections.singletonList(new SimpleItemData(stack));
        }

        public List<ItemData> getItemData() {
            return this.slotData;
        }

        public static class SimpleItemData
        extends ItemData {
            public SimpleItemData(ItemStack stack) {
                super(HashedItem.create(stack));
                this.totalCount = stack.getCount();
            }
        }
    }
}

