/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IBlastingItem;
import mekanism.common.content.gear.IRadialModuleContainerItem;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.content.gear.mekatool.ModuleAttackAmplificationUnit;
import mekanism.common.content.gear.mekatool.ModuleBlastingUnit;
import mekanism.common.content.gear.mekatool.ModuleExcavationEscalationUnit;
import mekanism.common.content.gear.mekatool.ModuleTeleportationUnit;
import mekanism.common.content.gear.mekatool.ModuleVeinMiningUnit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismModules;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMekaTool
extends ItemEnergized
implements IRadialModuleContainerItem,
IBlastingItem {
    private static final ResourceLocation RADIAL_ID = Mekanism.rl("meka_tool");

    public ItemMekaTool(Item.Properties properties) {
        super(IModuleHelper.INSTANCE.applyModuleContainerProperties(properties.rarity(Rarity.EPIC).setNoRepair().stacksTo(1).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.deniesDrops(MekanismTags.Blocks.INCORRECT_FOR_MEKA_TOOL), new Tool.Rule((HolderSet)new AnyHolderSet(BuiltInRegistries.BLOCK.asLookup()), Optional.empty(), Optional.of(true))), 1.0f, 0))));
    }

    public void onDestroyed(@NotNull ItemEntity item, @NotNull DamageSource damageSource) {
        ModuleHelper.INSTANCE.dropModuleContainerContents(item, damageSource);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy(stack, tooltip, true);
            tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.getTranslatedKeyMessage()));
        }
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility action) {
        if (ItemAtomicDisassembler.ALWAYS_SUPPORTED_ACTIONS.contains(action)) {
            IModuleContainer container = this.moduleContainer(stack);
            return container != null && ItemMekaTool.hasEnergyForDigAction(container, StorageUtils.getEnergyContainer(stack, 0));
        }
        IModuleContainer moduleContainer = this.moduleContainer(stack);
        if (moduleContainer != null) {
            for (IModule<?> module : moduleContainer.modules()) {
                if (!module.isEnabled() || !this.canPerformAction(module, moduleContainer, stack, action)) continue;
                return true;
            }
        }
        return false;
    }

    private <MODULE extends ICustomModule<MODULE>> boolean canPerformAction(IModule<MODULE> module, IModuleContainer moduleContainer, ItemStack stack, ItemAbility action) {
        return module.getCustomInstance().canPerformAction(module, moduleContainer, stack, action);
    }

    public static boolean hasEnergyForDigAction(IModuleContainer container, @Nullable IEnergyContainer energyContainer) {
        if (energyContainer != null) {
            long energyAvailable;
            long energyRequired = ItemMekaTool.getDestroyEnergy(container, 0.0f, container.hasEnabled(MekanismModules.SILK_TOUCH_UNIT));
            return energyRequired <= (energyAvailable = energyContainer.getEnergy()) || (double)energyAvailable / (double)energyRequired > (double)1.0E-5f;
        }
        return false;
    }

    public static long getDestroyEnergy(IModuleContainer container, float hardness, boolean silk) {
        return ItemMekaTool.getDestroyEnergy(ItemMekaTool.getDestroyEnergy(container, silk), hardness);
    }

    private static long getDestroyEnergy(IModuleContainer container, boolean silk) {
        long destroyEnergy = ItemMekaTool.getDestroyEnergy(silk);
        IModule<ModuleExcavationEscalationUnit> module = container.getIfEnabled(MekanismModules.EXCAVATION_ESCALATION_UNIT);
        float efficiency = module == null ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : module.getCustomInstance().getEfficiency();
        return MathUtils.clampToLong((float)destroyEnergy * efficiency);
    }

    public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return super.isNotReplaceableByPickAction(stack, player, inventorySlot) || this.hasInstalledModules(stack);
    }

    public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        IModuleContainer container = IModuleHelper.INSTANCE.getModuleContainer(stack);
        int moduleLevel = container == null ? 0 : container.getModuleEnchantmentLevel(enchantment);
        return Math.max(moduleLevel, super.getEnchantmentLevel(stack, enchantment));
    }

    @NotNull
    public ItemEnchantments getAllEnchantments(@NotNull ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemEnchantments enchantments = super.getAllEnchantments(stack, lookup);
        IModuleContainer container = IModuleHelper.INSTANCE.getModuleContainer(stack);
        if (container != null) {
            ItemEnchantments moduleEnchantments = container.moduleBasedEnchantments();
            if (enchantments.isEmpty()) {
                return moduleEnchantments;
            }
            if (!moduleEnchantments.isEmpty()) {
                ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(enchantments);
                for (Object2IntMap.Entry entry : moduleEnchantments.entrySet()) {
                    mutable.upgrade((Holder)entry.getKey(), entry.getIntValue());
                }
                return mutable.toImmutable();
            }
        }
        return enchantments;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        for (IModule module : this.getModules(context.getItemInHand())) {
            InteractionResult result;
            if (!module.isEnabled() || (result = this.onModuleUse(module, context)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.useOn(context);
    }

    private <MODULE extends ICustomModule<MODULE>> InteractionResult onModuleUse(IModule<MODULE> module, UseOnContext context) {
        return module.getCustomInstance().onItemUse(module, context);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        IModuleContainer moduleContainer = this.moduleContainer(stack);
        if (moduleContainer != null) {
            for (IModule<?> module : moduleContainer.modules()) {
                InteractionResult result;
                if (!module.isEnabled() || (result = this.onModuleInteract(module, player, entity, hand, moduleContainer, stack)) == InteractionResult.PASS) continue;
                return result;
            }
        }
        return super.interactLivingEntity(stack, player, entity, hand);
    }

    private <MODULE extends ICustomModule<MODULE>> InteractionResult onModuleInteract(IModule<MODULE> module, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand, IModuleContainer moduleContainer, ItemStack stack) {
        return module.getCustomInstance().onInteract(module, player, entity, hand, moduleContainer, stack);
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return 0.0f;
        }
        long energyRequired = ItemMekaTool.getDestroyEnergy(stack, state.destroySpeed, this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT));
        long energyAvailable = energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL);
        if (energyAvailable < energyRequired) {
            return (float)((double)MekanismConfig.gear.mekaToolBaseEfficiency.get() * ((double)energyAvailable / (double)energyRequired));
        }
        IModule module = this.getEnabledModule(stack, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        return module == null ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : ((ModuleExcavationEscalationUnit)module.getCustomInstance()).getEfficiency();
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            Reference2BooleanMap oreTracker;
            Map<BlockPos, BlockState> blocks;
            Object2IntMap<BlockPos> veinedBlocks;
            ServerPlayer player;
            boolean silk = this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT);
            long modDestroyEnergy = ItemMekaTool.getDestroyEnergy(stack, silk);
            long energyRequired = ItemMekaTool.getDestroyEnergy(modDestroyEnergy, state.getDestroySpeed((BlockGetter)world, pos));
            energyContainer.extract(energyRequired, Action.EXECUTE, AutomationType.MANUAL);
            if (!world.isClientSide && entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).isCreative() && energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL) >= energyRequired && !(veinedBlocks = this.getVeinedBlocks(world, stack, blocks = (blocks = this.getBlastedBlocks(world, (Player)player, stack, pos, state)).isEmpty() && ModuleVeinMiningUnit.canVeinBlock(state) ? Map.of(pos, state) : blocks, (Reference2BooleanMap<Block>)(oreTracker = (Reference2BooleanMap)blocks.values().stream().collect(Collectors.toMap(BlockBehaviour.BlockStateBase::getBlock, bs -> bs.is(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE), (l, r) -> l, Reference2BooleanArrayMap::new))))).isEmpty()) {
                long baseDestroyEnergy = ItemMekaTool.getDestroyEnergy(silk);
                MekanismUtils.veinMineArea(energyContainer, energyRequired, modDestroyEnergy, baseDestroyEnergy, world, pos, player, stack, this, veinedBlocks, ItemMekaTool::getDestroyEnergy, (base, hardness, distance, bs) -> {
                    double multiplier = 0.5 * Math.pow(distance, bs.is(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE) ? 1.5 : 2.0);
                    return MathUtils.ceilToLong((double)ItemMekaTool.getDestroyEnergy(base, hardness) * multiplier);
                });
            }
        }
        return true;
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        IEnergyContainer energyContainer;
        int unitDamage;
        IModule attackAmplificationUnit = this.getEnabledModule(stack, MekanismModules.ATTACK_AMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null && (unitDamage = ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage()) > 0 && (energyContainer = StorageUtils.getEnergyContainer(stack, 0)) != null && !energyContainer.isEmpty()) {
            energyContainer.extract(MathUtils.clampToLong((double)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get() * ((double)unitDamage / 4.0)), Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    @Override
    public Map<BlockPos, BlockState> getBlastedBlocks(Level world, Player player, ItemStack stack, BlockPos pos, BlockState state) {
        int radius;
        IModule blastingUnit;
        if (!player.isShiftKeyDown() && (blastingUnit = this.getEnabledModule(stack, MekanismModules.BLASTING_UNIT)) != null && (radius = ((ModuleBlastingUnit)blastingUnit.getCustomInstance()).getBlastRadius()) > 0 && IBlastingItem.canBlastBlock(world, pos, state)) {
            return IBlastingItem.findPositions(world, pos, player, radius);
        }
        return Collections.emptyMap();
    }

    private Object2IntMap<BlockPos> getVeinedBlocks(Level world, ItemStack stack, Map<BlockPos, BlockState> blocks, Reference2BooleanMap<Block> oreTracker) {
        IModule veinMiningUnit = this.getEnabledModule(stack, MekanismModules.VEIN_MINING_UNIT);
        if (veinMiningUnit != null) {
            ModuleVeinMiningUnit customInstance = (ModuleVeinMiningUnit)veinMiningUnit.getCustomInstance();
            return ModuleVeinMiningUnit.findPositions(world, blocks, customInstance.extended() ? customInstance.getExcavationRange() : 0, oreTracker);
        }
        return (Object2IntMap)blocks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, be -> 0, (l, r) -> l, Object2IntArrayMap::new));
    }

    private static long getDestroyEnergy(boolean silk) {
        return silk ? MekanismConfig.gear.mekaToolEnergyUsageSilk.get() : MekanismConfig.gear.mekaToolEnergyUsage.get();
    }

    public static long getDestroyEnergy(ItemStack itemStack, float hardness, boolean silk) {
        return ItemMekaTool.getDestroyEnergy(ItemMekaTool.getDestroyEnergy(itemStack, silk), hardness);
    }

    private static long getDestroyEnergy(long baseDestroyEnergy, float hardness) {
        return hardness == 0.0f ? Math.max(baseDestroyEnergy / 2L, 1L) : baseDestroyEnergy;
    }

    private static long getDestroyEnergy(ItemStack itemStack, boolean silk) {
        long destroyEnergy = ItemMekaTool.getDestroyEnergy(silk);
        IModule<ModuleExcavationEscalationUnit> module = IModuleHelper.INSTANCE.getIfEnabled(itemStack, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        float efficiency = module == null ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : module.getCustomInstance().getEfficiency();
        return MathUtils.clampToLong((float)destroyEnergy * efficiency);
    }

    @Override
    public void adjustAttributes(ItemAttributeModifierEvent event) {
        int unitDamage;
        ItemStack stack = event.getItemStack();
        double damage = MekanismConfig.gear.mekaToolBaseDamage.get();
        double attackSpeed = MekanismConfig.gear.mekaToolAttackSpeed.get();
        IModule attackAmplificationUnit = this.getEnabledModule(stack, MekanismModules.ATTACK_AMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null && (unitDamage = ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage()) > 0) {
            long energy;
            long energyCost = MathUtils.clampToLong((double)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get() * ((double)unitDamage / 4.0));
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
            long l = energy = energyContainer == null ? 0L : energyContainer.getEnergy();
            damage = energy < energyCost ? (damage += (double)unitDamage * MathUtils.divideToLevel(energy, energyCost)) : (damage += (double)unitDamage);
        }
        event.replaceModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        event.replaceModifier(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        IRadialModuleContainerItem.super.adjustAttributes(event);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        IModule module;
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide() && (module = this.getEnabledModule(stack, MekanismModules.TELEPORTATION_UNIT)) != null) {
            BlockPos pos;
            BlockHitResult result = MekanismUtils.rayTrace(player, MekanismConfig.gear.mekaToolMaxTeleportReach.get());
            if ((!((ModuleTeleportationUnit)module.getCustomInstance()).requiresBlockTarget() || result.getType() != HitResult.Type.MISS) && this.isValidDestinationBlock(world, (pos = result.getBlockPos()).above()) && this.isValidDestinationBlock(world, pos.above(2))) {
                double targetZ;
                double targetY;
                double distance = player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                if (distance < 5.0) {
                    return InteractionResultHolder.pass((Object)stack);
                }
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                long energyNeeded = MathUtils.ceilToLong((double)MekanismConfig.gear.mekaToolEnergyUsageTeleport.get() * (distance / 10.0));
                if (energyContainer == null || energyContainer.getEnergy() < energyNeeded) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                double targetX = (double)pos.getX() + 0.5;
                MekanismTeleportEvent.MekaTool event = new MekanismTeleportEvent.MekaTool(player, targetX, targetY = (double)pos.getY() + 1.5, targetZ = (double)pos.getZ() + 0.5, stack, result);
                if (((MekanismTeleportEvent.MekaTool)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
                if (player.isPassenger()) {
                    player.dismountTo(targetX, targetY, targetZ);
                } else {
                    player.teleportTo(targetX, targetY, targetZ);
                }
                player.resetFallDistance();
                PacketUtils.sendToAllTracking(new PacketPortalFX(pos.above()), world, pos);
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
                return InteractionResultHolder.success((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private boolean isValidDestinationBlock(Level world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.isAir() || MekanismUtils.isLiquidBlock(blockState.getBlock());
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return this.isEnchantable(stack) && super.isBookEnchantable(stack, book);
    }

    public boolean isPrimaryItemFor(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return this.isEnchantable(stack) && super.isPrimaryItemFor(stack, enchantment);
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return this.isEnchantable(stack) && super.supportsEnchantment(stack, enchantment);
    }

    @Override
    public ResourceLocation getRadialIdentifier() {
        return RADIAL_ID;
    }
}

