/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ICapabilityAware;
import mekanism.common.capabilities.radiation.item.RadiationShieldingHandler;
import mekanism.common.integration.gender.GenderCapabilityHelper;
import mekanism.common.registries.MekanismArmorMaterials;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class ItemHazmatSuitArmor
extends ArmorItem
implements ICapabilityAware {
    public ItemHazmatSuitArmor(ArmorItem.Type armorType, Item.Properties properties) {
        super(MekanismArmorMaterials.HAZMAT, armorType, properties.rarity(Rarity.UNCOMMON).stacksTo(1));
    }

    public static double getShieldingByArmor(ArmorItem.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.HELMET -> 0.25;
            case ArmorItem.Type.CHESTPLATE -> 0.4;
            case ArmorItem.Type.LEGGINGS -> 0.2;
            case ArmorItem.Type.BOOTS -> 0.15;
            case ArmorItem.Type.BODY -> 0.0;
        };
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.RADIATION_SHIELDING, (stack, ctx) -> RadiationShieldingHandler.create(ItemHazmatSuitArmor.getShieldingByArmor(this.getType())), new ItemLike[]{this});
        GenderCapabilityHelper.addGenderCapability(event, this);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return ((ArmorMaterial)this.material.value()).enchantmentValue() > 0 && stack.getMaxStackSize() == 1;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return this.isEnchantable(stack) && super.isBookEnchantable(stack, book);
    }

    public boolean isPrimaryItemFor(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return this.isEnchantable(stack) && super.isPrimaryItemFor(stack, enchantment);
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return this.isEnchantable(stack) && super.supportsEnchantment(stack, enchantment);
    }
}

