/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.List;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.api.text.EnumColor;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.BlockData;
import mekanism.common.block.BlockCardboardBox;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.block.ItemBlockMekanism;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.TileEntityCardboardBox;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

public class ItemBlockCardboardBox
extends ItemBlockMekanism<BlockCardboardBox> {
    public ItemBlockCardboardBox(BlockCardboardBox block, Item.Properties properties) {
        super(block, properties.stacksTo(16));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        BlockData existingData = (BlockData)stack.get(MekanismDataComponents.BLOCK_DATA);
        tooltip.add((Component)MekanismLang.BLOCK_DATA.translateColored(EnumColor.INDIGO, BooleanStateDisplay.YesNo.of(existingData != null, true)));
        if (existingData != null) {
            existingData.addToTooltip(tooltip::add);
        }
    }

    private static boolean canReplace(Level world, Player player, BlockPos pos, Direction sideClicked, BlockState state, ItemStack stack) {
        return world.mayInteract(player, pos) && player.mayUseItemAt(pos.relative(sideClicked), sideClicked, stack) && !((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player))).isCanceled();
    }

    @NotNull
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockState state;
        Player player = context.getPlayer();
        if (stack.isEmpty() || player == null) {
            return InteractionResult.PASS;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!(stack.has(MekanismDataComponents.BLOCK_DATA) || player.isShiftKeyDown() || (state = world.getBlockState(pos)).isAir() || state.getDestroySpeed((BlockGetter)world, pos) == -1.0f)) {
            if (state.is(MekanismTags.Blocks.CARDBOARD_BLACKLIST) || ((List)MekanismConfig.general.cardboardModBlacklist.get()).contains(RegistryUtils.getNamespace(state.getBlock())) || !ItemBlockCardboardBox.canReplace(world, player, pos, context.getClickedFace(), state, stack)) {
                return InteractionResult.FAIL;
            }
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
            if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, world, pos, tile)) {
                return InteractionResult.FAIL;
            }
            if (!world.isClientSide) {
                BlockData data = new BlockData((HolderLookup.Provider)world.registryAccess(), state, tile);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                CommonWorldTickHandler.monitoringCardboardBox = true;
                world.setBlock(pos, (BlockState)this.defaultState().setValue((Property)BlockStateHelper.storageProperty, (Comparable)Boolean.valueOf(true)), 35);
                CommonWorldTickHandler.monitoringCardboardBox = false;
                TileEntityCardboardBox box = WorldUtils.getTileEntity(TileEntityCardboardBox.class, (BlockGetter)world, pos);
                if (box != null) {
                    box.setComponents(DataComponentMap.builder().addAll(box.components()).set(MekanismDataComponents.BLOCK_DATA, (Object)data).build());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

