/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot.chemical;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.ItemStackToChemicalRecipe;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalInventorySlot
extends BasicInventorySlot {
    private final Supplier<Level> worldSupplier;
    protected final IChemicalTank chemicalTank;

    public static ChemicalStack getPotentialConversion(@Nullable Level world, ItemStack itemStack) {
        ItemStackToChemicalRecipe foundRecipe = (ItemStackToChemicalRecipe)((InputRecipeCache.SingleItem)MekanismRecipeType.CHEMICAL_CONVERSION.getInputCache()).findTypeBasedRecipe(world, itemStack);
        return foundRecipe == null ? ChemicalStack.EMPTY : foundRecipe.getOutput(itemStack);
    }

    private static Predicate<@NotNull ItemStack> getFillOrConvertExtractPredicate(IChemicalTank chemicalTank, Supplier<Level> levelSupplier) {
        return stack -> {
            ChemicalStack conversion;
            IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability((ItemStack)stack);
            if (handler != null) {
                for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                    if (!chemicalTank.isValid(handler.getChemicalInTank(tank))) continue;
                    return false;
                }
            }
            return (conversion = ChemicalInventorySlot.getPotentialConversion((Level)levelSupplier.get(), stack)).isEmpty() || !chemicalTank.isValid(conversion);
        };
    }

    private static Predicate<@NotNull ItemStack> getFillOrConvertInsertPredicate(IChemicalTank chemicalTank, Supplier<Level> levelSupplier) {
        return stack -> {
            if (ChemicalInventorySlot.fillInsertCheck(chemicalTank, stack)) {
                return true;
            }
            ChemicalStack conversion = ChemicalInventorySlot.getPotentialConversion((Level)levelSupplier.get(), stack);
            if (conversion.isEmpty()) {
                return false;
            }
            if (chemicalTank.insert(conversion, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < conversion.getAmount()) {
                return true;
            }
            return chemicalTank.getNeeded() == 0L && chemicalTank.isTypeEqual(conversion) && chemicalTank.isValid(conversion);
        };
    }

    public static Predicate<@NotNull ItemStack> getFillExtractPredicate(IChemicalTank chemicalTank) {
        return stack -> {
            IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability((ItemStack)stack);
            if (handler != null) {
                for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                    ChemicalStack storedChemical = handler.getChemicalInTank(tank);
                    if (storedChemical.isEmpty() || !chemicalTank.isValid(storedChemical)) continue;
                    return false;
                }
            }
            return true;
        };
    }

    public static boolean fillInsertCheck(IChemicalTank chemicalTank, ItemStack stack) {
        IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        if (handler != null) {
            for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                ChemicalStack chemicalInTank = handler.getChemicalInTank(tank);
                if (chemicalInTank.isEmpty() || chemicalTank.insert(chemicalInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= chemicalInTank.getAmount()) continue;
                return true;
            }
        }
        return false;
    }

    public static Predicate<@NotNull ItemStack> getDrainInsertPredicate(IChemicalTank chemicalTank) {
        return stack -> {
            IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability((ItemStack)stack);
            if (handler != null) {
                if (chemicalTank.isEmpty()) {
                    for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                        if (handler.getChemicalInTank(tank).getAmount() >= handler.getChemicalTankCapacity(tank)) continue;
                        return true;
                    }
                    return false;
                }
                return handler.insertChemical(chemicalTank.getStack(), Action.SIMULATE).getAmount() < chemicalTank.getStored();
            }
            return false;
        };
    }

    public static ChemicalInventorySlot rotaryDrain(IChemicalTank chemicalTank, BooleanSupplier modeSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(chemicalTank, "Chemical tank cannot be null");
        Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null");
        Predicate<@NotNull ItemStack> drainInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank);
        Predicate<@NotNull ItemStack> insertPredicate = stack -> modeSupplier.getAsBoolean() && drainInsertPredicate.test((ItemStack)stack);
        return new ChemicalInventorySlot(chemicalTank, insertPredicate.negate(), insertPredicate, listener, x, y);
    }

    public static ChemicalInventorySlot rotaryFill(IChemicalTank chemicalTank, BooleanSupplier modeSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(chemicalTank, "Chemical tank cannot be null");
        Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null");
        return new ChemicalInventorySlot(chemicalTank, ChemicalInventorySlot.getFillExtractPredicate(chemicalTank), stack -> !modeSupplier.getAsBoolean() && ChemicalInventorySlot.fillInsertCheck(chemicalTank, stack), listener, x, y);
    }

    public static ChemicalInventorySlot fill(IChemicalTank chemicalTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(chemicalTank, "Chemical tank cannot be null");
        return new ChemicalInventorySlot(chemicalTank, ChemicalInventorySlot.getFillExtractPredicate(chemicalTank), stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank, stack), listener, x, y);
    }

    public static ChemicalInventorySlot drain(IChemicalTank chemicalTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(chemicalTank, "Chemical tank cannot be null");
        Predicate<@NotNull ItemStack> insertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank);
        return new ChemicalInventorySlot(chemicalTank, insertPredicate.negate(), insertPredicate, listener, x, y);
    }

    protected ChemicalInventorySlot(IChemicalTank gasTank, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        this(gasTank, () -> null, canExtract, canInsert, listener, x, y);
    }

    protected ChemicalInventorySlot(IChemicalTank chemicalTank, Supplier<Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        this(chemicalTank, worldSupplier, canExtract, canInsert, alwaysTrue, listener, x, y);
    }

    protected ChemicalInventorySlot(IChemicalTank chemicalTank, Supplier<Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
        this.setSlotType(ContainerSlotType.EXTRA);
        this.chemicalTank = chemicalTank;
        this.worldSupplier = worldSupplier;
    }

    public static ChemicalInventorySlot fillOrConvert(IChemicalTank gasTank, Supplier<Level> worldSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(worldSupplier, "World supplier cannot be null");
        return new ChemicalInventorySlot(gasTank, worldSupplier, ChemicalInventorySlot.getFillOrConvertExtractPredicate(gasTank, worldSupplier), ChemicalInventorySlot.getFillOrConvertInsertPredicate(gasTank, worldSupplier), listener, x, y);
    }

    @Nullable
    protected IChemicalHandler getCapability() {
        return (IChemicalHandler)Capabilities.CHEMICAL.getCapability(this.current);
    }

    public void fillTankOrConvert() {
        ChemicalStack output;
        ItemStack itemInput;
        ItemStackToChemicalRecipe foundRecipe;
        if (!(this.isEmpty() || this.chemicalTank.getNeeded() <= 0L || ChemicalInventorySlot.fillChemicalTankFromItem(this, this.chemicalTank, this.getCapability()) || (foundRecipe = (ItemStackToChemicalRecipe)((InputRecipeCache.SingleItem)MekanismRecipeType.CHEMICAL_CONVERSION.getInputCache()).findFirstRecipe(this.worldSupplier.get(), this.current)) == null || (itemInput = foundRecipe.getInput().getMatchingInstance(this.current)).isEmpty() || (output = foundRecipe.getOutput(itemInput)).isEmpty() || !this.chemicalTank.insert(output, Action.SIMULATE, AutomationType.MANUAL).isEmpty())) {
            MekanismUtils.logMismatchedStackSize(this.chemicalTank.insert(output, Action.EXECUTE, AutomationType.MANUAL).getAmount(), 0L);
            int amountUsed = itemInput.getCount();
            MekanismUtils.logMismatchedStackSize(this.shrinkStack(amountUsed, Action.EXECUTE), amountUsed);
        }
    }

    public void fillTank() {
        ChemicalInventorySlot.fillChemicalTank(this, this.chemicalTank, this.getCapability());
    }

    public static void fillChemicalTank(IInventorySlot slot, IChemicalTank chemicalTank, @Nullable IChemicalHandler handler) {
        if (!slot.isEmpty() && chemicalTank.getNeeded() > 0L) {
            ChemicalInventorySlot.fillChemicalTankFromItem(slot, chemicalTank, handler);
        }
    }

    private static boolean fillChemicalTankFromItem(IInventorySlot slot, IChemicalTank chemicalTank, @Nullable IChemicalHandler handler) {
        if (handler != null) {
            ChemicalStack toExtract;
            if (chemicalTank.isEmpty()) {
                toExtract = handler.extractChemical(chemicalTank.getCapacity(), Action.SIMULATE);
            } else {
                ChemicalStack stack = chemicalTank.getStack();
                long amount = chemicalTank.getNeeded();
                toExtract = handler.extractChemical(stack.copyWithAmount(amount), Action.SIMULATE);
            }
            if (!toExtract.isEmpty()) {
                ChemicalStack extractedChemical;
                ChemicalStack simulatedRemainder = chemicalTank.insert(toExtract, Action.SIMULATE, AutomationType.INTERNAL);
                toExtract.shrink(simulatedRemainder.getAmount());
                if (!toExtract.isEmpty() && !(extractedChemical = handler.extractChemical(toExtract, Action.EXECUTE)).isEmpty()) {
                    MekanismUtils.logMismatchedStackSize(chemicalTank.insert(extractedChemical, Action.EXECUTE, AutomationType.INTERNAL).getAmount(), 0L);
                    slot.onContentsChanged();
                    return true;
                }
            }
        }
        return false;
    }

    public void drainTank() {
        ChemicalInventorySlot.drainChemicalTank(this, this.chemicalTank, this.getCapability());
    }

    public static void drainChemicalTank(IInventorySlot slot, IChemicalTank chemicalTank, @Nullable IChemicalHandler handler) {
        ChemicalStack extractedChemical;
        long amount;
        ChemicalStack storedChemical;
        ChemicalStack simulatedRemainder;
        long remainder;
        if (!(slot.isEmpty() || chemicalTank.isEmpty() || handler == null || (remainder = (simulatedRemainder = handler.insertChemical(storedChemical = chemicalTank.getStack(), Action.SIMULATE)).getAmount()) >= (amount = storedChemical.getAmount()) || (extractedChemical = chemicalTank.extract(amount - remainder, Action.EXECUTE, AutomationType.INTERNAL)).isEmpty())) {
            MekanismUtils.logMismatchedStackSize(handler.insertChemical(extractedChemical, Action.EXECUTE).getAmount(), 0L);
            slot.onContentsChanged();
        }
    }
}

