/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.warning.ISupportsWarning;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BasicInventorySlot
implements IInventorySlot {
    public static final Predicate<@NotNull ItemStack> alwaysTrue = ConstantPredicates.alwaysTrue();
    public static final Predicate<@NotNull ItemStack> alwaysFalse = ConstantPredicates.alwaysFalse();
    public static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> alwaysTrueBi = ConstantPredicates.alwaysTrueBi();
    public static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> manualOnly = ConstantPredicates.manualOnly();
    public static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> internalOnly = ConstantPredicates.internalOnly();
    public static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> notExternal = ConstantPredicates.notExternal();
    protected ItemStack current = ItemStack.EMPTY;
    private final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract;
    private final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert;
    private final Predicate<@NotNull ItemStack> validator;
    private final int limit;
    @Nullable
    private final IContentsListener listener;
    private final int x;
    private final int y;
    protected boolean obeyStackLimit = true;
    private ContainerSlotType slotType = ContainerSlotType.NORMAL;
    @Nullable
    private SlotOverlay slotOverlay;
    @Nullable
    private Consumer<ISupportsWarning<?>> warningAdder;

    public static BasicInventorySlot at(@Nullable IContentsListener listener, int x, int y) {
        return BasicInventorySlot.at(alwaysTrue, listener, x, y);
    }

    public static BasicInventorySlot at(Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        return BasicInventorySlot.at(validator, listener, x, y, 99);
    }

    public static BasicInventorySlot at(Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y, int limit) {
        Objects.requireNonNull(validator, "Item validity check cannot be null");
        if (limit < 1) {
            throw new IllegalArgumentException("Slots with a custom limit must allow at least one item");
        }
        return new BasicInventorySlot(limit, alwaysTrueBi, alwaysTrueBi, validator, listener, x, y);
    }

    public static BasicInventorySlot at(Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        return new BasicInventorySlot(canExtract, canInsert, alwaysTrue, listener, x, y);
    }

    public static BasicInventorySlot at(BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, @Nullable IContentsListener listener, int x, int y) {
        return BasicInventorySlot.at(canExtract, canInsert, alwaysTrue, listener, x, y);
    }

    public static BasicInventorySlot at(BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Item validity check cannot be null");
        return new BasicInventorySlot(canExtract, canInsert, validator, listener, x, y);
    }

    protected BasicInventorySlot(Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        this((ItemStack stack, AutomationType automationType) -> automationType == AutomationType.MANUAL || canExtract.test((ItemStack)stack), (ItemStack stack, AutomationType automationType) -> canInsert.test((ItemStack)stack), validator, listener, x, y);
    }

    protected BasicInventorySlot(BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        this(99, canExtract, canInsert, validator, listener, x, y);
    }

    protected BasicInventorySlot(int limit, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        this.limit = limit;
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.validator = validator;
        this.listener = listener;
        this.x = x;
        this.y = y;
    }

    public int getGuiX() {
        return this.x;
    }

    @Override
    public ItemStack getStack() {
        return this.current;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.setStack(stack, true);
    }

    public void setStackUnchecked(ItemStack stack) {
        this.setStack(stack, false);
    }

    private void setStack(ItemStack stack, boolean validateStack) {
        if (stack.isEmpty()) {
            if (this.current.isEmpty()) {
                return;
            }
            this.current = ItemStack.EMPTY;
        } else if (!validateStack || this.isItemValid(stack)) {
            this.current = stack.copy();
        } else {
            throw new RuntimeException("Invalid stack for slot: " + String.valueOf(stack) + " " + String.valueOf(stack.getComponentsPatch()));
        }
        this.onContentsChanged();
    }

    @Override
    public ItemStack insertItem(ItemStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int needed = this.getLimit(stack) - this.current.getCount();
        if (needed <= 0 || !this.isItemValidForInsertion(stack, automationType)) {
            return stack;
        }
        boolean sameType = false;
        if (this.current.isEmpty() || (sameType = ItemStack.isSameItemSameComponents((ItemStack)this.current, (ItemStack)stack))) {
            int toAdd = Math.min(stack.getCount(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.current.grow(toAdd);
                    this.onContentsChanged();
                } else {
                    this.setStackUnchecked(stack.copyWithCount(toAdd));
                }
            }
            return stack.copyWithCount(stack.getCount() - toAdd);
        }
        return stack;
    }

    @Override
    public ItemStack extractItem(int amount, Action action, AutomationType automationType) {
        if (this.current.isEmpty() || amount < 1 || !this.canExtract.test(this.current, automationType)) {
            return ItemStack.EMPTY;
        }
        int currentAmount = Math.min(this.current.getCount(), this.current.getMaxStackSize());
        if (currentAmount < amount) {
            amount = currentAmount;
        }
        ItemStack toReturn = this.current.copyWithCount(amount);
        if (action.execute()) {
            this.current.shrink(amount);
            this.onContentsChanged();
        }
        return toReturn;
    }

    @Override
    public int getLimit(ItemStack stack) {
        return this.obeyStackLimit && !stack.isEmpty() ? Math.min(this.limit, stack.getMaxStackSize()) : this.limit;
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return this.validator.test(stack);
    }

    public boolean isItemValidForInsertion(ItemStack stack, AutomationType automationType) {
        return this.validator.test(stack) && this.canInsert.test(stack, automationType);
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    @Override
    @Nullable
    public InventoryContainerSlot createContainerSlot() {
        return new InventoryContainerSlot(this, this.x, this.y, this.slotType, this.slotOverlay, this.warningAdder, this::setStackUnchecked);
    }

    public void setSlotType(ContainerSlotType slotType) {
        this.slotType = slotType;
    }

    public void tracksWarnings(@Nullable Consumer<ISupportsWarning<?>> warningAdder) {
        this.warningAdder = warningAdder;
    }

    public void setSlotOverlay(@Nullable SlotOverlay slotOverlay) {
        this.slotOverlay = slotOverlay;
    }

    @Nullable
    protected final SlotOverlay getSlotOverlay() {
        return this.slotOverlay;
    }

    protected final ContainerSlotType getSlotType() {
        return this.slotType;
    }

    @Override
    public int setStackSize(int amount, Action action) {
        if (this.current.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0;
        }
        int maxStackSize = this.getLimit(this.current);
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.current.getCount() == amount || action.simulate()) {
            return amount;
        }
        this.current.setCount(amount);
        this.onContentsChanged();
        return amount;
    }

    @Override
    public int growStack(int amount, Action action) {
        int current = this.current.getCount();
        if (current == 0) {
            return 0;
        }
        if (amount > 0) {
            amount = Math.min(amount, this.getLimit(this.current));
        }
        int newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    @Override
    public boolean isEmpty() {
        return this.current.isEmpty();
    }

    @Override
    public int getCount() {
        return this.current.getCount();
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.put("item", SerializerHelper.saveOversized(provider, this.current));
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.setStackUnchecked(SerializerHelper.parseOversizedOptional(provider, nbt.getCompound("item")));
    }
}

