/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory;

import java.util.UUID;
import java.util.function.Supplier;
import mekanism.common.annotations.GLFWMouseButtons;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RegistryUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface ISlotClickHandler {
    public void onClick(Supplier<@Nullable IScrollableSlot> var1, @GLFWMouseButtons int var2, boolean var3, ItemStack var4);

    public static interface IScrollableSlot {
        default public HashedItem asRawHashedItem() {
            HashedItem hashedItem;
            HashedItem item = this.item();
            if (item instanceof HashedItem.UUIDAwareHashedItem) {
                HashedItem.UUIDAwareHashedItem uuidAware = (HashedItem.UUIDAwareHashedItem)item;
                hashedItem = uuidAware.asRawHashedItem();
            } else {
                hashedItem = item;
            }
            return hashedItem;
        }

        public HashedItem item();

        public UUID itemUUID();

        public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long count();

        default public String getDisplayName() {
            return this.getInternalStack().getHoverName().getString();
        }

        default public String getModID() {
            return MekanismUtils.getModId(this.getInternalStack());
        }

        default public ItemStack getInternalStack() {
            return this.item().getInternalStack();
        }

        default public ResourceLocation getRegistryName() {
            return RegistryUtils.getName(this.getInternalStack().getItem());
        }
    }
}

