/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.processors;

import it.unimi.dsi.fastutil.objects.Reference2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMaps;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToLongFunction;
import mekanism.api.MekanismAPI;
import mekanism.api.Upgrade;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.lib.inventory.personalstorage.AbstractPersonalStorageItemInventory;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageManager;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.UpgradeUtils;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.components.DataComponentProcessor;
import moze_intel.projecte.api.components.IDataComponentProcessor;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@DataComponentProcessor
public class MekanismContentsProcessor
implements IDataComponentProcessor {
    private Reference2LongMap<Upgrade> upgradeEmc = Reference2LongMaps.emptyMap();
    private Reference2LongMap<ModuleData<?>> moduleDataEmc = Reference2LongMaps.emptyMap();

    public String getName() {
        return MekanismConfigTranslations.PE_CONTENTS_PROCESSOR.title();
    }

    public String getTranslationKey() {
        return MekanismConfigTranslations.PE_CONTENTS_PROCESSOR.getTranslationKey();
    }

    public String getDescription() {
        return MekanismConfigTranslations.PE_CONTENTS_PROCESSOR.tooltip();
    }

    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long recalculateEMC(@NotNull ItemInfo info, @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long currentEMC) throws ArithmeticException {
        IEMCProxy emcProxy = IEMCProxy.INSTANCE;
        ItemStack stack = info.createStack();
        if ((currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, ContainerType.ITEM.getAttachmentContainersIfPresent(stack))) == 0L) {
            return 0L;
        }
        Optional<AbstractPersonalStorageItemInventory> personalStorage = PersonalStorageManager.getInventoryIfPresent(stack);
        if (personalStorage.isPresent() && (currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, personalStorage.get().getInventorySlots(null))) == 0L) {
            return 0L;
        }
        UpgradeAware upgradeAware = (UpgradeAware)stack.get(MekanismDataComponents.UPGRADES);
        if (upgradeAware != null) {
            for (Map.Entry entry : upgradeAware.upgrades().entrySet()) {
                long upgradeEmc = this.upgradeEmc.getLong(entry.getKey());
                if (upgradeEmc == 0L) {
                    return 0L;
                }
                currentEMC = MekanismContentsProcessor.addEmc(currentEMC, upgradeEmc, (Integer)entry.getValue());
            }
            if ((currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, upgradeAware.asInventorySlots())) == 0L) {
                return 0L;
            }
        }
        for (IModule iModule : IModuleHelper.INSTANCE.getAllModules(stack)) {
            long moduleEmc = this.moduleDataEmc.getLong(iModule.getData());
            if (moduleEmc == 0L) {
                return 0L;
            }
            currentEMC = MekanismContentsProcessor.addEmc(currentEMC, moduleEmc, iModule.getInstalledCount());
        }
        return currentEMC;
    }

    public void updateCachedValues(@Nullable ToLongFunction<ItemInfo> emcLookup) {
        if (emcLookup == null) {
            this.upgradeEmc = Reference2LongMaps.emptyMap();
            this.moduleDataEmc = Reference2LongMaps.emptyMap();
            return;
        }
        this.upgradeEmc = new Reference2LongArrayMap(EnumUtils.UPGRADES.length);
        for (Upgrade upgrade : EnumUtils.UPGRADES) {
            long emc = emcLookup.applyAsLong(ItemInfo.fromItem((ItemLike)UpgradeUtils.getItem(upgrade)));
            if (emc <= 0L) continue;
            this.upgradeEmc.put((Object)upgrade, emc);
        }
        this.moduleDataEmc = new Reference2LongOpenHashMap();
        for (ModuleData moduleData : MekanismAPI.MODULE_REGISTRY) {
            long emc = emcLookup.applyAsLong(ItemInfo.fromItem((ItemLike)moduleData.getItemProvider()));
            if (emc <= 0L) continue;
            this.moduleDataEmc.put((Object)moduleData, emc);
        }
    }

    private static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long addEmc(IEMCProxy emcProxy, @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long currentEMC, List<IInventorySlot> slots) throws ArithmeticException {
        for (IInventorySlot slot : slots) {
            if (slot.isEmpty()) continue;
            ItemStack stack = slot.getStack();
            long itemEmc = emcProxy.getValue(stack);
            if (itemEmc == 0L) {
                return 0L;
            }
            currentEMC = MekanismContentsProcessor.addEmc(currentEMC, itemEmc, stack.getCount());
        }
        return currentEMC;
    }

    private static @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long addEmc(@Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long currentEMC, @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long itemEmc, int count) throws ArithmeticException {
        return Math.addExact(currentEMC, Math.multiplyExact(itemEmc, count));
    }
}

