/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.chemical;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.integration.crafttweaker.ingredient.CrTChemicalStackIngredient;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.chemical.ChemicalStack")
public interface ICrTChemicalStack
extends CommandStringDisplayable,
IChemicalProvider {
    @Override
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="registryName")
    @NotNull
    default public ResourceLocation getRegistryName() {
        return this.getInternal().getTypeRegistryName();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="empty")
    default public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="amount")
    default public long getAmount() {
        return this.getInternal().getAmount();
    }

    @ZenCodeType.Method
    public ICrTChemicalStack setAmount(long var1);

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    default public ICrTChemicalStack multiply(long amount) {
        return this.setAmount(this.getAmount() * amount);
    }

    @ZenCodeType.Method
    default public ICrTChemicalStack grow(long amount) {
        return this.setAmount(this.getAmount() + amount);
    }

    @ZenCodeType.Method
    default public ICrTChemicalStack shrink(long amount) {
        return this.setAmount(this.getAmount() - amount);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean containsOther(ICrTChemicalStack stack) {
        return this.getAmount() >= stack.getAmount() && this.isTypeEqual(stack);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack asMutable();

    @ZenCodeType.Method
    public ICrTChemicalStack asImmutable();

    @ZenCodeType.Method
    public ICrTChemicalStack copy();

    @Override
    @ZenCodeType.Method(value="getType")
    @ZenCodeType.Getter(value="type")
    @ZenCodeType.Caster(implicit=true)
    default public Chemical getChemical() {
        return this.getInternal().getChemical();
    }

    public ChemicalStack getInternal();

    default public ChemicalStack getImmutableInternal() {
        return this.copy().getInternal();
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean isTypeEqual(ICrTChemicalStack stack) {
        return ChemicalStack.isSameChemical(this.getInternal(), stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    default public boolean isEqual(ICrTChemicalStack other) {
        return this.equals(other);
    }

    @ZenCodeType.Caster(implicit=true)
    default public ChemicalStackIngredient asChemicalStackIngredient() {
        return CrTChemicalStackIngredient.from(this);
    }
}

