/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketDumper;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.MekanismAPI;
import mekanism.common.integration.crafttweaker.CrTUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.BracketDumpers")
public class CrTBracketDumpers {
    @BracketDumper(value="chemical", subCommandName="chemicals")
    public static Collection<String> getChemicalStackDump() {
        return CrTBracketDumpers.getDump(MekanismAPI.CHEMICAL_REGISTRY, (V chemical) -> CrTUtils.fromChemical(chemical, 1).getCommandString());
    }

    @BracketDumper(value="robit_skin", subCommandName="robitSkins")
    public static Collection<String> getRobitSkinDump() {
        return CrTBracketDumpers.getDump(MekanismAPI.ROBIT_SKIN_REGISTRY_NAME, "robit_skin");
    }

    @BracketDumper(value="module_data", subCommandName="moduleData")
    public static Collection<String> getModuleDataDump() {
        return CrTBracketDumpers.getDump(MekanismAPI.MODULE_REGISTRY, "module_data");
    }

    private static <V> Collection<String> getDump(Registry<V> registry, String bracket) {
        return CrTBracketDumpers.getDump(registry, (V v) -> "<" + bracket + ":" + String.valueOf(registry.getKey(v)) + ">");
    }

    private static <V> Collection<String> getDump(Registry<V> registry, Function<V, String> getter) {
        return registry.stream().map(getter).toList();
    }

    private static Collection<String> getDump(ResourceKey<? extends Registry<?>> registryKey, String bracket) {
        Optional optionalRegistry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().registry(registryKey);
        if (optionalRegistry.isEmpty()) {
            return Collections.emptyList();
        }
        Registry registry = (Registry)optionalRegistry.get();
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation v : registry.keySet()) {
            list.add("<" + bracket + ":" + String.valueOf(v) + ">");
        }
        return list;
    }
}

