/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.distribution;

import java.util.Collection;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.content.network.transmitter.PressurizedTube;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;

public class ChemicalTransmitterSaveTarget
extends Target<SaveHandler, ChemicalStack> {
    public ChemicalTransmitterSaveTarget(Collection<PressurizedTube> transmitters) {
        super(transmitters.size());
        for (PressurizedTube transmitter : transmitters) {
            this.addHandler(new SaveHandler(transmitter));
        }
    }

    @Override
    protected void acceptAmount(SaveHandler handler, SplitInfo splitInfo, ChemicalStack resource, long amount) {
        handler.acceptAmount(splitInfo, resource, amount);
    }

    @Override
    protected long simulate(SaveHandler handler, ChemicalStack resource, long amount) {
        return handler.simulate(resource.copyWithAmount(amount));
    }

    public void saveShare() {
        for (SaveHandler handler : this.handlers) {
            handler.saveShare();
        }
    }

    public static class SaveHandler {
        private ChemicalStack currentStored = ChemicalStack.EMPTY;
        private final PressurizedTube transmitter;

        public SaveHandler(PressurizedTube transmitter) {
            this.transmitter = transmitter;
        }

        protected void acceptAmount(SplitInfo splitInfo, ChemicalStack resource, long amount) {
            amount = Math.min(amount, this.transmitter.getCapacity() - this.currentStored.getAmount());
            if (this.currentStored.isEmpty()) {
                this.currentStored = resource.copyWithAmount(amount);
            } else {
                this.currentStored.grow(amount);
            }
            splitInfo.send(amount);
        }

        protected Long simulate(ChemicalStack chemicalStack) {
            if (!this.currentStored.isEmpty() && !ChemicalStack.isSameChemical(this.currentStored, chemicalStack)) {
                return 0L;
            }
            return Math.min(chemicalStack.getAmount(), this.transmitter.getCapacity() - this.currentStored.getAmount());
        }

        protected void saveShare() {
            boolean shouldSave = false;
            if (this.currentStored.isEmpty() != this.transmitter.saveShare.isEmpty()) {
                shouldSave = true;
            } else if (!this.currentStored.isEmpty()) {
                boolean bl = shouldSave = !this.currentStored.equals(this.transmitter.saveShare);
            }
            if (shouldSave) {
                this.transmitter.saveShare = this.currentStored.copy();
                this.transmitter.getTransmitterTile().markForSave();
            }
        }
    }
}

