/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Function;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.tags.MekanismTags;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MinerItemStackFilter
extends MinerFilter<MinerItemStackFilter>
implements IItemStackFilter<MinerItemStackFilter> {
    public static final MapCodec<MinerItemStackFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> MinerItemStackFilter.baseMinerCodec(instance).and((App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("target_stack").forGetter(MinerItemStackFilter::getItemStack)).apply((Applicative)instance, MinerItemStackFilter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MinerItemStackFilter> STREAM_CODEC = StreamCodec.composite(MinerItemStackFilter.baseMinerStreamCodec(MinerItemStackFilter::new), Function.identity(), (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, MinerItemStackFilter::getItemStack, (filter, itemType) -> {
        filter.itemType = itemType;
        return filter;
    });
    private ItemStack itemType = ItemStack.EMPTY;

    public MinerItemStackFilter() {
    }

    protected MinerItemStackFilter(boolean enabled, Item replaceTarget, boolean requiresReplacement, ItemStack itemType) {
        super(enabled, replaceTarget, requiresReplacement);
        this.itemType = itemType;
    }

    public MinerItemStackFilter(MinerItemStackFilter filter) {
        super(filter);
        this.itemType = filter.itemType.copy();
    }

    @Override
    public boolean canFilter(BlockState state) {
        ItemStack itemStack = new ItemStack((ItemLike)state.getBlock());
        if (itemStack.isEmpty()) {
            return false;
        }
        return this.itemType.is(itemStack.getItem());
    }

    @Override
    public boolean hasBlacklistedElement() {
        BlockItem blockItem;
        Item item;
        return !this.itemType.isEmpty() && (item = this.itemType.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock().builtInRegistryHolder().is(MekanismTags.Blocks.MINER_BLACKLIST);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.itemType.getItem());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        return this.itemType.getItem() == ((MinerItemStackFilter)o).itemType.getItem();
    }

    @Override
    public MinerItemStackFilter clone() {
        return new MinerItemStackFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_ITEMSTACK_FILTER;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@NotNull ItemStack stack) {
        this.itemType = stack;
    }
}

