/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@ParametersAreNotNullByDefault
public record ModuleJetpackUnit(IJetpackItem.JetpackMode mode, ThrustMultiplier thrustMultiplier, ThrustMultiplier hoverThrustMultiplier) implements ICustomModule<ModuleJetpackUnit>
{
    public static final ResourceLocation JETPACK_MODE = Mekanism.rl("jetpack_mode");
    public static final ResourceLocation JETPACK_MULT = Mekanism.rl("jetpack_mult");
    public static final ResourceLocation JETPACK_HOVER_MULT = Mekanism.rl("jetpack_mult.hover");

    public ModuleJetpackUnit(IModule<ModuleJetpackUnit> module) {
        this((IJetpackItem.JetpackMode)module.getConfigOrThrow(JETPACK_MODE).get(), (ThrustMultiplier)module.getConfigOrThrow(JETPACK_MULT).get(), (ThrustMultiplier)module.getConfigOrThrow(JETPACK_HOVER_MULT).get());
    }

    @Override
    public void addHUDElements(IModule<ModuleJetpackUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player, Consumer<IHUDElement> hudElementAdder) {
        if (module.isEnabled()) {
            IChemicalHandler chemicalHandler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
            if (chemicalHandler == null) {
                hudElementAdder.accept(IModuleHelper.INSTANCE.hudElementPercent(this.mode.getHUDIcon(), 1.0));
            } else {
                ChemicalStack stored = StorageUtils.getContainedChemical(chemicalHandler, MekanismChemicals.HYDROGEN);
                double ratio = StorageUtils.getRatio(stored.getAmount(), chemicalHandler.getChemicalTankCapacity(0));
                hudElementAdder.accept(IModuleHelper.INSTANCE.hudElementPercent(this.mode.getHUDIcon(), ratio));
            }
        }
    }

    @Override
    public void changeMode(IModule<ModuleJetpackUnit> module, Player player, IModuleContainer moduleContainer, ItemStack stack, int shift, boolean displayChangeMessage) {
        IJetpackItem.JetpackMode newMode = (IJetpackItem.JetpackMode)this.mode.adjust(shift);
        if (this.mode != newMode) {
            if (displayChangeMessage) {
                module.displayModeChange(player, (Component)MekanismLang.MODULE_JETPACK_MODE.translate(), newMode);
            }
            moduleContainer.replaceModuleConfig((HolderLookup.Provider)player.registryAccess(), stack, module.getData(), module.getConfigOrThrow(JETPACK_MODE).with(newMode));
        }
    }

    @Override
    public void onRemoved(IModule<ModuleJetpackUnit> module, IModuleContainer moduleContainer, ItemStack stack, boolean last) {
        IChemicalHandler chemicalHandler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        if (chemicalHandler != null) {
            int tanks = chemicalHandler.getChemicalTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                ChemicalStack stored = chemicalHandler.getChemicalInTank(tank);
                if (stored.isEmpty()) continue;
                long capacity = chemicalHandler.getChemicalTankCapacity(tank);
                if (stored.getAmount() <= capacity) continue;
                chemicalHandler.setChemicalInTank(tank, stored.copyWithAmount(capacity));
            }
        }
    }

    public float getThrustMultiplier() {
        if (this.mode == IJetpackItem.JetpackMode.HOVER) {
            return this.hoverThrustMultiplier.getMultiplier();
        }
        return this.thrustMultiplier.getMultiplier();
    }

    @NothingNullByDefault
    public static enum ThrustMultiplier implements IHasTextComponent,
    StringRepresentable
    {
        HALF(0.5f),
        NORMAL(1.0f),
        FAST(2.0f),
        FASTER(3.0f),
        FASTEST(4.0f);

        public static final Codec<ThrustMultiplier> CODEC;
        public static final IntFunction<ThrustMultiplier> BY_ID;
        public static final StreamCodec<ByteBuf, ThrustMultiplier> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final float mult;
        private final Component label;

        private ThrustMultiplier(float mult) {
            this.mult = mult;
            this.label = TextComponentUtil.getString(Float.toString(mult));
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public float getMultiplier() {
            return this.mult;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ThrustMultiplier::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ThrustMultiplier.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

