/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.Map;
import mekanism.api.Action;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

@ParametersAreNotNullByDefault
public record ModuleElectrolyticBreathingUnit(boolean fillHeld) implements ICustomModule<ModuleElectrolyticBreathingUnit>
{
    public static final ResourceLocation FILL_HELD = Mekanism.rl("breathing.held");

    public ModuleElectrolyticBreathingUnit(IModule<ModuleElectrolyticBreathingUnit> module) {
        this(module.getBooleanConfigOrFalse(FILL_HELD));
    }

    @Override
    public void tickServer(IModule<ModuleElectrolyticBreathingUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        int productionRate = 0;
        float eyeHeight = player.getEyeHeight();
        Map<FluidType, MekanismUtils.FluidInDetails> fluidsIn = MekanismUtils.getFluidsIn(player, eyeHeight, (bb, data) -> {
            double centerX = (bb.minX + bb.maxX) / 2.0;
            double centerZ = (bb.minZ + bb.maxZ) / 2.0;
            return new AABB(centerX, Math.min(bb.minY + data - 0.27, bb.maxY), centerZ, centerX, Math.min(bb.minY + data - 0.14, bb.maxY), centerZ);
        });
        if (fluidsIn.entrySet().stream().anyMatch(entry -> entry.getKey() == NeoForgeMod.WATER_TYPE.value() && ((MekanismUtils.FluidInDetails)entry.getValue()).getMaxHeight() >= 0.11)) {
            productionRate = this.getMaxRate(module);
        } else if (player.isInRain()) {
            productionRate = this.getMaxRate(module) / 2;
        }
        if (productionRate > 0) {
            ItemStack handStack;
            IChemicalHandler handCapability;
            IChemicalHandler chestCapability;
            long usage = 2L * MekanismConfig.general.FROM_H2.get();
            int maxRate = MathUtils.clampToInt(Math.min((long)productionRate, module.getContainerEnergy(stack) / usage));
            long hydrogenUsed = 0L;
            ChemicalStack hydrogenStack = MekanismChemicals.HYDROGEN.getStack((long)maxRate * 2L);
            ItemStack chestStack = player.getItemBySlot(EquipmentSlot.CHEST);
            if (this.checkChestPlate(chestStack) && (chestCapability = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(chestStack)) != null) {
                hydrogenUsed = (long)maxRate * 2L - chestCapability.insertChemical(hydrogenStack, Action.EXECUTE).getAmount();
                hydrogenStack.shrink(hydrogenUsed);
            }
            if (this.fillHeld && (handCapability = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(handStack = player.getItemBySlot(EquipmentSlot.MAINHAND))) != null) {
                hydrogenUsed = (long)maxRate * 2L - handCapability.insertChemical(hydrogenStack, Action.EXECUTE).getAmount();
            }
            int oxygenUsed = Math.min(maxRate, player.getMaxAirSupply() - player.getAirSupply());
            long used = Math.max(Mth.ceil((double)((double)hydrogenUsed / 2.0)), oxygenUsed);
            module.useEnergy((LivingEntity)player, stack, MathUtils.multiplyClamped(usage, used));
            player.setAirSupply(player.getAirSupply() + oxygenUsed);
        }
    }

    private boolean checkChestPlate(ItemStack chestPlate) {
        if (chestPlate.is(MekanismItems.MEKASUIT_BODYARMOR)) {
            return IModuleHelper.INSTANCE.getModule(chestPlate, MekanismModules.JETPACK_UNIT) != null;
        }
        return true;
    }

    private int getMaxRate(IModule<ModuleElectrolyticBreathingUnit> module) {
        return (int)Math.pow(2.0, module.getInstalledCount());
    }
}

