/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.function.BooleanSupplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedValue;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CachedBooleanValue
extends CachedValue<Boolean>
implements BooleanSupplier {
    private boolean resolved;
    private boolean cachedValue;

    private CachedBooleanValue(IMekanismConfig config, ModConfigSpec.ConfigValue<Boolean> internal) {
        super(config, internal);
    }

    public static CachedBooleanValue wrap(IMekanismConfig config, ModConfigSpec.ConfigValue<Boolean> internal) {
        return new CachedBooleanValue(config, internal);
    }

    public boolean getOrDefault() {
        if (this.resolved || this.isLoaded()) {
            return this.get();
        }
        return (Boolean)this.internal.getDefault();
    }

    public boolean get() {
        if (!this.resolved) {
            this.cachedValue = (Boolean)this.internal.get();
            this.resolved = true;
        }
        return this.cachedValue;
    }

    @Override
    public boolean getAsBoolean() {
        return this.get();
    }

    public void set(boolean value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (!this.resolved) {
            return false;
        }
        boolean oldCachedValue = this.cachedValue;
        this.resolved = false;
        return checkChanged && oldCachedValue != this.get();
    }
}

