/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.merged;

import java.util.function.BooleanSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.common.capabilities.merged.MergedTank;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

@NothingNullByDefault
public class ChemicalTankWrapper
implements IChemicalTank {
    private final IChemicalTank internal;
    private final BooleanSupplier insertCheck;
    private final MergedTank mergedTank;

    public ChemicalTankWrapper(MergedTank mergedTank, IChemicalTank internal, BooleanSupplier insertCheck) {
        this.mergedTank = mergedTank;
        this.internal = internal;
        this.insertCheck = insertCheck;
    }

    public MergedTank getMergedTank() {
        return this.mergedTank;
    }

    @Override
    public ChemicalStack getStack() {
        return this.internal.getStack();
    }

    @Override
    public void setStack(ChemicalStack stack) {
        this.internal.setStack(stack);
    }

    @Override
    public void setStackUnchecked(ChemicalStack stack) {
        this.internal.setStackUnchecked(stack);
    }

    private boolean canInsert() {
        return this.insertCheck.getAsBoolean();
    }

    @Override
    public ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType) {
        return this.canInsert() ? this.internal.insert(stack, action, automationType) : stack;
    }

    @Override
    public ChemicalStack extract(long amount, Action action, AutomationType automationType) {
        return this.internal.extract(amount, action, automationType);
    }

    @Override
    public long getCapacity() {
        return this.internal.getCapacity();
    }

    @Override
    public boolean isValid(ChemicalStack stack) {
        return this.internal.isValid(stack);
    }

    @Override
    public void onContentsChanged() {
        this.internal.onContentsChanged();
    }

    @Override
    public long setStackSize(long amount, Action action) {
        return this.internal.setStackSize(amount, action);
    }

    @Override
    public long growStack(long amount, Action action) {
        return this.internal.growStack(amount, action);
    }

    @Override
    public long shrinkStack(long amount, Action action) {
        return this.internal.shrinkStack(amount, action);
    }

    @Override
    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    @Override
    public void setEmpty() {
        this.internal.setEmpty();
    }

    @Override
    public long getStored() {
        return this.internal.getStored();
    }

    @Override
    public long getNeeded() {
        return this.internal.getNeeded();
    }

    @Override
    public Chemical getType() {
        return this.internal.getType();
    }

    @Override
    public boolean isTypeEqual(ChemicalStack other) {
        return this.internal.isTypeEqual(other);
    }

    @Override
    public boolean isTypeEqual(Chemical other) {
        return this.internal.isTypeEqual(other);
    }

    @Override
    public ChemicalAttributeValidator getAttributeValidator() {
        return this.internal.getAttributeValidator();
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.internal.serializeNBT(provider);
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.internal.deserializeNBT(provider, nbt);
    }
}

