/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.common.lib.multiblock.MultiblockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class VariableCapacityChemicalTank
extends BasicChemicalTank {
    private final LongSupplier capacity;

    public static IChemicalTank createAllValid(LongSupplier capacity, @Nullable IContentsListener listener) {
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        return new VariableCapacityChemicalTank(capacity, (BiPredicate<Chemical, AutomationType>)alwaysTrueBi, (BiPredicate<Chemical, AutomationType>)alwaysTrueBi, (Predicate<Chemical>)alwaysTrue, ChemicalAttributeValidator.ALWAYS_ALLOW, listener);
    }

    public static IChemicalTank output(LongSupplier capacity, Predicate<Chemical> validator, @Nullable IContentsListener listener) {
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new VariableCapacityChemicalTank(capacity, (BiPredicate<Chemical, AutomationType>)alwaysTrueBi, (BiPredicate<Chemical, AutomationType>)internalOnly, validator, null, listener);
    }

    public static IChemicalTank create(MultiblockData multiblock, LongSupplier capacity, Predicate<Chemical> validator, @Nullable IContentsListener listener) {
        return VariableCapacityChemicalTank.create(capacity, multiblock.formedBiPred(), multiblock.formedBiPred(), validator, null, listener);
    }

    public static IChemicalTank create(LongSupplier capacity, BiPredicate<Chemical, @NotNull AutomationType> canExtract, BiPredicate<Chemical, @NotNull AutomationType> canInsert, Predicate<Chemical> validator, @Nullable IContentsListener listener) {
        return VariableCapacityChemicalTank.create(capacity, canExtract, canInsert, validator, null, listener);
    }

    public static IChemicalTank input(MultiblockData multiblock, LongSupplier capacity, Predicate<Chemical> validator, @Nullable IContentsListener listener) {
        return VariableCapacityChemicalTank.input(multiblock, capacity, validator, null, listener);
    }

    public static IChemicalTank input(MultiblockData multiblock, LongSupplier capacity, Predicate<Chemical> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        return VariableCapacityChemicalTank.create(capacity, multiblock.notExternalFormedBiPred(), multiblock.formedBiPred(), validator, attributeValidator, listener);
    }

    public static IChemicalTank output(MultiblockData multiblock, LongSupplier capacity, Predicate<Chemical> validator, @Nullable IContentsListener listener) {
        return VariableCapacityChemicalTank.output(multiblock, capacity, validator, null, listener);
    }

    public static IChemicalTank output(MultiblockData multiblock, LongSupplier capacity, Predicate<Chemical> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        return VariableCapacityChemicalTank.create(capacity, multiblock.formedBiPred(), multiblock.notExternalFormedBiPred(), validator, attributeValidator, listener);
    }

    public static IChemicalTank create(LongSupplier capacity, BiPredicate<Chemical, @NotNull AutomationType> canExtract, BiPredicate<Chemical, @NotNull AutomationType> canInsert, Predicate<Chemical> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        return new VariableCapacityChemicalTank(capacity, canExtract, canInsert, validator, attributeValidator, listener);
    }

    public VariableCapacityChemicalTank(LongSupplier capacity, BiPredicate<Chemical, @NotNull AutomationType> canExtract, BiPredicate<Chemical, @NotNull AutomationType> canInsert, Predicate<Chemical> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        super(capacity.getAsLong(), canExtract, canInsert, validator, attributeValidator, listener);
        this.capacity = capacity;
    }

    @Override
    public long getCapacity() {
        return this.capacity.getAsLong();
    }

    @Override
    public long setStackSize(long amount, @NotNull Action action) {
        if (this.isEmpty()) {
            return 0L;
        }
        if (amount <= 0L) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0L;
        }
        long maxStackSize = this.getCapacity();
        if (maxStackSize > 0L && amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getStored() == amount || action.simulate()) {
            return amount;
        }
        this.stored.setAmount(amount);
        this.onContentsChanged();
        return amount;
    }
}

