/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.Optional;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.UnboxCardboardBoxTrigger;
import mekanism.common.attachments.BlockData;
import mekanism.common.block.BlockMekanism;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IStateStorage;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.TileEntityCardboardBox;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockCardboardBox
extends BlockMekanism
implements IStateStorage,
IHasTileEntity<TileEntityCardboardBox> {
    public BlockCardboardBox() {
        super(BlockBehaviour.Properties.of().strength(0.5f, 0.6f).mapColor(MapColor.WOOD));
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Optional<BlockData> blockData;
        if (!player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (!BlockCardboardBox.canReplace(world, player, pos, state)) {
            return InteractionResult.FAIL;
        }
        if (!world.isClientSide && (blockData = Optional.ofNullable(WorldUtils.getTileEntity(TileEntityCardboardBox.class, (BlockGetter)world, pos)).map(box -> (BlockData)box.components().get((DataComponentType)MekanismDataComponents.BLOCK_DATA.value()))).isPresent()) {
            if (!blockData.get().tryPlaceIntoWorld(world, pos, player)) {
                return InteractionResult.PASS;
            }
            BlockCardboardBox.popResource((Level)world, (BlockPos)pos, (ItemStack)MekanismBlocks.CARDBOARD_BOX.getItemStack());
            ((UnboxCardboardBoxTrigger)((Object)MekanismCriteriaTriggers.UNBOX_CARDBOARD_BOX.value())).trigger((ServerPlayer)player);
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    private static boolean canReplace(Level world, Player player, BlockPos pos, BlockState state) {
        return world.mayInteract(player, pos) && !((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player))).isCanceled();
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null && context.getItemInHand().has(MekanismDataComponents.BLOCK_DATA)) {
            return (BlockState)state.setValue((Property)BlockStateHelper.storageProperty, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public TileEntityTypeRegistryObject<TileEntityCardboardBox> getTileType() {
        return MekanismTileEntityTypes.CARDBOARD_BOX;
    }
}

