/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.item;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.common.attachments.FilterAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.ContainsRecipe;
import mekanism.common.attachments.containers.chemical.AttachedChemicals;
import mekanism.common.attachments.containers.creator.BaseContainerCreator;
import mekanism.common.attachments.containers.creator.IBasicContainerCreator;
import mekanism.common.attachments.containers.fluid.AttachedFluids;
import mekanism.common.attachments.containers.item.AttachedItems;
import mekanism.common.attachments.containers.item.ComponentBackedInventorySlot;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.QIODriveSlot;
import mekanism.common.inventory.slot.SecurityInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class ItemSlotsBuilder {
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> BASIC_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.alwaysTrueBi, BasicInventorySlot.alwaysTrueBi, BasicInventorySlot.alwaysTrue);
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> BASIC_INPUT_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.notExternal, BasicInventorySlot.alwaysTrueBi, BasicInventorySlot.alwaysTrue);
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> OUTPUT_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.alwaysTrueBi, BasicInventorySlot.internalOnly, BasicInventorySlot.alwaysTrue);
    private static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> FUEL_CAN_EXTRACT = (stack, automationType) -> automationType == AutomationType.MANUAL || stack.getBurnTime(null) == 0;
    private static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> FUEL_CAN_INSERT = (stack, automationType) -> stack.getBurnTime(null) != 0;
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> FUEL_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, FUEL_CAN_EXTRACT, FUEL_CAN_INSERT, BasicInventorySlot.alwaysTrue);
    private static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> SECURITY_LOCK_CAN_EXTRACT = (stack, automationType) -> automationType == AutomationType.MANUAL || SecurityInventorySlot.LOCK_EXTRACT_PREDICATE.test((ItemStack)stack);
    private static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> SECURITY_LOCK_CAN_INSERT = (stack, automationType) -> SecurityInventorySlot.LOCK_INSERT_PREDICATE.test((ItemStack)stack);
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> SECURITY_LOCK_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, SECURITY_LOCK_CAN_EXTRACT, SECURITY_LOCK_CAN_INSERT, SecurityInventorySlot.VALIDATOR);
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> FORMULA_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.alwaysTrueBi, BasicInventorySlot.alwaysTrueBi, TileEntityFormulaicAssemblicator.FORMULA_SLOT_VALIDATOR);
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> QIO_DRIVE_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.notExternal, BasicInventorySlot.notExternal, QIODriveSlot.IS_QIO_ITEM);
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> QIO_DASHBOARD_INPUT_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.notExternal, BasicInventorySlot.alwaysTrueBi, BasicInventorySlot.alwaysTrue);
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> QIO_DASHBOARD_OUTPUT_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.internalOnly, BasicInventorySlot.internalOnly, BasicInventorySlot.alwaysTrue);
    private static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> FILL_CONVERT_ENERGY_SLOT_CAN_EXTRACT = (stack, automationType) -> automationType == AutomationType.MANUAL || !EnergyInventorySlot.fillInsertCheck(stack) && EnergyInventorySlot.getPotentialConversion(null, stack) == 0L;
    private static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> FILL_CONVERT_ENERGY_SLOT_CAN_INSERT = (stack, automationType) -> {
        if (EnergyInventorySlot.fillInsertCheck(stack)) {
            return true;
        }
        return EnergyInventorySlot.getPotentialConversion(null, stack) > 0L;
    };
    private static final Predicate<ItemStack> FILL_CONVERT_ENERGY_SLOT_VALIDATOR = stack -> EnergyCompatUtils.hasStrictEnergyHandler(stack) || EnergyInventorySlot.getPotentialConversion(null, stack) > 0L;
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> FILL_CONVERT_ENERGY_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, FILL_CONVERT_ENERGY_SLOT_CAN_EXTRACT, FILL_CONVERT_ENERGY_SLOT_CAN_INSERT, FILL_CONVERT_ENERGY_SLOT_VALIDATOR);
    private static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> DRAIN_ENERGY_SLOT_CAN_EXTRACT = (stack, automationType) -> {
        if (automationType == AutomationType.MANUAL) {
            return true;
        }
        IStrictEnergyHandler itemEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(stack);
        return itemEnergyHandler == null || itemEnergyHandler.insertEnergy(Long.MAX_VALUE, Action.SIMULATE) == Long.MAX_VALUE;
    };
    private static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> DRAIN_ENERGY_SLOT_CAN_INSERT = (stack, automationType) -> {
        IStrictEnergyHandler itemEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(stack);
        return itemEnergyHandler != null && itemEnergyHandler.insertEnergy(Long.MAX_VALUE, Action.SIMULATE) < Long.MAX_VALUE;
    };
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> DRAIN_ENERGY_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, DRAIN_ENERGY_SLOT_CAN_EXTRACT, DRAIN_ENERGY_SLOT_CAN_INSERT, EnergyInventorySlot.DRAIN_VALIDATOR);
    private final List<IBasicContainerCreator<? extends ComponentBackedInventorySlot>> slotCreators = new ArrayList<IBasicContainerCreator<? extends ComponentBackedInventorySlot>>();

    public static ItemSlotsBuilder builder() {
        return new ItemSlotsBuilder();
    }

    private ItemSlotsBuilder() {
    }

    public BaseContainerCreator<AttachedItems, ComponentBackedInventorySlot> build() {
        return new BaseInventorySlotCreator(this.slotCreators);
    }

    public ItemSlotsBuilder addBasicFactorySlots(int process, Predicate<ItemStack> recipeInputPredicate) {
        return this.addBasicFactorySlots(process, recipeInputPredicate, false);
    }

    public ItemSlotsBuilder addBasicFactorySlots(int process, Predicate<ItemStack> recipeInputPredicate, boolean secondaryOutput) {
        IBasicContainerCreator<ComponentBackedInventorySlot> inputSlotCreator = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.notExternal, BasicInventorySlot.alwaysTrueBi, recipeInputPredicate);
        for (int i = 0; i < process; ++i) {
            this.addSlot(inputSlotCreator).addOutput();
            if (!secondaryOutput) continue;
            this.addOutput();
        }
        return this;
    }

    public ItemSlotsBuilder addSlots(int count, IBasicContainerCreator<? extends ComponentBackedInventorySlot> creator) {
        for (int i = 0; i < count; ++i) {
            this.addSlot(creator);
        }
        return this;
    }

    public ItemSlotsBuilder addQIODriveSlots(int count) {
        return this.addSlots(count, QIO_DRIVE_SLOT_CREATOR);
    }

    public ItemSlotsBuilder addQIODashboardSlots() {
        for (int window = 0; window < 3; window = (int)((byte)(window + 1))) {
            this.addSlots(9, QIO_DASHBOARD_INPUT_SLOT_CREATOR);
            this.addSlot(QIO_DASHBOARD_OUTPUT_SLOT_CREATOR);
        }
        return this;
    }

    public ItemSlotsBuilder addMinerSlots(int count) {
        return this.addSlots(count, (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, (stack, automationType) -> automationType != AutomationType.EXTERNAL || !TileEntityDigitalMiner.isSavedReplaceTarget(attachedTo, stack.getItem()), (stack, automationType) -> automationType != AutomationType.EXTERNAL || TileEntityDigitalMiner.isSavedReplaceTarget(attachedTo, stack.getItem()), BasicInventorySlot.alwaysTrue));
    }

    public ItemSlotsBuilder addFormulaSlot() {
        return this.addSlot(FORMULA_SLOT_CREATOR);
    }

    public ItemSlotsBuilder addFormulaCraftingSlot(int count) {
        return this.addSlots(count, (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.alwaysTrueBi, (stack, automationType) -> automationType == AutomationType.INTERNAL || (Boolean)attachedTo.getOrDefault(MekanismDataComponents.AUTO, (Object)false) == false, BasicInventorySlot.alwaysFalse));
    }

    public ItemSlotsBuilder addLockSlot() {
        return this.addSlot(SECURITY_LOCK_SLOT_CREATOR);
    }

    public ItemSlotsBuilder addUnlockSlot() {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, SECURITY_LOCK_CAN_INSERT, (stack, automationType) -> {
            UUID ownerUUID = IItemSecurityUtils.INSTANCE.getOwnerUUID(stack);
            return ownerUUID != null && ownerUUID.equals(IItemSecurityUtils.INSTANCE.getOwnerUUID(attachedTo));
        }, SecurityInventorySlot.VALIDATOR));
    }

    public ItemSlotsBuilder addSlot(IBasicContainerCreator<? extends ComponentBackedInventorySlot> slot) {
        this.slotCreators.add(slot);
        return this;
    }

    public ItemSlotsBuilder addFuelSlot() {
        return this.addSlot(FUEL_SLOT_CREATOR);
    }

    public ItemSlotsBuilder addOredictionificatorInput() {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.notExternal, BasicInventorySlot.alwaysTrueBi, stack -> TileEntityOredictionificator.hasResult(((FilterAware)attachedTo.getOrDefault(MekanismDataComponents.FILTER_AWARE, (Object)FilterAware.EMPTY)).getEnabled(OredictionificatorItemFilter.class), stack)));
    }

    public ItemSlotsBuilder addOutput() {
        return this.addSlot(OUTPUT_SLOT_CREATOR);
    }

    public ItemSlotsBuilder addOutput(int count) {
        return this.addSlots(count, OUTPUT_SLOT_CREATOR);
    }

    public ItemSlotsBuilder addBasic(int count) {
        return this.addSlots(count, BASIC_SLOT_CREATOR);
    }

    public ItemSlotsBuilder addInput(int count) {
        return this.addSlots(count, BASIC_INPUT_SLOT_CREATOR);
    }

    public ItemSlotsBuilder addInput(Predicate<@NotNull ItemStack> isItemValid) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.notExternal, BasicInventorySlot.alwaysTrueBi, isItemValid));
    }

    public <VANILLA_INPUT extends RecipeInput, RECIPE extends MekanismRecipe<VANILLA_INPUT>, INPUT_CACHE extends IInputRecipeCache> ItemSlotsBuilder addInput(IMekanismRecipeTypeProvider<VANILLA_INPUT, RECIPE, INPUT_CACHE> recipeType, ContainsRecipe<INPUT_CACHE, ItemStack> containsRecipe) {
        return this.addInput(stack -> containsRecipe.check(recipeType.getInputCache(), null, (ItemStack)stack));
    }

    public ItemSlotsBuilder addEnergy() {
        return this.addSlot(FILL_CONVERT_ENERGY_SLOT_CREATOR);
    }

    public ItemSlotsBuilder addDrainEnergy() {
        return this.addSlot(DRAIN_ENERGY_SLOT_CREATOR);
    }

    private boolean canFluidFill(ItemStack attachedTo, int tankIndex, ItemStack stack) {
        IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability(stack);
        if (fluidHandlerItem != null) {
            IExtendedFluidTank fluidTank = ContainerType.FLUID.createContainer(attachedTo, tankIndex);
            int tanks = fluidHandlerItem.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                if (fluidInTank.isEmpty() || fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                return true;
            }
        }
        return false;
    }

    public ItemSlotsBuilder addFluidFillSlot(int tankIndex) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.manualOnly, (stack, automationType) -> this.canFluidFill(attachedTo, tankIndex, (ItemStack)stack), BasicInventorySlot.alwaysTrue));
    }

    public ItemSlotsBuilder addFluidDrainSlot(int tankIndex) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.manualOnly, (stack, automationType) -> {
            IFluidHandlerItem itemFluidHandler = FluidInventorySlot.tryGetFluidHandlerUnstacked(stack);
            if (itemFluidHandler != null) {
                AttachedFluids attachedFluids = (AttachedFluids)attachedTo.getOrDefault(MekanismDataComponents.ATTACHED_FLUIDS, (Object)AttachedFluids.EMPTY);
                FluidStack fluidInTank = (FluidStack)attachedFluids.getOrDefault(tankIndex);
                if (fluidInTank.isEmpty()) {
                    return FluidInventorySlot.isNonFullFluidContainer(itemFluidHandler);
                }
                return itemFluidHandler.fill(fluidInTank.copy(), IFluidHandler.FluidAction.SIMULATE) > 0;
            }
            return false;
        }, BasicInventorySlot.alwaysTrue));
    }

    public ItemSlotsBuilder addFluidInputSlot(int tankIndex) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.manualOnly, (stack, automationType) -> {
            IFluidHandlerItem fluidHandlerItem = FluidInventorySlot.tryGetFluidHandlerUnstacked(stack);
            if (fluidHandlerItem != null) {
                IExtendedFluidTank fluidTank = ContainerType.FLUID.createContainer(attachedTo, tankIndex);
                boolean hasEmpty = false;
                int tanks = fluidHandlerItem.getTanks();
                for (int tank = 0; tank < tanks; ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) {
                        hasEmpty = true;
                        continue;
                    }
                    if (fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    return true;
                }
                if (fluidTank.isEmpty()) {
                    return hasEmpty;
                }
                FluidStack fluid = fluidTank.getFluid();
                fluid = fluid.getAmount() < 1000 ? fluid.copyWithAmount(1000) : fluid.copy();
                return fluidHandlerItem.fill(fluid, IFluidHandler.FluidAction.SIMULATE) > 0;
            }
            return false;
        }, BasicInventorySlot.alwaysTrue));
    }

    public ItemSlotsBuilder addFluidRotarySlot(int tankIndex) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, BasicInventorySlot.manualOnly, (stack, automationType) -> {
            IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability((ItemStack)stack);
            if (fluidHandlerItem != null) {
                boolean mode = (Boolean)attachedTo.getOrDefault(MekanismDataComponents.ROTARY_MODE, (Object)false);
                boolean allEmpty = true;
                IExtendedFluidTank fluidTank = null;
                int tanks = fluidHandlerItem.getTanks();
                for (int tank = 0; tank < tanks; ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) continue;
                    if (fluidTank == null) {
                        fluidTank = ContainerType.FLUID.createContainer(attachedTo, tankIndex);
                    }
                    if (fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < fluidInTank.getAmount()) {
                        return mode;
                    }
                    allEmpty = false;
                }
                return allEmpty && !mode;
            }
            return false;
        }, BasicInventorySlot.alwaysTrue));
    }

    public ItemSlotsBuilder addFluidFuelSlot(int tankIndex, Predicate<@NotNull ItemStack> hasFuelValue) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, (stack, automationType) -> {
            int tanks;
            IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability((ItemStack)stack);
            if (fluidHandlerItem != null && (tanks = fluidHandlerItem.getTanks()) > 0) {
                IExtendedFluidTank fluidTank = ContainerType.FLUID.createContainer(attachedTo, tankIndex);
                for (int tank = 0; tank < tanks; ++tank) {
                    if (!fluidTank.isFluidValid(fluidHandlerItem.getFluidInTank(tank))) continue;
                    return false;
                }
            }
            return !hasFuelValue.test((ItemStack)stack);
        }, (stack, automationType) -> hasFuelValue.test((ItemStack)stack) || this.canFluidFill(attachedTo, tankIndex, (ItemStack)stack), BasicInventorySlot.alwaysTrue));
    }

    private boolean canChemicalDrainInsert(ItemStack attachedTo, int tankIndex, ItemStack stack) {
        IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        if (handler != null) {
            AttachedChemicals containers = ContainerType.CHEMICAL.getOrEmpty(attachedTo);
            ChemicalStack chemicalInTank = (ChemicalStack)containers.getOrDefault(tankIndex);
            if (chemicalInTank.isEmpty()) {
                for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                    if (handler.getChemicalInTank(tank).getAmount() >= handler.getChemicalTankCapacity(tank)) continue;
                    return true;
                }
                return false;
            }
            return handler.insertChemical(chemicalInTank, Action.SIMULATE).getAmount() < chemicalInTank.getAmount();
        }
        return false;
    }

    private boolean canChemicalFillExtract(ItemStack attachedTo, int tankIndex, ItemStack stack) {
        IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        if (handler != null) {
            IChemicalTank chemicalTank = null;
            for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                ChemicalStack storedChemical = handler.getChemicalInTank(tank);
                if (storedChemical.isEmpty()) continue;
                if (chemicalTank == null) {
                    chemicalTank = ContainerType.CHEMICAL.createContainer(attachedTo, tankIndex);
                }
                if (!chemicalTank.isValid(storedChemical)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canChemicalFillInsert(ItemStack attachedTo, int tankIndex, ItemStack stack) {
        IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        if (handler != null) {
            IChemicalTank chemicalTank = null;
            for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                ChemicalStack chemicalInTank = handler.getChemicalInTank(tank);
                if (chemicalInTank.isEmpty()) continue;
                if (chemicalTank == null) {
                    chemicalTank = ContainerType.CHEMICAL.createContainer(attachedTo, tankIndex);
                }
                if (chemicalTank.insert(chemicalInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= chemicalInTank.getAmount()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canChemicalFillOrConvertExtract(ItemStack attachedTo, int tankIndex, ItemStack stack) {
        ChemicalStack conversion;
        int tanks;
        IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        IChemicalTank chemicalTank = null;
        if (handler != null && (tanks = handler.getChemicalTanks()) > 0) {
            chemicalTank = ContainerType.CHEMICAL.createContainer(attachedTo, tankIndex);
            for (int tank = 0; tank < tanks; ++tank) {
                if (!chemicalTank.isValid(handler.getChemicalInTank(tank))) continue;
                return false;
            }
        }
        if ((conversion = ChemicalInventorySlot.getPotentialConversion(null, stack)).isEmpty()) {
            return true;
        }
        if (chemicalTank == null) {
            chemicalTank = ContainerType.CHEMICAL.createContainer(attachedTo, tankIndex);
        }
        return !chemicalTank.isValid(conversion);
    }

    private boolean canChemicalFillOrConvertInsert(ItemStack attachedTo, int tankIndex, ItemStack stack) {
        ChemicalStack conversion;
        IChemicalTank chemicalTank = null;
        IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        if (handler != null) {
            for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                ChemicalStack chemicalInTank = handler.getChemicalInTank(tank);
                if (chemicalInTank.isEmpty()) continue;
                if (chemicalTank == null) {
                    chemicalTank = ContainerType.CHEMICAL.createContainer(attachedTo, tankIndex);
                }
                if (chemicalTank.insert(chemicalInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= chemicalInTank.getAmount()) continue;
                return true;
            }
        }
        if ((conversion = ChemicalInventorySlot.getPotentialConversion(null, stack)).isEmpty()) {
            return false;
        }
        if (chemicalTank == null) {
            chemicalTank = ContainerType.CHEMICAL.createContainer(attachedTo, tankIndex);
        }
        if (chemicalTank.insert(conversion, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < conversion.getAmount()) {
            return true;
        }
        return chemicalTank.getNeeded() == 0L && chemicalTank.isTypeEqual(conversion) && chemicalTank.isValid(conversion);
    }

    public ItemSlotsBuilder addChemicalFillSlot(int tankIndex) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, (stack, automationType) -> automationType == AutomationType.MANUAL || this.canChemicalFillExtract(attachedTo, tankIndex, (ItemStack)stack), (stack, automationType) -> this.canChemicalFillInsert(attachedTo, tankIndex, (ItemStack)stack), BasicInventorySlot.alwaysTrue));
    }

    public ItemSlotsBuilder addChemicalFillOrConvertSlot(int tankIndex) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, (stack, automationType) -> automationType == AutomationType.MANUAL || this.canChemicalFillOrConvertExtract(attachedTo, tankIndex, (ItemStack)stack), (stack, automationType) -> this.canChemicalFillOrConvertInsert(attachedTo, tankIndex, (ItemStack)stack), BasicInventorySlot.alwaysTrue));
    }

    public ItemSlotsBuilder addChemicalDrainSlot(int tankIndex) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, (stack, automationType) -> automationType == AutomationType.MANUAL || !this.canChemicalDrainInsert(attachedTo, tankIndex, (ItemStack)stack), (stack, automationType) -> this.canChemicalDrainInsert(attachedTo, tankIndex, (ItemStack)stack), BasicInventorySlot.alwaysTrue));
    }

    public ItemSlotsBuilder addChemicalRotaryDrainSlot(int tankIndex) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, (stack, automationType) -> {
            if (automationType == AutomationType.MANUAL) {
                return true;
            }
            return (Boolean)attachedTo.getOrDefault(MekanismDataComponents.ROTARY_MODE, (Object)false) == false || !this.canChemicalDrainInsert(attachedTo, tankIndex, (ItemStack)stack);
        }, (stack, automationType) -> (Boolean)attachedTo.getOrDefault(MekanismDataComponents.ROTARY_MODE, (Object)false) != false && this.canChemicalDrainInsert(attachedTo, tankIndex, (ItemStack)stack), BasicInventorySlot.alwaysTrue));
    }

    public ItemSlotsBuilder addChemicalRotaryFillSlot(int tankIndex) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, (stack, automationType) -> automationType == AutomationType.MANUAL || this.canChemicalFillExtract(attachedTo, tankIndex, (ItemStack)stack), (stack, automationType) -> (Boolean)attachedTo.getOrDefault(MekanismDataComponents.ROTARY_MODE, (Object)false) == false && this.canChemicalFillInsert(attachedTo, tankIndex, (ItemStack)stack), BasicInventorySlot.alwaysTrue));
    }

    public ItemSlotsBuilder addInfusionFillOrConvertSlot(int tankIndex) {
        return this.addSlot((type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, (stack, automationType) -> automationType == AutomationType.MANUAL || this.canChemicalFillOrConvertExtract(attachedTo, tankIndex, (ItemStack)stack), (stack, automationType) -> this.canChemicalFillOrConvertInsert(attachedTo, tankIndex, (ItemStack)stack), BasicInventorySlot.alwaysTrue));
    }

    private static class BaseInventorySlotCreator
    extends BaseContainerCreator<AttachedItems, ComponentBackedInventorySlot> {
        public BaseInventorySlotCreator(List<IBasicContainerCreator<? extends ComponentBackedInventorySlot>> creators) {
            super(creators);
        }

        @Override
        public AttachedItems initStorage(int containers) {
            return AttachedItems.create(containers);
        }
    }
}

