/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.chemical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.attachments.containers.IAttachedContainers;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

@NothingNullByDefault
public record AttachedChemicals(List<ChemicalStack> containers) implements IAttachedContainers<ChemicalStack, AttachedChemicals>
{
    public static final AttachedChemicals EMPTY = new AttachedChemicals(Collections.emptyList());
    public static final Codec<AttachedChemicals> ACTUAL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChemicalStack.LENIENT_OPTIONAL_CODEC.listOf().fieldOf("chemical_tanks").forGetter(AttachedChemicals::containers)).apply((Applicative)instance, AttachedChemicals::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AttachedChemicals> STREAM_CODEC = ChemicalStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)).map(AttachedChemicals::new, AttachedChemicals::containers);
    @Deprecated(forRemoval=true)
    public static final Codec<AttachedChemicals> GAS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChemicalStack.LENIENT_OPTIONAL_CODEC.listOf().fieldOf("gas_tanks").forGetter(AttachedChemicals::containers)).apply((Applicative)instance, AttachedChemicals::new));
    @Deprecated(forRemoval=true)
    public static final Codec<AttachedChemicals> INFUSE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChemicalStack.LENIENT_OPTIONAL_CODEC.listOf().fieldOf("infusion_tanks").forGetter(AttachedChemicals::containers)).apply((Applicative)instance, AttachedChemicals::new));
    @Deprecated(forRemoval=true)
    public static final Codec<AttachedChemicals> PIGMENT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChemicalStack.LENIENT_OPTIONAL_CODEC.listOf().fieldOf("pigment_tanks").forGetter(AttachedChemicals::containers)).apply((Applicative)instance, AttachedChemicals::new));
    @Deprecated(forRemoval=true)
    public static final Codec<AttachedChemicals> SLURRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChemicalStack.LENIENT_OPTIONAL_CODEC.listOf().fieldOf("slurry_tanks").forGetter(AttachedChemicals::containers)).apply((Applicative)instance, AttachedChemicals::new));
    public static final Codec<AttachedChemicals> CODEC = Codec.withAlternative(ACTUAL_CODEC, (Codec)Codec.withAlternative(GAS_CODEC, (Codec)Codec.withAlternative(INFUSE_CODEC, (Codec)Codec.withAlternative(PIGMENT_CODEC, SLURRY_CODEC))));

    public AttachedChemicals {
        containers = Collections.unmodifiableList(containers);
    }

    public static AttachedChemicals create(int containers) {
        return new AttachedChemicals((List<ChemicalStack>)NonNullList.withSize((int)containers, (Object)ChemicalStack.EMPTY));
    }

    @Override
    public ChemicalStack getEmptyStack() {
        return ChemicalStack.EMPTY;
    }

    @Override
    public AttachedChemicals create(List<ChemicalStack> containers) {
        return new AttachedChemicals(containers);
    }
}

