/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.transmitter.UniversalCable;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;

@NothingNullByDefault
public class RenderUniversalCable
extends RenderTransmitterBase<TileEntityUniversalCable> {
    public RenderUniversalCable(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityUniversalCable tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        EnergyNetwork network = (EnergyNetwork)tile.getTransmitter().getTransmitterNetwork();
        if (network == null) {
            return;
        }
        matrix.pushPose();
        matrix.translate(0.5, 0.5, 0.5);
        this.renderModel(tile, matrix, renderer.getBuffer(Sheets.translucentCullBlockSheet()), 0xFFFFFF, network.currentScale, 0xF000F0, overlayLight, MekanismRenderer.energyIcon);
        matrix.popPose();
    }

    @Override
    protected String getProfilerSection() {
        return "universalCable";
    }

    @Override
    protected boolean shouldRenderTransmitter(TileEntityUniversalCable tile, Vec3 camera) {
        UniversalCable cable;
        if (super.shouldRenderTransmitter(tile, camera) && (cable = tile.getTransmitter()).hasTransmitterNetwork()) {
            EnergyNetwork network = (EnergyNetwork)cable.getTransmitterNetwork();
            return network.currentScale > 0.0f;
        }
        return false;
    }
}

