/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.RegistryUtils;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class MekanismSubtypeInterpreter
implements ISubtypeInterpreter<ItemStack> {
    private List<Object> tryAddData(@Nullable List<Object> subTypeData, Object data) {
        if (subTypeData == null) {
            subTypeData = new ArrayList<Object>();
        }
        subTypeData.add(data);
        return subTypeData;
    }

    @Nullable
    public Object getSubtypeData(ItemStack stack, UidContext context) {
        IStrictEnergyHandler energyHandler;
        IFluidHandler fluidHandler;
        if (context != UidContext.Ingredient) {
            return null;
        }
        List<Object> subTypeData = null;
        IChemicalHandler chemicalHandler = MekanismSubtypeInterpreter.getChemicalHandler(stack);
        if (chemicalHandler != null) {
            int tanks = chemicalHandler.getChemicalTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                ChemicalStack chemicalStack = chemicalHandler.getChemicalInTank(tank);
                if (chemicalStack.isEmpty() && tanks <= 1) continue;
                subTypeData = this.tryAddData(subTypeData, chemicalStack.getChemical());
            }
        }
        if ((fluidHandler = MekanismSubtypeInterpreter.getFluidHandler(stack)) != null) {
            int tanks = fluidHandler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                FluidStack fluidStack = fluidHandler.getFluidInTank(tank);
                if (fluidStack.isEmpty() && tanks <= 1) continue;
                subTypeData = this.tryAddData(subTypeData, fluidStack.getFluid());
            }
        }
        if ((energyHandler = MekanismSubtypeInterpreter.getEnergyHandler(stack)) != null) {
            int containers = energyHandler.getEnergyContainerCount();
            for (int container = 0; container < containers; ++container) {
                long neededEnergy = energyHandler.getNeededEnergy(container);
                if (neededEnergy == 0L) {
                    subTypeData = this.tryAddData(subTypeData, true);
                    continue;
                }
                if (containers <= 1) continue;
                subTypeData = this.tryAddData(subTypeData, false);
            }
        }
        return subTypeData;
    }

    @Deprecated
    public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext context) {
        if (context == UidContext.Ingredient) {
            String representation = MekanismSubtypeInterpreter.getChemicalComponent(stack);
            representation = MekanismSubtypeInterpreter.addInterpretation(representation, MekanismSubtypeInterpreter.getFluidComponent(stack));
            representation = MekanismSubtypeInterpreter.addInterpretation(representation, MekanismSubtypeInterpreter.getEnergyComponent(stack));
            return representation;
        }
        return "";
    }

    @Deprecated
    private static String addInterpretation(String nbtRepresentation, String component) {
        return nbtRepresentation.isEmpty() ? component : nbtRepresentation + ":" + component;
    }

    @Deprecated
    private static String getChemicalComponent(ItemStack stack) {
        IChemicalHandler chemicalHandler = MekanismSubtypeInterpreter.getChemicalHandler(stack);
        if (chemicalHandler != null) {
            String component = "";
            int tanks = chemicalHandler.getChemicalTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                ChemicalStack chemicalStack = chemicalHandler.getChemicalInTank(tank);
                if (!chemicalStack.isEmpty()) {
                    component = MekanismSubtypeInterpreter.addInterpretation(component, chemicalStack.getTypeRegistryName().toString());
                    continue;
                }
                if (tanks <= 1) continue;
                component = MekanismSubtypeInterpreter.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    @Deprecated
    private static String getFluidComponent(ItemStack stack) {
        IFluidHandler handler = MekanismSubtypeInterpreter.getFluidHandler(stack);
        if (handler != null) {
            String component = "";
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                FluidStack fluidStack = handler.getFluidInTank(tank);
                if (!fluidStack.isEmpty()) {
                    component = MekanismSubtypeInterpreter.addInterpretation(component, RegistryUtils.getName(fluidStack.getFluid()).toString());
                    continue;
                }
                if (tanks <= 1) continue;
                component = MekanismSubtypeInterpreter.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    @Deprecated
    private static String getEnergyComponent(ItemStack stack) {
        IStrictEnergyHandler energyHandlerItem = MekanismSubtypeInterpreter.getEnergyHandler(stack);
        if (energyHandlerItem != null) {
            String component = "";
            int containers = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < containers; ++container) {
                long neededEnergy = energyHandlerItem.getNeededEnergy(container);
                if (neededEnergy == 0L) {
                    component = MekanismSubtypeInterpreter.addInterpretation(component, "filled");
                    continue;
                }
                if (containers <= 1) continue;
                component = MekanismSubtypeInterpreter.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    @Nullable
    private static IChemicalHandler getChemicalHandler(ItemStack stack) {
        IChemicalHandler handler = ContainerType.CHEMICAL.createHandlerIfData(stack);
        if (handler == null) {
            return (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        }
        return handler;
    }

    @Nullable
    private static IFluidHandler getFluidHandler(ItemStack stack) {
        IFluidHandler handler = ContainerType.FLUID.createHandlerIfData(stack);
        if (handler == null) {
            return (IFluidHandler)Capabilities.FLUID.getCapability(stack);
        }
        return handler;
    }

    @Nullable
    private static IStrictEnergyHandler getEnergyHandler(ItemStack stack) {
        IStrictEnergyHandler handler = ContainerType.ENERGY.createHandlerIfData(stack);
        if (handler == null) {
            return (IStrictEnergyHandler)Capabilities.STRICT_ENERGY.getCapability(stack);
        }
        return handler;
    }
}

