/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.gear.ModuleData;
import mekanism.api.recipes.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ChemicalToChemicalRecipe;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.ItemStackToChemicalRecipe;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.robit.GuiRobitRepair;
import mekanism.client.recipe_viewer.alias.MekanismAliasMapping;
import mekanism.client.recipe_viewer.jei.CatalystRegistryHelper;
import mekanism.client.recipe_viewer.jei.ChemicalStackHelper;
import mekanism.client.recipe_viewer.jei.ChemicalStackRenderer;
import mekanism.client.recipe_viewer.jei.FormulaicRecipeTransferInfo;
import mekanism.client.recipe_viewer.jei.JEIAliasHelper;
import mekanism.client.recipe_viewer.jei.JeiGhostIngredientHandler;
import mekanism.client.recipe_viewer.jei.JeiGuiElementHandler;
import mekanism.client.recipe_viewer.jei.JeiQIOCraftingTransferHandler;
import mekanism.client.recipe_viewer.jei.MekanismSubtypeInterpreter;
import mekanism.client.recipe_viewer.jei.machine.BoilerRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ChemicalChemicalToChemicalRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ChemicalCrystallizerRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ChemicalDissolutionRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ChemicalToChemicalRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.CombinerRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ElectrolysisRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.FluidChemicalToChemicalRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.FluidToFluidRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackChemicalToItemStackRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackToChemicalRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackToEnergyRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackToFluidOptionalItemRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackToItemStackRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.MetallurgicInfuserRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.NucleosynthesizingRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.PaintingRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.PigmentExtractingRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.PigmentMixerRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.PressurizedReactionRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.RotaryCondensentratorRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.SPSRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.SawmillRecipeCategory;
import mekanism.client.recipe_viewer.recipe.BoilerRecipeViewerRecipe;
import mekanism.client.recipe_viewer.recipe.SPSRecipeViewerRecipe;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.container.entity.robit.CraftingRobitContainer;
import mekanism.common.inventory.container.item.PortableQIODashboardContainer;
import mekanism.common.inventory.container.tile.QIODashboardContainer;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class MekanismJEI
implements IModPlugin {
    public static final IIngredientType<ChemicalStack> TYPE_CHEMICAL = () -> ChemicalStack.class;
    public static final ChemicalStackHelper CHEMICAL_STACK_HELPER = new ChemicalStackHelper();
    private static final ISubtypeInterpreter<ItemStack> MEKANISM_DATA_INTERPRETER = new MekanismSubtypeInterpreter();
    private static final Map<IRecipeViewerRecipeType<?>, RecipeType<?>> recipeTypeInstanceCache = new HashMap();

    public static boolean shouldLoad() {
        return !Mekanism.hooks.EmiLoaded;
    }

    public static RecipeType<?> genericRecipeType(IRecipeViewerRecipeType<?> recipeType) {
        return recipeTypeInstanceCache.computeIfAbsent(recipeType, r -> {
            if (r.requiresHolder()) {
                return RecipeType.createRecipeHolderType((ResourceLocation)r.id());
            }
            return new RecipeType(r.id(), r.recipeClass());
        });
    }

    public static <TYPE> RecipeType<TYPE> recipeType(IRecipeViewerRecipeType<TYPE> recipeType) {
        if (recipeType.requiresHolder()) {
            throw new IllegalStateException("Basic recipe type requested for a recipe that uses holders");
        }
        return MekanismJEI.genericRecipeType(recipeType);
    }

    public static <TYPE extends Recipe<?>> RecipeType<RecipeHolder<TYPE>> holderRecipeType(IRecipeViewerRecipeType<TYPE> recipeType) {
        if (!recipeType.requiresHolder()) {
            throw new IllegalStateException("Holder recipe type requested for a recipe that doesn't use holders");
        }
        return MekanismJEI.genericRecipeType(recipeType);
    }

    public static RecipeType<?>[] recipeType(IRecipeViewerRecipeType<?> ... recipeTypes) {
        return (RecipeType[])Arrays.stream(recipeTypes).map(MekanismJEI::genericRecipeType).toArray(RecipeType[]::new);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"jei_plugin");
    }

    public static void registerItemSubtypes(ISubtypeRegistration registry, Collection<? extends Holder<? extends ItemLike>> itemProviders) {
        for (Holder<? extends ItemLike> holder : itemProviders) {
            ItemStack stack = new ItemStack((ItemLike)holder.value());
            if (!Capabilities.STRICT_ENERGY.hasCapability(stack) && !Capabilities.CHEMICAL.hasCapability(stack) && !Capabilities.FLUID.hasCapability(stack)) continue;
            registry.registerSubtypeInterpreter(stack.getItem(), MEKANISM_DATA_INTERPRETER);
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        if (MekanismJEI.shouldLoad()) {
            MekanismJEI.registerItemSubtypes(registry, MekanismItems.ITEMS.getEntries());
            MekanismJEI.registerItemSubtypes(registry, MekanismBlocks.BLOCKS.getSecondaryEntries());
        }
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        List<ChemicalStack> types = MekanismAPI.CHEMICAL_REGISTRY.stream().filter(chemical -> !chemical.isEmptyType()).map(chemical -> chemical.getStack(1000L)).toList();
        CHEMICAL_STACK_HELPER.setColorHelper(registry.getColorHelper());
        registry.register(TYPE_CHEMICAL, types, (IIngredientHelper)CHEMICAL_STACK_HELPER, (IIngredientRenderer)new ChemicalStackRenderer(), Chemical.CODEC.xmap(chemical -> chemical.getStack(1000L), ChemicalStack::getChemical));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (!MekanismJEI.shouldLoad()) {
            return;
        }
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalCrystallizerRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ChemicalCrystallizerRecipe>)RecipeViewerRecipeType.CRYSTALLIZING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalDissolutionRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ChemicalDissolutionRecipe>)RecipeViewerRecipeType.DISSOLUTION)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalChemicalToChemicalRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ChemicalChemicalToChemicalRecipe>)RecipeViewerRecipeType.CHEMICAL_INFUSING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidChemicalToChemicalRecipeCategory(guiHelper, (IRecipeViewerRecipeType<FluidChemicalToChemicalRecipe>)RecipeViewerRecipeType.WASHING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ElectrolysisRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ElectrolysisRecipe>)RecipeViewerRecipeType.SEPARATING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MetallurgicInfuserRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackChemicalToItemStackRecipe>)RecipeViewerRecipeType.METALLURGIC_INFUSING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PressurizedReactionRecipeCategory(guiHelper, (IRecipeViewerRecipeType<PressurizedReactionRecipe>)RecipeViewerRecipeType.REACTION)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PigmentExtractingRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToChemicalRecipe>)RecipeViewerRecipeType.PIGMENT_EXTRACTING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PigmentMixerRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ChemicalChemicalToChemicalRecipe>)RecipeViewerRecipeType.PIGMENT_MIXING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PaintingRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackChemicalToItemStackRecipe>)RecipeViewerRecipeType.PAINTING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RotaryCondensentratorRecipeCategory(guiHelper, true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RotaryCondensentratorRecipeCategory(guiHelper, false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToChemicalRecipeCategory(guiHelper, RecipeViewerRecipeType.OXIDIZING, false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToFluidOptionalItemRecipeCategory(guiHelper, RecipeViewerRecipeType.NUTRITIONAL_LIQUIFICATION, false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalToChemicalRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ChemicalToChemicalRecipe>)RecipeViewerRecipeType.ACTIVATING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalToChemicalRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ChemicalToChemicalRecipe>)RecipeViewerRecipeType.CENTRIFUGING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CombinerRecipeCategory(guiHelper, (IRecipeViewerRecipeType<CombinerRecipe>)RecipeViewerRecipeType.COMBINING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackChemicalToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackChemicalToItemStackRecipe>)RecipeViewerRecipeType.PURIFYING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackChemicalToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackChemicalToItemStackRecipe>)RecipeViewerRecipeType.COMPRESSING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackChemicalToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackChemicalToItemStackRecipe>)RecipeViewerRecipeType.INJECTING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new NucleosynthesizingRecipeCategory(guiHelper, (IRecipeViewerRecipeType<NucleosynthesizingRecipe>)RecipeViewerRecipeType.NUCLEOSYNTHESIZING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SPSRecipeCategory(guiHelper, (IRecipeViewerRecipeType<SPSRecipeViewerRecipe>)RecipeViewerRecipeType.SPS)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BoilerRecipeCategory(guiHelper, (IRecipeViewerRecipeType<BoilerRecipeViewerRecipe>)RecipeViewerRecipeType.BOILER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SawmillRecipeCategory(guiHelper, (IRecipeViewerRecipeType<SawmillRecipe>)RecipeViewerRecipeType.SAWING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToItemStackRecipe>)RecipeViewerRecipeType.ENRICHING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToItemStackRecipe>)RecipeViewerRecipeType.CRUSHING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToItemStackRecipe>)RecipeViewerRecipeType.SMELTING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidToFluidRecipeCategory(guiHelper, (IRecipeViewerRecipeType<FluidToFluidRecipe>)RecipeViewerRecipeType.EVAPORATING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToEnergyRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToEnergyRecipe>)RecipeViewerRecipeType.ENERGY_CONVERSION)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToChemicalRecipeCategory(guiHelper, RecipeViewerRecipeType.CHEMICAL_CONVERSION, true)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        if (!MekanismJEI.shouldLoad()) {
            return;
        }
        registry.addRecipeClickArea(GuiRobitRepair.class, 102, 48, 22, 15, new RecipeType[]{RecipeTypes.ANVIL});
        registry.addGenericGuiContainerHandler(GuiMekanism.class, (IGuiContainerHandler)new JeiGuiElementHandler(registry.getJeiHelpers().getIngredientManager()));
        registry.addGhostIngredientHandler(GuiMekanism.class, new JeiGhostIngredientHandler());
    }

    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        new MekanismAliasMapping().addAliases(new JEIAliasHelper(registration));
    }

    /*
     * Exception decompiling
     */
    public void registerRecipes(IRecipeRegistration registry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        if (!MekanismJEI.shouldLoad()) {
            return;
        }
        CatalystRegistryHelper.register(registry, RecipeViewerRecipeType.ENRICHING, RecipeViewerRecipeType.CRUSHING, RecipeViewerRecipeType.COMBINING, RecipeViewerRecipeType.PURIFYING, RecipeViewerRecipeType.COMPRESSING, RecipeViewerRecipeType.INJECTING, RecipeViewerRecipeType.SAWING, RecipeViewerRecipeType.METALLURGIC_INFUSING, RecipeViewerRecipeType.CRYSTALLIZING, RecipeViewerRecipeType.DISSOLUTION, RecipeViewerRecipeType.CHEMICAL_INFUSING, RecipeViewerRecipeType.OXIDIZING, RecipeViewerRecipeType.WASHING, RecipeViewerRecipeType.ACTIVATING, RecipeViewerRecipeType.SEPARATING, RecipeViewerRecipeType.SPS, RecipeViewerRecipeType.EVAPORATING, RecipeViewerRecipeType.BOILER, RecipeViewerRecipeType.REACTION, RecipeViewerRecipeType.CENTRIFUGING, RecipeViewerRecipeType.NUTRITIONAL_LIQUIFICATION, RecipeViewerRecipeType.PIGMENT_EXTRACTING, RecipeViewerRecipeType.PIGMENT_MIXING, RecipeViewerRecipeType.PAINTING, RecipeViewerRecipeType.NUCLEOSYNTHESIZING, RecipeViewerRecipeType.CONDENSENTRATING, RecipeViewerRecipeType.DECONDENSENTRATING, RecipeViewerRecipeType.SMELTING, RecipeViewerRecipeType.ENERGY_CONVERSION, RecipeViewerRecipeType.CHEMICAL_CONVERSION);
        CatalystRegistryHelper.register(registry, RecipeTypes.SMELTING, RecipeViewerRecipeType.VANILLA_SMELTING.workstations());
        CatalystRegistryHelper.register(registry, RecipeTypes.CRAFTING, RecipeViewerRecipeType.VANILLA_CRAFTING.workstations());
        CatalystRegistryHelper.register(registry, RecipeTypes.ANVIL, List.of(MekanismItems.ROBIT));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        if (!MekanismJEI.shouldLoad()) {
            return;
        }
        IRecipeTransferHandlerHelper transferHelper = registry.getTransferHelper();
        IStackHelper stackHelper = registry.getJeiHelpers().getStackHelper();
        registry.addRecipeTransferHandler(CraftingRobitContainer.class, (MenuType)MekanismContainerTypes.CRAFTING_ROBIT.get(), RecipeTypes.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler((IRecipeTransferInfo)new FormulaicRecipeTransferInfo());
        registry.addRecipeTransferHandler(new JeiQIOCraftingTransferHandler<QIODashboardContainer>(transferHelper, stackHelper, (MenuType)MekanismContainerTypes.QIO_DASHBOARD.get(), QIODashboardContainer.class), RecipeTypes.CRAFTING);
        registry.addRecipeTransferHandler(new JeiQIOCraftingTransferHandler<PortableQIODashboardContainer>(transferHelper, stackHelper, (MenuType)MekanismContainerTypes.PORTABLE_QIO_DASHBOARD.get(), PortableQIODashboardContainer.class), RecipeTypes.CRAFTING);
    }

    private static /* synthetic */ ItemStack lambda$registerRecipes$7(ModuleData data) {
        return data.getItemProvider().getItemStack();
    }
}

