/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.MekanismAPITags;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.util.ChemicalUtil;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ChemicalStackHelper
implements IIngredientHelper<ChemicalStack> {
    @Nullable
    private IColorHelper colorHelper;

    void setColorHelper(IColorHelper colorHelper) {
        this.colorHelper = colorHelper;
    }

    public String getDisplayName(ChemicalStack ingredient) {
        return TextComponentUtil.build(ingredient).getString();
    }

    @Deprecated(forRemoval=true)
    public String getUniqueId(ChemicalStack ingredient, UidContext context) {
        return "chemical:" + String.valueOf(ingredient.getTypeRegistryName());
    }

    public Object getUid(ChemicalStack ingredient, UidContext context) {
        return ingredient.getChemical();
    }

    public ResourceLocation getResourceLocation(ChemicalStack ingredient) {
        return ingredient.getTypeRegistryName();
    }

    public ItemStack getCheatItemStack(ChemicalStack ingredient) {
        return ChemicalUtil.getFilledVariant(MekanismBlocks.CREATIVE_CHEMICAL_TANK, (IChemicalProvider)ingredient.getChemical());
    }

    public ChemicalStack normalizeIngredient(ChemicalStack ingredient) {
        return ingredient.copyWithAmount(1000L);
    }

    public boolean isValidIngredient(ChemicalStack ingredient) {
        return !ingredient.isEmpty();
    }

    public Iterable<Integer> getColors(ChemicalStack ingredient) {
        if (this.colorHelper == null) {
            return super.getColors((Object)ingredient);
        }
        Chemical chemical = ingredient.getChemical();
        return this.colorHelper.getColors(MekanismRenderer.getChemicalTexture(chemical), chemical.getTint(), 1);
    }

    public IIngredientType<ChemicalStack> getIngredientType() {
        return MekanismJEI.TYPE_CHEMICAL;
    }

    public ChemicalStack copyIngredient(ChemicalStack ingredient) {
        return ingredient.copy();
    }

    public Stream<ResourceLocation> getTagStream(ChemicalStack ingredient) {
        return ingredient.getTags().map(TagKey::location);
    }

    public boolean isHiddenFromRecipeViewersByTags(ChemicalStack ingredient) {
        return ingredient.is(MekanismAPITags.Chemicals.HIDDEN_FROM_RECIPE_VIEWERS);
    }

    public Optional<TagKey<?>> getTagKeyEquivalent(Collection<ChemicalStack> stacks) {
        if (stacks.size() < 2) {
            return Optional.empty();
        }
        List<Chemical> values = stacks.stream().map(ChemicalStack::getChemical).distinct().toList();
        int expected = values.size();
        if (expected != stacks.size()) {
            return Optional.empty();
        }
        return MekanismAPI.CHEMICAL_REGISTRY.getTags().filter(pair -> {
            HolderSet.Named tag = (HolderSet.Named)pair.getSecond();
            if (tag.size() != expected) {
                return false;
            }
            for (int i = 0; i < expected; ++i) {
                if (tag.get(i).value() == values.get(i)) continue;
                return false;
            }
            return true;
        }).map(Pair::getFirst).findFirst();
    }

    public String getErrorInfo(ChemicalStack ingredient) {
        if (ingredient == null) {
            ingredient = ChemicalStack.EMPTY;
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ChemicalStack.class);
        Chemical chemical = ingredient.getChemical();
        toStringHelper.add("Chemical", (Object)(chemical.isEmptyType() ? "none" : TextComponentUtil.build(chemical).getString()));
        if (!ingredient.isEmpty()) {
            toStringHelper.add("Amount", ingredient.getAmount());
        }
        return toStringHelper.toString();
    }
}

