/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMaps;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArraySet;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.qio.QIOCraftingTransferHelper;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.qio.PacketQIOFillCraftingWindow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QIOCraftingTransferHandler {
    @Nullable
    public static <RESULT, SLOT extends RVRecipeSlot, ITEM_UUID> RESULT transferRecipe(RVRecipeInfo<RESULT, SLOT, ITEM_UUID> recipeHelper, Action action) {
        record TrackedIngredients<SLOT extends RVRecipeSlot>(SLOT view, Set<HashedItem> representations) {
        }
        List<SLOT> slotViews;
        int maxInputCount;
        if (recipeHelper.transferAmount() < 1) {
            return recipeHelper.createInternalError();
        }
        QIOItemViewerContainer container = recipeHelper.container();
        byte selectedCraftingGrid = container.getSelectedCraftingGrid();
        if (selectedCraftingGrid == -1) {
            return recipeHelper.createInternalError();
        }
        QIOCraftingWindow craftingWindow = container.getCraftingWindow(selectedCraftingGrid);
        byte nonEmptyCraftingSlots = 0;
        if (action.simulate()) {
            ArrayList<ItemStack> dummy = new ArrayList<ItemStack>(9);
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack inputStack = craftingWindow.getInputSlot(slot).getStack();
                dummy.add(inputStack.copyWithCount(1));
                if (inputStack.isEmpty()) continue;
                nonEmptyCraftingSlots = (byte)(nonEmptyCraftingSlots + 1);
            }
            if (recipeHelper.recipe().matches((RecipeInput)CraftingInput.of((int)3, (int)3, dummy), recipeHelper.player().level())) {
                return null;
            }
        }
        if ((maxInputCount = (slotViews = recipeHelper.inputs()).size()) > 9) {
            Mekanism.logger.warn("Error evaluating recipe transfer handler for recipe: {}, had more than 9 inputs: {}", (Object)recipeHelper.id(), (Object)maxInputCount);
            return recipeHelper.createInternalError();
        }
        int inputCount = 0;
        Byte2ObjectArrayMap hashedIngredients = new Byte2ObjectArrayMap(maxInputCount);
        for (int index = 0; index < maxInputCount; ++index) {
            RVRecipeSlot slotView = (RVRecipeSlot)slotViews.get(index);
            List<ItemStack> validIngredients = slotView.itemStacks();
            if (validIngredients.isEmpty()) continue;
            ++inputCount;
            LinkedHashSet<HashedItem> representations = new LinkedHashSet<HashedItem>(validIngredients.size());
            ItemStack displayed = slotView.displayedIngredient();
            if (!displayed.isEmpty()) {
                representations.add(HashedItem.raw(displayed));
            }
            for (ItemStack itemStack : validIngredients) {
                if (itemStack.isEmpty()) continue;
                representations.add(HashedItem.raw(itemStack));
            }
            hashedIngredients.put((byte)index, new TrackedIngredients<RVRecipeSlot>(slotView, representations));
        }
        QIOCraftingTransferHelper qioTransferHelper = container.getTransferHelper(recipeHelper.player(), craftingWindow);
        if (qioTransferHelper.isInvalid()) {
            Mekanism.logger.warn("Error initializing QIO transfer handler for crafting window: {}", (Object)selectedCraftingGrid);
            return recipeHelper.createInternalError();
        }
        HashMap<HashedItem, ByteList> matchedItems = new HashMap<HashedItem, ByteList>(inputCount);
        ByteArraySet missingSlots = new ByteArraySet(inputCount);
        ObjectIterator iterator = Byte2ObjectMaps.fastIterator((Byte2ObjectMap)hashedIngredients);
        while (iterator.hasNext()) {
            Byte2ObjectMap.Entry entry = (Byte2ObjectMap.Entry)iterator.next();
            boolean bl = false;
            for (HashedItem validInput : ((TrackedIngredients)entry.getValue()).representations()) {
                QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(validInput);
                if (source == null || !source.hasMoreRemaining()) continue;
                source.matchFound();
                bl = true;
                matchedItems.computeIfAbsent(validInput, item -> new ByteArrayList()).add(entry.getByteKey());
                break;
            }
            if (bl) continue;
            missingSlots.add(entry.getByteKey());
        }
        if (!missingSlots.isEmpty()) {
            HashMap<HashedItem, Object> cachedIngredientUUIDs = new HashMap<HashedItem, Object>();
            for (Map.Entry entry : qioTransferHelper.reverseLookup.entrySet()) {
                QIOCraftingTransferHelper.HashedItemSource hashedItemSource = (QIOCraftingTransferHelper.HashedItemSource)entry.getValue();
                if (!hashedItemSource.hasMoreRemaining()) continue;
                HashedItem storedHashedItem = (HashedItem)entry.getKey();
                Item storedItemType = storedHashedItem.getItem();
                Object storedItemUUID = null;
                ByteIterator missingIterator = missingSlots.iterator();
                while (missingIterator.hasNext()) {
                    byte index = missingIterator.nextByte();
                    for (HashedItem validIngredient : ((TrackedIngredients)hashedIngredients.get(index)).representations()) {
                        Object ingredientUUID;
                        if (storedItemType != validIngredient.getItem()) continue;
                        if (storedItemUUID == null) {
                            storedItemUUID = recipeHelper.itemUUID(storedHashedItem);
                        }
                        if (!storedItemUUID.equals(ingredientUUID = cachedIngredientUUIDs.computeIfAbsent(validIngredient, recipeHelper::itemUUID))) continue;
                        hashedItemSource.matchFound();
                        missingIterator.remove();
                        matchedItems.computeIfAbsent(storedHashedItem, item -> new ByteArrayList()).add(index);
                        break;
                    }
                    if (hashedItemSource.hasMoreRemaining()) continue;
                    break;
                }
                if (!missingSlots.isEmpty()) continue;
                break;
            }
            if (!missingSlots.isEmpty()) {
                ArrayList missing = new ArrayList(missingSlots.size());
                ByteIterator byteIterator = missingSlots.iterator();
                while (byteIterator.hasNext()) {
                    byte by = (Byte)byteIterator.next();
                    missing.add(((TrackedIngredients)hashedIngredients.get(by)).view());
                }
                return recipeHelper.createMissingSlotsError(missing);
            }
        }
        if (action.execute() || nonEmptyCraftingSlots > 0 && nonEmptyCraftingSlots >= qioTransferHelper.getEmptyInventorySlots()) {
            int toTransfer = recipeHelper.transferAmount();
            if (toTransfer > 1) {
                for (Map.Entry entry : matchedItems.entrySet()) {
                    HashedItem hashedItem = (HashedItem)entry.getKey();
                    QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(hashedItem);
                    if (source == null) {
                        return QIOCraftingTransferHandler.invalidSource(recipeHelper, hashedItem);
                    }
                    int maxStack = hashedItem.getMaxStackSize();
                    int max = maxStack == 1 ? toTransfer : Math.min(toTransfer, maxStack);
                    toTransfer = Math.min(max, MathUtils.clampToInt(source.getAvailable() / (long)((ByteList)entry.getValue()).size()));
                    if (toTransfer != 1) continue;
                    break;
                }
            }
            QIOFrequency frequency = container.getFrequency();
            Byte2ObjectArrayMap byte2ObjectArrayMap = new Byte2ObjectArrayMap(inputCount);
            HashMap<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>> hashMap = frequency == null ? Collections.emptyMap() : new HashMap<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>>(inputCount);
            for (Map.Entry entry : matchedItems.entrySet()) {
                HashedItem hashedItem = (HashedItem)entry.getKey();
                QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(hashedItem);
                if (source == null) {
                    return QIOCraftingTransferHandler.invalidSource(recipeHelper, hashedItem);
                }
                int transferAmount = Math.min(toTransfer, hashedItem.getMaxStackSize());
                ByteListIterator byteListIterator = ((ByteList)entry.getValue()).iterator();
                while (byteListIterator.hasNext()) {
                    byte slot = (Byte)byteListIterator.next();
                    List<QIOCraftingTransferHelper.SingularHashedItemSource> actualSources = source.use(transferAmount);
                    if (actualSources.isEmpty()) {
                        return QIOCraftingTransferHandler.invalidSource(recipeHelper, hashedItem);
                    }
                    byte2ObjectArrayMap.put(slot, actualSources);
                    if (frequency == null) continue;
                    int elements = ((ByteList)entry.getValue()).size();
                    if (elements == 1) {
                        hashMap.put(source, Collections.singletonList(actualSources));
                        continue;
                    }
                    ArrayList<List<QIOCraftingTransferHelper.SingularHashedItemSource>> list = (ArrayList<List<QIOCraftingTransferHelper.SingularHashedItemSource>>)hashMap.get(source);
                    if (list == null) {
                        list = new ArrayList<List<QIOCraftingTransferHelper.SingularHashedItemSource>>(elements);
                        hashMap.put(source, list);
                    }
                    list.add(actualSources);
                }
            }
            if (!QIOCraftingTransferHandler.hasRoomToShuffle(qioTransferHelper, frequency, craftingWindow, container.getHotBarSlots(), container.getMainInventorySlots(), hashMap)) {
                return recipeHelper.createNoRoomError();
            }
            if (action.execute()) {
                PacketUtils.sendToServer(new PacketQIOFillCraftingWindow(recipeHelper.id(), toTransfer > 1, MekanismConfig.client.qioRejectsToInventory.get(), (Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>>)byte2ObjectArrayMap));
            }
        }
        return null;
    }

    private static <RESULT> RESULT invalidSource(RVRecipeInfo<RESULT, ?, ?> recipeHelper, @NotNull HashedItem type) {
        Mekanism.logger.warn("Error finding source for: {} with components: {}. This should not be possible.", (Object)type.getItem(), (Object)type.getInternalStack().getComponentsPatch());
        return recipeHelper.createInternalError();
    }

    private static boolean hasRoomToShuffle(final QIOCraftingTransferHelper qioTransferHelper, @Nullable QIOFrequency frequency, QIOCraftingWindow craftingWindow, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots, Map<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>> shuffleLookup) {
        Object2IntArrayMap leftOverInput = new Object2IntArrayMap(9);
        for (byte slotIndex = 0; slotIndex < 9; slotIndex = (byte)((byte)(slotIndex + 1))) {
            IInventorySlot slot = craftingWindow.getInputSlot(slotIndex);
            if (slot.isEmpty()) continue;
            HashedItem type = HashedItem.raw(slot.getStack());
            QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(type);
            if (source == null) {
                return false;
            }
            int remaining = source.getSlotRemaining(slotIndex);
            if (remaining <= 0) continue;
            leftOverInput.mergeInt((Object)type, remaining, Integer::sum);
        }
        if (!leftOverInput.isEmpty()) {
            QIOCraftingTransferHelper.BaseSimulatedInventory simulatedInventory = new QIOCraftingTransferHelper.BaseSimulatedInventory(hotBarSlots, mainInventorySlots){

                @Override
                protected int getRemaining(int slot, ItemStack currentStored) {
                    QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(HashedItem.raw(currentStored));
                    if (source == null) {
                        return currentStored.getCount();
                    }
                    return source.getSlotRemaining((byte)(slot + 9));
                }
            };
            Object2IntMap<HashedItem> stillLeftOver = simulatedInventory.shuffleInputs((Object2IntMap<HashedItem>)leftOverInput, frequency != null);
            if (stillLeftOver == null) {
                return false;
            }
            if (!stillLeftOver.isEmpty() && frequency != null) {
                QIOCraftingTransferHelper.HashedItemSource source;
                int availableItemTypes = frequency.getTotalItemTypeCapacity() - frequency.getTotalItemTypes(true);
                long availableItemSpace = frequency.getTotalItemCountCapacity() - frequency.getTotalItemCount();
                Object2BooleanArrayMap usedQIOSource = new Object2BooleanArrayMap(shuffleLookup.size());
                for (Map.Entry<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>> entry : shuffleLookup.entrySet()) {
                    source = entry.getKey();
                    boolean usedQIO = false;
                    for (List<QIOCraftingTransferHelper.SingularHashedItemSource> usedSources : entry.getValue()) {
                        for (QIOCraftingTransferHelper.SingularHashedItemSource usedSource : usedSources) {
                            UUID qioSource = usedSource.getQioSource();
                            if (qioSource == null) continue;
                            availableItemSpace += (long)usedSource.getUsed();
                            if (source.getQIORemaining(qioSource) != 0L) continue;
                            ++availableItemTypes;
                            usedQIO = true;
                        }
                    }
                    usedQIOSource.put((Object)source, usedQIO);
                }
                ObjectIterator iterator = Object2IntMaps.fastIterator(stillLeftOver);
                while (iterator.hasNext()) {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                    if ((availableItemSpace -= (long)entry.getIntValue()) <= 0L) {
                        return false;
                    }
                    source = qioTransferHelper.getSource((HashedItem)entry.getKey());
                    if (source == null) {
                        return false;
                    }
                    if (!(source.hasQIOSources() ? usedQIOSource.containsKey((Object)source) && usedQIOSource.getBoolean((Object)source) && --availableItemTypes <= 0 : --availableItemTypes <= 0)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static interface RVRecipeInfo<RESULT, SLOT extends RVRecipeSlot, ITEM_UUID> {
        public QIOItemViewerContainer container();

        public RecipeHolder<CraftingRecipe> recipeHolder();

        default public CraftingRecipe recipe() {
            return (CraftingRecipe)this.recipeHolder().value();
        }

        default public ResourceLocation id() {
            return this.recipeHolder().id();
        }

        public int transferAmount();

        public Player player();

        public ITEM_UUID itemUUID(HashedItem var1);

        public List<SLOT> inputs();

        public RESULT createInternalError();

        public RESULT createNoRoomError();

        public RESULT createMissingSlotsError(List<SLOT> var1);
    }

    public static interface RVRecipeSlot {
        public List<ItemStack> itemStacks();

        public ItemStack displayedIngredient();
    }
}

