/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter;

import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.CharPredicate;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.window.filter.GuiTextFilter;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerGhostTarget;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.text.InputValidator;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiModIDFilter<FILTER extends IModIDFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiTextFilter<FILTER, TILE> {
    protected GuiModIDFilter(IGuiWrapper gui, int x, int y, int width, int height, TILE tile, @Nullable FILTER origFilter) {
        super(gui, x, y, width, height, (Component)MekanismLang.MODID_FILTER.translate(), tile, origFilter);
    }

    @Override
    protected CharPredicate getInputValidator() {
        return InputValidator.RL_NAMESPACE.or(InputValidator.WILDCARD_CHARS);
    }

    @Override
    protected List<Component> getScreenText() {
        List<Component> list = super.getScreenText();
        list.add((Component)MekanismLang.MODID_FILTER_ID.translate(((IModIDFilter)this.filter).getModID()));
        return list;
    }

    @Override
    protected ILangEntry getNoFilterSaveError() {
        return MekanismLang.MODID_FILTER_NO_ID;
    }

    @Override
    protected boolean setText() {
        return this.setFilterName(this.text.getText(), false);
    }

    @Override
    @NotNull
    protected List<ItemStack> getRenderStacks() {
        if (((IModIDFilter)this.filter).hasFilter()) {
            return TagCache.getItemModIDStacks(((IModIDFilter)this.filter).getModID());
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    protected IRecipeViewerGhostTarget.IGhostIngredientConsumer getGhostHandler() {
        return new IRecipeViewerGhostTarget.IGhostIngredientConsumer(){

            @Override
            @Nullable
            public String supportedTarget(Object ingredient) {
                ResourceLocation registryName;
                if (ingredient instanceof ItemStack) {
                    ItemStack stack = (ItemStack)ingredient;
                    return stack.isEmpty() ? null : MekanismUtils.getModId(stack);
                }
                if (ingredient instanceof FluidStack) {
                    FluidStack stack = (FluidStack)ingredient;
                    if (stack.isEmpty()) {
                        return null;
                    }
                    registryName = RegistryUtils.getName(stack.getFluid());
                } else if (ingredient instanceof ChemicalStack) {
                    ChemicalStack stack = (ChemicalStack)ingredient;
                    if (stack.isEmpty()) {
                        return null;
                    }
                    registryName = stack.getTypeRegistryName();
                } else {
                    registryName = RegistryUtils.getNameGeneric(ingredient);
                }
                return registryName == null ? null : registryName.getNamespace();
            }

            @Override
            public void accept(Object ingredient) {
                if (ingredient instanceof String) {
                    String namespace = (String)ingredient;
                    GuiModIDFilter.this.setFilterName(namespace, true);
                }
            }
        };
    }

    @Override
    @Nullable
    protected GuiElement.IClickable getSlotClickHandler() {
        return (element, mouseX, mouseY) -> {
            ItemStack stack;
            if (!Screen.hasShiftDown() && !(stack = element.gui().getCarriedItem()).isEmpty()) {
                this.setFilterName(MekanismUtils.getModId(stack.copyWithCount(1)), false);
                return true;
            }
            return false;
        };
    }

    private boolean setFilterName(String name, boolean click) {
        boolean success = false;
        if (name.isEmpty()) {
            this.filterSaveFailed(this.getNoFilterSaveError(), new Object[0]);
        } else if (name.equals(((IModIDFilter)this.filter).getModID())) {
            this.filterSaveFailed(MekanismLang.MODID_FILTER_SAME_ID, new Object[0]);
        } else if (!this.hasMatchingTargets(name)) {
            this.filterSaveFailed(MekanismLang.TEXT_FILTER_NO_MATCHES, new Object[0]);
        } else {
            ((IModIDFilter)this.filter).setModID(name);
            this.slotDisplay.updateStackList();
            this.text.setText("");
            this.filterSaveSuccess();
            success = true;
        }
        if (click) {
            GuiModIDFilter.playClickSound(BUTTON_CLICK_SOUND);
        }
        return success;
    }

    protected boolean hasMatchingTargets(String name) {
        return !TagCache.getItemModIDStacks(name).isEmpty();
    }
}

