/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import mekanism.api.security.IBlockSecurityUtils;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.gui.element.tab.GuiRedstoneControlTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.window.GuiUpgradeWindowTab;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IRedstoneControl;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class GuiMekanismTile<TILE extends TileEntityMekanism, CONTAINER extends MekanismTileContainer<TILE>>
extends GuiMekanism<CONTAINER> {
    protected final TILE tile;
    @Nullable
    private GuiUpgradeWindowTab upgradeWindowTab;

    protected GuiMekanismTile(CONTAINER container, Inventory inv, Component title) {
        super(container, inv, title);
        this.tile = ((MekanismTileContainer)container).getTileEntity();
    }

    public TILE getTileEntity() {
        return this.tile;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addGenericTabs();
    }

    protected void addGenericTabs() {
        if (((TileEntityMekanism)this.tile).supportsUpgrades()) {
            this.upgradeWindowTab = this.addRenderableWidget(new GuiUpgradeWindowTab(this, (TileEntityMekanism)this.tile, () -> this.upgradeWindowTab));
        }
        if (((TileEntityMekanism)this.tile).supportsRedstone()) {
            this.addRenderableWidget(((GuiInsetElement)((GuiInsetElement)new GuiRedstoneControlTab(this, (TileEntityMekanism)this.tile).warning(WarningTracker.WarningType.REDSTONE_SIGNAL_ABSENT, () -> ((TileEntityMekanism)this.tile).getControlType() == IRedstoneControl.RedstoneControl.HIGH && !((TileEntityMekanism)this.tile).isRedstoneActivated())).warning(WarningTracker.WarningType.REDSTONE_SIGNAL_PRESENT, () -> ((TileEntityMekanism)this.tile).getControlType() == IRedstoneControl.RedstoneControl.LOW && !((TileEntityMekanism)this.tile).isRedstoneActivated())).warning(WarningTracker.WarningType.REDSTONE_PULSE_REQUIRED, () -> ((TileEntityMekanism)this.tile).getControlType() == IRedstoneControl.RedstoneControl.PULSE && !((TileEntityMekanism)this.tile).isRedstoneActivated()));
        }
        if (this.tile.getLevel() != null && IBlockSecurityUtils.INSTANCE.securityCapability(this.tile.getLevel(), this.tile.getBlockPos(), (BlockEntity)this.tile) != null) {
            this.addSecurityTab();
        }
    }

    protected void addSecurityTab() {
        this.addRenderableWidget(new GuiSecurityTab((IGuiWrapper)this, (BlockEntity)this.tile));
    }
}

