/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import mekanism.api.chemical.IChemicalTank;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.client.gui.element.bar.GuiChemicalBar;
import mekanism.client.gui.element.button.GuiGasMode;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiChemicalTank
extends GuiConfigurableTile<TileEntityChemicalTank, MekanismTileContainer<TileEntityChemicalTank>> {
    public GuiChemicalTank(MekanismTileContainer<TileEntityChemicalTank> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        this.addRenderableWidget(GuiSideHolder.armorHolder(this));
        super.addGuiElements();
        this.addRenderableWidget(new GuiChemicalBar((IGuiWrapper)this, GuiChemicalBar.getProvider(((TileEntityChemicalTank)this.tile).getChemicalTank(), ((TileEntityChemicalTank)this.tile).getChemicalTanks(null)), 42, 16, 116, 10, true));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 42, 37, 118, 28, () -> {
            ArrayList<MutableComponent> ret = new ArrayList<MutableComponent>();
            IChemicalTank tank = ((TileEntityChemicalTank)this.tile).getChemicalTank();
            if (tank.isEmpty()) {
                ret.add(MekanismLang.CHEMICAL.translate(MekanismLang.NONE));
                ret.add(MekanismLang.GENERIC_FRACTION.translate(0, ((TileEntityChemicalTank)this.tile).getTier() == ChemicalTankTier.CREATIVE ? MekanismLang.INFINITE : TextUtils.format(((TileEntityChemicalTank)this.tile).getTier().getStorage())));
            } else {
                ret.add(MekanismLang.CHEMICAL.translate(tank.getStack()));
                if (((TileEntityChemicalTank)this.tile).getTier() == ChemicalTankTier.CREATIVE) {
                    ret.add(MekanismLang.INFINITE.translate());
                } else {
                    ret.add(MekanismLang.GENERIC_FRACTION.translate(TextUtils.format(tank.getStored()), ((TileEntityChemicalTank)this.tile).getTier() == ChemicalTankTier.CREATIVE ? MekanismLang.INFINITE : TextUtils.format(tank.getCapacity())));
                }
            }
            return ret;
        }));
        this.addRenderableWidget(new GuiGasMode((IGuiWrapper)this, 159, 72, true, () -> ((TileEntityChemicalTank)this.tile).dumping, ((TileEntityChemicalTank)this.tile).getBlockPos(), 0));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.renderInventoryText(guiGraphics, 85);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

