/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.ref.WeakReference;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.providers.IItemProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.machine.GuiAdvancedElectricMachine;
import mekanism.client.gui.machine.GuiElectricMachine;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.block.BlockMekanism;
import mekanism.common.block.interfaces.IColoredBlock;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.item.interfaces.IColoredItem;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.FluidDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.prefab.TileEntityElectricMachine;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ClientRegistrationUtil {
    private static final BlockColor COLORED_BLOCK_COLOR = (state, world, pos, tintIndex) -> {
        Block block = state.getBlock();
        if (block instanceof IColoredBlock) {
            IColoredBlock coloredBlock = (IColoredBlock)block;
            return coloredBlock.getColor().getPackedColor();
        }
        return -1;
    };
    private static final ItemColor COLORED_BLOCK_ITEM_COLOR = (stack, tintIndex) -> {
        BlockItem blockItem;
        Block block;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IColoredBlock) {
            IColoredBlock coloredBlock = (IColoredBlock)block;
            return coloredBlock.getColor().getPackedColor();
        }
        return -1;
    };
    private static final ItemColor COLORED_ITEM_COLOR = (stack, tintIndex) -> {
        Item item = stack.getItem();
        if (tintIndex == 1 && item instanceof IColoredItem) {
            EnumColor color = (EnumColor)stack.get(MekanismDataComponents.COLOR);
            if (color == null) {
                return -11184811;
            }
            int[] rgbCode = color.getRgbCode();
            return FastColor.ARGB32.color((int)255, (int)rgbCode[0], (int)rgbCode[1], (int)rgbCode[2]);
        }
        return -1;
    };
    private static final ItemColor BUCKET_ITEM_COLOR = new DynamicFluidContainerModel.Colors();

    private ClientRegistrationUtil() {
    }

    @SafeVarargs
    public static <T extends BlockEntity> void bindTileEntityRenderer(EntityRenderersEvent.RegisterRenderers event, final BlockEntityRendererProvider<T> rendererProvider, TileEntityTypeRegistryObject<? extends T> ... tileEntityTypeROs) {
        if (tileEntityTypeROs.length == 0) {
            throw new IllegalArgumentException("No renderers provided.");
        }
        if (tileEntityTypeROs.length == 1) {
            event.registerBlockEntityRenderer((BlockEntityType)tileEntityTypeROs[0].get(), rendererProvider);
        } else {
            BlockEntityRendererProvider provider = new BlockEntityRendererProvider<T>(){
                @Nullable
                private WeakReference<BlockEntityRendererProvider.Context> cachedContext;
                @Nullable
                private WeakReference<BlockEntityRenderer<T>> cachedRenderer;

                @NotNull
                public BlockEntityRenderer<T> create(@NotNull BlockEntityRendererProvider.Context context) {
                    BlockEntityRenderer renderer;
                    BlockEntityRenderer blockEntityRenderer = renderer = this.cachedRenderer == null ? null : (BlockEntityRenderer)this.cachedRenderer.get();
                    if (this.cachedContext == null || this.cachedContext.get() != context || renderer == null) {
                        renderer = rendererProvider.create(context);
                        this.cachedContext = new WeakReference<BlockEntityRendererProvider.Context>(context);
                        this.cachedRenderer = new WeakReference<BlockEntityRenderer>(renderer);
                    }
                    return renderer;
                }
            };
            for (TileEntityTypeRegistryObject<? extends T> tileTypeRO : tileEntityTypeROs) {
                event.registerBlockEntityRenderer((BlockEntityType)tileTypeRO.get(), provider);
            }
        }
    }

    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event, PreparableReloadListener ... listeners) {
        for (PreparableReloadListener listener : listeners) {
            event.registerReloadListener(listener);
        }
    }

    public static <C extends AbstractContainerMenu, U extends Screen> void registerScreen(RegisterMenuScreensEvent event, ContainerTypeRegistryObject<C> type, MenuScreens.ScreenConstructor<C, U> factory) {
        event.register((MenuType)type.get(), factory);
    }

    public static <TILE extends TileEntityElectricMachine, C extends MekanismTileContainer<TILE>> void registerElectricScreen(RegisterMenuScreensEvent event, ContainerTypeRegistryObject<C> type) {
        ClientRegistrationUtil.registerScreen(event, type, GuiElectricMachine::new);
    }

    public static <TILE extends TileEntityAdvancedElectricMachine, C extends MekanismTileContainer<TILE>> void registerAdvancedElectricScreen(RegisterMenuScreensEvent event, ContainerTypeRegistryObject<C> type) {
        ClientRegistrationUtil.registerScreen(event, type, GuiAdvancedElectricMachine::new);
    }

    public static void registerKeyBindings(RegisterKeyMappingsEvent event, KeyMapping ... keys) {
        for (KeyMapping key : keys) {
            event.register(key);
        }
    }

    public static void setPropertyOverride(IItemProvider itemProvider, ResourceLocation override, ItemPropertyFunction propertyGetter) {
        ItemProperties.register((Item)itemProvider.asItem(), (ResourceLocation)override, (ItemPropertyFunction)propertyGetter);
    }

    public static void registerItemColorHandler(RegisterColorHandlersEvent.Item event, ItemColor itemColor, IItemProvider ... items) {
        for (IItemProvider itemProvider : items) {
            event.register(itemColor, new ItemLike[]{itemProvider.asItem()});
        }
    }

    public static void registerBlockColorHandler(RegisterColorHandlersEvent.Block event, BlockColor blockColor, IBlockProvider ... blocks) {
        for (IBlockProvider blockProvider : blocks) {
            event.register(blockColor, new Block[]{blockProvider.getBlock()});
        }
    }

    public static void registerBucketColorHandler(RegisterColorHandlersEvent.Item event, FluidDeferredRegister register) {
        for (Holder holder : register.getBucketEntries()) {
            event.register(BUCKET_ITEM_COLOR, new ItemLike[]{(ItemLike)holder.value()});
        }
    }

    public static void registerIColoredBlockHandler(RegisterColorHandlersEvent event, IBlockProvider ... blocks) {
        if (event instanceof RegisterColorHandlersEvent.Block) {
            RegisterColorHandlersEvent.Block blockEvent = (RegisterColorHandlersEvent.Block)event;
            ClientRegistrationUtil.registerBlockColorHandler(blockEvent, COLORED_BLOCK_COLOR, blocks);
        } else if (event instanceof RegisterColorHandlersEvent.Item) {
            RegisterColorHandlersEvent.Item itemEvent = (RegisterColorHandlersEvent.Item)event;
            ClientRegistrationUtil.registerItemColorHandler(itemEvent, COLORED_BLOCK_ITEM_COLOR, blocks);
        }
    }

    public static void registerIColoredItemHandler(RegisterColorHandlersEvent.Item event, IItemProvider ... items) {
        ClientRegistrationUtil.registerItemColorHandler(event, COLORED_ITEM_COLOR, items);
    }

    public static void registerItemExtensions(RegisterClientExtensionsEvent event, IClientItemExtensions extension, IItemProvider ... items) {
        for (IItemProvider item : items) {
            event.registerItem(extension, new Item[]{item.asItem()});
        }
    }

    public static void registerBlockExtensions(RegisterClientExtensionsEvent event, BlockDeferredRegister allBlocks) {
        for (DeferredHolder primaryEntry : allBlocks.getPrimaryEntries()) {
            if (!(primaryEntry.get() instanceof BlockMekanism)) continue;
            event.registerBlock(RenderPropertiesProvider.PARTICLE_HANDLER, new Holder[]{primaryEntry});
        }
    }

    public static void registerFluidExtensions(RegisterClientExtensionsEvent event, FluidDeferredRegister allFluids) {
        for (DeferredHolder<FluidType, ? extends FluidType> fluidTypeEntry : allFluids.getFluidTypeEntries()) {
            Object object = fluidTypeEntry.get();
            if (!(object instanceof FluidDeferredRegister.MekanismFluidType)) continue;
            final FluidDeferredRegister.MekanismFluidType fluidType = (FluidDeferredRegister.MekanismFluidType)((Object)object);
            event.registerFluidType(new IClientFluidTypeExtensions(){

                @NotNull
                public ResourceLocation getStillTexture() {
                    return fluidType.stillTexture;
                }

                @NotNull
                public ResourceLocation getFlowingTexture() {
                    return fluidType.flowingTexture;
                }

                public ResourceLocation getOverlayTexture() {
                    return fluidType.overlayTexture;
                }

                @Nullable
                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return fluidType.renderOverlayTexture;
                }

                @NotNull
                public Vector3f modifyFogColor(@NotNull Camera camera, float partialTick, @NotNull ClientLevel level, int renderDistance, float darkenWorldAmount, @NotNull Vector3f fluidFogColor) {
                    return new Vector3f(MekanismRenderer.getRed(this.getTintColor()), MekanismRenderer.getGreen(this.getTintColor()), MekanismRenderer.getBlue(this.getTintColor()));
                }

                public void modifyFogRender(@NotNull Camera camera, @NotNull FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, @NotNull FogShape shape) {
                    farDistance = 24.0f;
                    if (farDistance > renderDistance) {
                        farDistance = renderDistance;
                        shape = FogShape.CYLINDER;
                    }
                    RenderSystem.setShaderFogStart((float)-8.0f);
                    RenderSystem.setShaderFogEnd((float)farDistance);
                    RenderSystem.setShaderFogShape((FogShape)shape);
                }

                public int getTintColor() {
                    return fluidType.color;
                }
            }, new FluidType[]{fluidType});
        }
    }
}

