/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.CompoundChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.DifferenceChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.EmptyChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IntersectionChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.SingleChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.TagChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;

@NothingNullByDefault
public abstract sealed class ChemicalIngredient
implements Predicate<Chemical>
permits CompoundChemicalIngredient, DifferenceChemicalIngredient, EmptyChemicalIngredient, IntersectionChemicalIngredient, SingleChemicalIngredient, TagChemicalIngredient {
    @Nullable
    private List<Chemical> chemicals;

    @Override
    public abstract boolean test(Chemical var1);

    public abstract Stream<Chemical> generateChemicals();

    public final List<Chemical> getChemicals() {
        if (this.chemicals == null) {
            this.chemicals = this.generateChemicals().toList();
        }
        return this.chemicals;
    }

    public final boolean isEmpty() {
        return this == IngredientCreatorAccess.chemical().empty();
    }

    public final boolean hasNoChemicals() {
        return this.getChemicals().isEmpty();
    }

    public abstract MapCodec<? extends ChemicalIngredient> codec();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

