/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class ChemicalStackIngredient
implements InputIngredient<ChemicalStack> {
    public static final Codec<ChemicalStackIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.chemical().mapCodecNonEmpty().forGetter(ChemicalStackIngredient::ingredient), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStackIngredient::amount)).apply((Applicative)instance, ChemicalStackIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalStackIngredient> STREAM_CODEC = StreamCodec.composite(IngredientCreatorAccess.chemical().streamCodec(), ChemicalStackIngredient::ingredient, (StreamCodec)ByteBufCodecs.VAR_LONG, ChemicalStackIngredient::amount, ChemicalStackIngredient::new);
    private final ChemicalIngredient ingredient;
    private final long amount;
    @Nullable
    private List<ChemicalStack> representations;

    public static ChemicalStackIngredient of(ChemicalIngredient ingredient, long amount) {
        Objects.requireNonNull(ingredient, "ChemicalStackIngredients cannot be created from a null ingredient.");
        if (ingredient.isEmpty()) {
            throw new IllegalArgumentException("ChemicalStackIngredients cannot be created using the empty ingredient.");
        }
        return new ChemicalStackIngredient(ingredient, amount);
    }

    public ChemicalStackIngredient(ChemicalIngredient ingredient, long amount) {
        if (amount <= 0L) {
            throw new IllegalArgumentException("Size must be positive");
        }
        this.ingredient = ingredient;
        this.amount = amount;
    }

    @Override
    public boolean test(ChemicalStack stack) {
        return this.testType(stack) && stack.getAmount() >= this.amount;
    }

    @Override
    public boolean testType(ChemicalStack stack) {
        Objects.requireNonNull(stack);
        return this.testType(stack.getChemical());
    }

    @Override
    public boolean testType(Chemical chemical) {
        Objects.requireNonNull(chemical);
        return this.ingredient.test(chemical);
    }

    @Override
    public ChemicalStack getMatchingInstance(ChemicalStack stack) {
        return this.test(stack) ? stack.copyWithAmount(this.amount) : ChemicalStack.EMPTY;
    }

    @Override
    public long getNeededAmount(ChemicalStack stack) {
        return this.testType(stack) ? this.amount : 0L;
    }

    @Override
    public boolean hasNoMatchingInstances() {
        return this.ingredient.hasNoChemicals();
    }

    @Override
    public List<ChemicalStack> getRepresentations() {
        if (this.representations == null) {
            this.representations = this.ingredient.getChemicals().stream().map(s -> s.getStack(this.amount)).toList();
        }
        return this.representations;
    }

    public ChemicalIngredient ingredient() {
        return this.ingredient;
    }

    public long amount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChemicalStackIngredient other = (ChemicalStackIngredient)o;
        return this.amount == other.amount && this.ingredient.equals(other.ingredient);
    }

    public int hashCode() {
        return Objects.hash(this.ingredient, this.amount);
    }

    public String toString() {
        return this.amount + "x " + String.valueOf(this.ingredient);
    }
}

