/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import com.mojang.serialization.Codec;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleConfigListCodec;
import mekanism.api.gear.config.ModuleBooleanConfig;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.api.providers.IItemProvider;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ModuleData<MODULE extends ICustomModule<MODULE>>
implements IModuleDataProvider<MODULE> {
    private final Function<@NotNull IModule<MODULE>, @NotNull MODULE> constructor;
    private final Int2ObjectMap<ConstructedConfigData> configData;
    private final IItemProvider itemProvider;
    private final int maxStackSize;
    private final int exclusive;
    private final boolean noDisable;
    @Nullable
    private String translationKey;
    @Nullable
    private String descriptionTranslationKey;

    public ModuleData(ModuleDataBuilder<MODULE> builder) {
        this.constructor = builder.constructor;
        this.itemProvider = builder.itemProvider;
        this.maxStackSize = builder.maxStackSize;
        this.exclusive = builder.exclusive;
        this.noDisable = builder.noDisable;
        this.configData = new Int2ObjectOpenHashMap(this.maxStackSize);
        builder.ensureConfigsInitialized();
        ObjectIterator iterator = Int2ObjectMaps.fastIterator(builder.configData);
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            this.configData.put(entry.getIntKey(), (Object)((ConfigData)entry.getValue()).construct());
        }
        if (this.configData.size() < this.maxStackSize) {
            ConstructedConfigData defaultData = (ConstructedConfigData)this.configData.get(1);
            for (int i = 2; i <= this.maxStackSize; ++i) {
                ConstructedConfigData sizedData = (ConstructedConfigData)this.configData.get(i);
                if (sizedData != null) continue;
                this.configData.put(i, (Object)defaultData);
            }
        }
    }

    @Override
    @NotNull
    public final ModuleData<MODULE> getModuleData() {
        return this;
    }

    @NotNull
    public final IItemProvider getItemProvider() {
        return this.itemProvider;
    }

    @NotNull
    public final MODULE create(IModule<MODULE> module) {
        return (MODULE)((ICustomModule)this.constructor.apply(module));
    }

    public final int getMaxStackSize() {
        return this.maxStackSize;
    }

    public final boolean isExclusive(int mask) {
        return (this.exclusive & mask) != 0;
    }

    public final int getExclusiveFlags() {
        return this.exclusive;
    }

    public final Codec<List<ModuleConfig<?>>> configCodecs(int installed) {
        return this.getConfigData(installed).codec();
    }

    public final StreamCodec<RegistryFriendlyByteBuf, List<ModuleConfig<?>>> configStreamCodecs(int installed) {
        return this.getConfigData(installed).streamCodec();
    }

    public final List<ModuleConfig<?>> defaultConfigs(int installed) {
        return this.getConfigData(installed).configs();
    }

    @Nullable
    public final ModuleConfig<?> getNamedConfig(int installed, ResourceLocation name) {
        for (ModuleConfig<?> config : this.getConfigData(installed).configs()) {
            if (!config.name().equals((Object)name)) continue;
            return config;
        }
        return null;
    }

    private ConstructedConfigData getConfigData(int installed) {
        if (installed < 1) {
            throw new IllegalArgumentException("Installed number must be at least 1");
        }
        return (ConstructedConfigData)this.configData.get(Math.min(installed, this.maxStackSize));
    }

    public final boolean isNoDisable() {
        return this.noDisable;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.makeDescriptionId((String)"module", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    public String getDescriptionTranslationKey() {
        if (this.descriptionTranslationKey == null) {
            this.descriptionTranslationKey = Util.makeDescriptionId((String)"description", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionTranslationKey;
    }

    @Override
    public final ResourceLocation getRegistryName() {
        return MekanismAPI.MODULE_REGISTRY.getKey((Object)this);
    }

    public static class ModuleDataBuilder<MODULE extends ICustomModule<MODULE>> {
        private static final ModuleConfig<Boolean> ENABLED_BY_DEFAULT = ModuleBooleanConfig.create(ModuleConfig.ENABLED_KEY, true);
        private static final ModuleConfig<Boolean> DISABLED_BY_DEFAULT = ModuleBooleanConfig.create(ModuleConfig.ENABLED_KEY, false);
        private static final ModuleBooleanConfig HANDLES_MODE_CHANGE_ENABLED = ModuleBooleanConfig.create(ModuleConfig.HANDLES_MODE_CHANGE_KEY, true);
        private static final ModuleBooleanConfig HANDLES_MODE_CHANGE_DISABLED = ModuleBooleanConfig.create(ModuleConfig.HANDLES_MODE_CHANGE_KEY, false);
        private static final ModuleBooleanConfig RENDER_HUD = ModuleBooleanConfig.create(ModuleConfig.RENDER_HUD_KEY, true);
        private static final MarkerModule MARKER_MODULE = new MarkerModule();
        private static final Function<IModule<MarkerModule>, MarkerModule> MARKER_MODULE_SUPPLIER = module -> MARKER_MODULE;
        private final Int2ObjectMap<ConfigData> configData = new Int2ObjectOpenHashMap();
        private final Function<@NotNull IModule<MODULE>, @NotNull MODULE> constructor;
        private final IItemProvider itemProvider;
        private final boolean isInstanced;
        private int maxStackSize = 1;
        private int exclusive;
        private boolean handlesModeChange;
        private boolean modeChangeDisabledByDefault;
        private boolean rendersHUD;
        private boolean noDisable;
        private boolean disabledByDefault;

        public static ModuleDataBuilder<?> marker(IItemProvider itemProvider) {
            return new ModuleDataBuilder<MarkerModule>(MARKER_MODULE_SUPPLIER, itemProvider, true);
        }

        public static <MODULE extends ICustomModule<MODULE>> ModuleDataBuilder<MODULE> customInstanced(Supplier<@NotNull MODULE> customModule, IItemProvider itemProvider) {
            ICustomModule customModuleInstance = (ICustomModule)customModule.get();
            Function<IModule, ICustomModule> function = module -> customModuleInstance;
            return new ModuleDataBuilder<ICustomModule>(function, itemProvider, true);
        }

        public static <MODULE extends ICustomModule<MODULE>> ModuleDataBuilder<MODULE> custom(Function<IModule<MODULE>, @NotNull MODULE> customModule, IItemProvider itemProvider) {
            return new ModuleDataBuilder<MODULE>(customModule, itemProvider, false);
        }

        private ModuleDataBuilder(Function<@NotNull IModule<MODULE>, @NotNull MODULE> constructor, IItemProvider itemProvider, boolean isInstanced) {
            this.constructor = Objects.requireNonNull(constructor, "Custom module constructor cannot be null.");
            this.itemProvider = Objects.requireNonNull(itemProvider, "Item provider cannot be null.");
            this.isInstanced = isInstanced;
        }

        public ModuleDataBuilder<MODULE> maxStackSize(int maxStackSize) {
            if (maxStackSize <= 0) {
                throw new IllegalArgumentException("Max stack size must be at least one.");
            }
            if (!this.configData.isEmpty()) {
                throw new IllegalStateException("Max stack size should be set before adding any configs.");
            }
            this.maxStackSize = maxStackSize;
            return this;
        }

        public ModuleDataBuilder<MODULE> exclusive(int mask) {
            this.exclusive = mask;
            return this;
        }

        public ModuleDataBuilder<MODULE> exclusive(ExclusiveFlag ... flags) {
            return this.exclusive(flags.length == 0 ? -1 : ExclusiveFlag.getCompoundMask(flags));
        }

        public ModuleDataBuilder<MODULE> handlesModeChange() {
            if (!this.configData.isEmpty()) {
                throw new IllegalStateException("Mode change behavior must be set before adding any configs.");
            }
            this.handlesModeChange = true;
            return this;
        }

        public ModuleDataBuilder<MODULE> modeChangeDisabledByDefault() {
            if (!this.handlesModeChange) {
                throw new IllegalStateException("Cannot have a module type that has mode change disabled by default but doesn't support changing modes.");
            }
            if (!this.configData.isEmpty()) {
                throw new IllegalStateException("Mode change being disabled by default must be done before adding any configs.");
            }
            this.modeChangeDisabledByDefault = true;
            return this;
        }

        private void ensureConfigsInitialized() {
            if (this.configData.isEmpty()) {
                ArrayList streamCodecs = new ArrayList();
                ArrayList codecs = new ArrayList();
                ArrayList configs = new ArrayList();
                configs.add(this.disabledByDefault ? DISABLED_BY_DEFAULT : ENABLED_BY_DEFAULT);
                codecs.add(ModuleBooleanConfig.CODEC);
                streamCodecs.add(ModuleBooleanConfig.STREAM_CODEC);
                if (this.handlesModeChange) {
                    configs.add(this.modeChangeDisabledByDefault ? HANDLES_MODE_CHANGE_DISABLED : HANDLES_MODE_CHANGE_ENABLED);
                    codecs.add(ModuleBooleanConfig.CODEC);
                    streamCodecs.add(ModuleBooleanConfig.STREAM_CODEC);
                }
                if (this.rendersHUD) {
                    configs.add(RENDER_HUD);
                    codecs.add(ModuleBooleanConfig.CODEC);
                    streamCodecs.add(ModuleBooleanConfig.STREAM_CODEC);
                }
                this.configData.put(1, (Object)new ConfigData(configs, codecs, streamCodecs));
            }
        }

        public ModuleDataBuilder<MODULE> addConfig(ModuleBooleanConfig defaultConfig) {
            return this.addConfig(defaultConfig, ModuleBooleanConfig.CODEC, ModuleBooleanConfig.STREAM_CODEC);
        }

        public <TYPE, CONFIG extends ModuleConfig<TYPE>> ModuleDataBuilder<MODULE> addConfig(CONFIG defaultConfig, Codec<CONFIG> codec, StreamCodec<? super RegistryFriendlyByteBuf, CONFIG> streamCodec) {
            if (this.isInstanced) {
                throw new IllegalStateException("Custom configs are not supported for instance based modules");
            }
            this.ensureConfigsInitialized();
            for (ConfigData data : this.configData.values()) {
                data.configs().add(defaultConfig);
                data.codecs().add(codec);
                data.streamCodecs().add(streamCodec);
            }
            return this;
        }

        public <TYPE, CONFIG extends ModuleConfig<TYPE>> ModuleDataBuilder<MODULE> addInstalledCountConfig(IntFunction<CONFIG> defaultConfig, IntFunction<Codec<CONFIG>> codec, IntFunction<StreamCodec<? super RegistryFriendlyByteBuf, CONFIG>> streamCodec) {
            return this.addInstalledCountConfig(installed -> true, defaultConfig, codec, streamCodec);
        }

        public <TYPE, CONFIG extends ModuleConfig<TYPE>> ModuleDataBuilder<MODULE> addMaxInstalledConfig(IntFunction<CONFIG> defaultConfig, IntFunction<Codec<CONFIG>> codec, IntFunction<StreamCodec<? super RegistryFriendlyByteBuf, CONFIG>> streamCodec) {
            return this.addInstalledCountConfig(installed -> installed == this.maxStackSize, defaultConfig, codec, streamCodec);
        }

        public <TYPE, CONFIG extends ModuleConfig<TYPE>> ModuleDataBuilder<MODULE> addInstalledCountConfig(IntPredicate shouldAdd, IntFunction<CONFIG> defaultConfig, IntFunction<Codec<CONFIG>> codec, IntFunction<StreamCodec<? super RegistryFriendlyByteBuf, CONFIG>> streamCodec) {
            if (this.isInstanced) {
                throw new IllegalStateException("Custom configs are not supported for instance based modules");
            }
            if (this.maxStackSize == 1) {
                throw new IllegalStateException("Cannot add an config that is based on the number of installed modules when the max amount is one");
            }
            this.ensureConfigsInitialized();
            ConfigData data = (ConfigData)this.configData.get(1);
            for (int i = 2; i <= this.maxStackSize; ++i) {
                ConfigData sizedData = (ConfigData)this.configData.get(i);
                if (sizedData == null) {
                    sizedData = data.copy();
                    this.configData.put(i, (Object)sizedData);
                }
                if (!shouldAdd.test(i)) continue;
                sizedData.codecs().add(codec.apply(i));
                sizedData.configs().add((ModuleConfig)defaultConfig.apply(i));
                sizedData.streamCodecs().add(streamCodec.apply(i));
            }
            if (shouldAdd.test(1)) {
                data.codecs().add(codec.apply(1));
                data.configs().add((ModuleConfig)defaultConfig.apply(1));
                data.streamCodecs().add(streamCodec.apply(1));
            }
            return this;
        }

        public ModuleDataBuilder<MODULE> rendersHUD() {
            if (!this.configData.isEmpty()) {
                throw new IllegalStateException("Whether the module renders a hud must be done before adding any configs.");
            }
            this.rendersHUD = true;
            return this;
        }

        public ModuleDataBuilder<MODULE> noDisable() {
            if (this.disabledByDefault) {
                throw new IllegalStateException("Cannot have a module type that is unable to be disabled and also disabled by default.");
            }
            this.noDisable = true;
            return this;
        }

        public ModuleDataBuilder<MODULE> disabledByDefault() {
            if (this.noDisable) {
                throw new IllegalStateException("Cannot have a module type that is unable to be disabled and also disabled by default.");
            }
            if (!this.configData.isEmpty()) {
                throw new IllegalStateException("Being disabled by default must be done before adding any configs.");
            }
            this.disabledByDefault = true;
            return this;
        }

        private record MarkerModule() implements ICustomModule<MarkerModule>
        {
        }
    }

    private record ConfigData(List<ModuleConfig<?>> configs, List<Codec<? extends ModuleConfig<?>>> codecs, List<StreamCodec<? super RegistryFriendlyByteBuf, ? extends ModuleConfig<?>>> streamCodecs) {
        private ConstructedConfigData construct() {
            HashSet<ResourceLocation> uniqueNames = new HashSet<ResourceLocation>(this.configs.size());
            for (ModuleConfig<?> config : this.configs) {
                if (uniqueNames.add(config.name())) continue;
                throw new IllegalStateException("Duplicate module config name " + String.valueOf(config.name()));
            }
            return ConstructedConfigData.create(List.copyOf(this.configs), List.copyOf(this.codecs), List.copyOf(this.streamCodecs));
        }

        private ConfigData copy() {
            return new ConfigData(new ArrayList(this.configs), new ArrayList(this.codecs), new ArrayList(this.streamCodecs));
        }
    }

    private record ConstructedConfigData(List<ModuleConfig<?>> configs, Codec<List<ModuleConfig<?>>> codec, StreamCodec<RegistryFriendlyByteBuf, List<ModuleConfig<?>>> streamCodec) {
        private static ConstructedConfigData create(List<ModuleConfig<?>> configs, List<Codec<? extends ModuleConfig<?>>> codecs, final List<StreamCodec<? super RegistryFriendlyByteBuf, ? extends ModuleConfig<?>>> streamCodecs) {
            return new ConstructedConfigData(configs, new ModuleConfigListCodec(codecs), new StreamCodec<RegistryFriendlyByteBuf, List<ModuleConfig<?>>>(){

                public List<ModuleConfig<?>> decode(RegistryFriendlyByteBuf buffer) {
                    ArrayList configs = new ArrayList(streamCodecs.size());
                    for (StreamCodec streamCodec : streamCodecs) {
                        configs.add((ModuleConfig)streamCodec.decode((Object)buffer));
                    }
                    return configs;
                }

                public void encode(RegistryFriendlyByteBuf buffer, List<ModuleConfig<?>> configs) {
                    int size = streamCodecs.size();
                    if (configs.size() != size) {
                        throw new EncoderException("Number of configs to encode does not match the number of stream codecs we have");
                    }
                    for (int i = 0; i < size; ++i) {
                        StreamCodec streamCodec = (StreamCodec)streamCodecs.get(i);
                        streamCodec.encode((Object)buffer, configs.get(i));
                    }
                }
            });
        }
    }

    public static enum ExclusiveFlag {
        INTERACT_EMPTY,
        INTERACT_ENTITY,
        INTERACT_BLOCK,
        OVERRIDE_JUMP,
        OVERRIDE_DROPS;

        public static final int NONE = 0;
        public static final int ANY = -1;
        public static final int INTERACT_ANY;

        public int getMask() {
            return 1 << this.ordinal();
        }

        public static int getCompoundMask(ExclusiveFlag ... flags) {
            return Arrays.stream(flags).mapToInt(ExclusiveFlag::getMask).reduce(0, (result, mask) -> result | mask);
        }

        static {
            INTERACT_ANY = ExclusiveFlag.getCompoundMask(INTERACT_EMPTY, INTERACT_ENTITY, INTERACT_BLOCK);
        }
    }
}

