/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.datagen.recipe.RecipeCriterion;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

@NothingNullByDefault
public abstract class MekanismRecipeBuilder<BUILDER extends MekanismRecipeBuilder<BUILDER>> {
    protected final List<ICondition> conditions = new ArrayList<ICondition>();
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    protected MekanismRecipeBuilder() {
    }

    public BUILDER unlockedBy(RecipeCriterion criterion) {
        return this.unlockedBy(criterion.name(), criterion.criterion());
    }

    public BUILDER unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return (BUILDER)this;
    }

    public BUILDER addCondition(ICondition condition) {
        this.conditions.add(condition);
        return (BUILDER)this;
    }

    protected abstract Recipe<?> asRecipe();

    protected void validate(ResourceLocation id) {
    }

    public void build(RecipeOutput recipeOutput, ResourceLocation id) {
        this.validate(id);
        AdvancementHolder advancementHolder = null;
        if (!this.criteria.isEmpty()) {
            Advancement.Builder advancementBuilder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
            advancementHolder = advancementBuilder.build(id.withPrefix("recipes/"));
        }
        recipeOutput.accept(id, this.asRecipe(), advancementHolder, this.conditions.toArray(new ICondition[0]));
    }

    protected void build(RecipeOutput recipeOutput, ItemLike output) {
        ResourceLocation registryName = BuiltInRegistries.ITEM.getResourceKey((Object)output.asItem()).map(ResourceKey::location).orElseThrow(() -> new IllegalStateException("Could not retrieve registry name for output."));
        this.build(recipeOutput, registryName);
    }
}

