/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;

@NothingNullByDefault
public interface IChemicalTank
extends INBTSerializable<CompoundTag>,
IContentsListener {
    public ChemicalStack getStack();

    public void setStack(ChemicalStack var1);

    public void setStackUnchecked(ChemicalStack var1);

    default public ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty() || !this.isValid(stack)) {
            return stack;
        }
        long needed = this.getNeeded();
        if (needed <= 0L) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = this.isTypeEqual(stack))) {
            long toAdd = Math.min(stack.getAmount(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.growStack(toAdd, action);
                } else {
                    this.setStack(stack.copyWithAmount(toAdd));
                }
            }
            return stack.copyWithAmount(stack.getAmount() - toAdd);
        }
        return stack;
    }

    default public ChemicalStack extract(long amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1L) {
            return ChemicalStack.EMPTY;
        }
        ChemicalStack ret = this.getStack().copyWithAmount(Math.min(this.getStored(), amount));
        if (!ret.isEmpty() && action.execute()) {
            this.shrinkStack(ret.getAmount(), action);
        }
        return ret;
    }

    public long getCapacity();

    public boolean isValid(ChemicalStack var1);

    default public long setStackSize(long amount, Action action) {
        if (this.isEmpty()) {
            return 0L;
        }
        if (amount <= 0L) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0L;
        }
        long maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getStored() == amount || action.simulate()) {
            return amount;
        }
        this.setStack(this.getStack().copyWithAmount(amount));
        return amount;
    }

    default public long growStack(long amount, Action action) {
        long current = this.getStored();
        if (current == 0L) {
            return 0L;
        }
        if (amount > 0L) {
            amount = Math.min(amount, this.getNeeded());
        }
        long newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    default public long shrinkStack(long amount, Action action) {
        return -this.growStack(-amount, action);
    }

    default public boolean isEmpty() {
        return this.getStack().isEmpty();
    }

    default public void setEmpty() {
        this.setStack(ChemicalStack.EMPTY);
    }

    default public long getStored() {
        return this.getStack().getAmount();
    }

    default public long getNeeded() {
        return Math.max(0L, this.getCapacity() - this.getStored());
    }

    default public Chemical getType() {
        return this.getStack().getChemical();
    }

    default public boolean isTypeEqual(ChemicalStack other) {
        return ChemicalStack.isSameChemical(this.getStack(), other);
    }

    default public boolean isTypeEqual(Chemical other) {
        return this.getStack().is(other);
    }

    default public ChemicalAttributeValidator getAttributeValidator() {
        return ChemicalAttributeValidator.DEFAULT;
    }

    default public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.put("stored", this.getStack().save(provider));
        }
        return nbt;
    }

    default public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains("stored", 10)) {
            this.setStackUnchecked(ChemicalStack.parseOptional(provider, nbt.getCompound("stored")));
        }
    }
}

