/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.container.ContainerInteraction;
import mekanism.api.container.InContainerGetter;
import mekanism.api.container.LongContainerInteraction;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalUtils {
    private ChemicalUtils() {
    }

    public static ChemicalStack insert(ChemicalStack stack, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<ChemicalStack> inTankGetter, ContainerInteraction<ChemicalStack> insertChemical) {
        ChemicalStack remainder;
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return stack;
        }
        if (tanks == 1) {
            return insertChemical.interact(0, stack, side, action);
        }
        ChemicalStack toInsert = stack;
        IntArrayList emptyTanks = new IntArrayList();
        for (int tank = 0; tank < tanks; ++tank) {
            ChemicalStack inTank = inTankGetter.getStored(tank, side);
            if (inTank.isEmpty()) {
                emptyTanks.add(tank);
                continue;
            }
            if (!ChemicalStack.isSameChemical(inTank, stack)) continue;
            remainder = insertChemical.interact(tank, toInsert, side, action);
            if (remainder.isEmpty()) {
                return ChemicalStack.EMPTY;
            }
            toInsert = remainder;
        }
        IntListIterator intListIterator = emptyTanks.iterator();
        while (intListIterator.hasNext()) {
            int tank = (Integer)intListIterator.next();
            remainder = insertChemical.interact(tank, toInsert, side, action);
            if (remainder.isEmpty()) {
                return ChemicalStack.EMPTY;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static ChemicalStack insert(ChemicalStack stack, @Nullable Direction side, Function<@Nullable Direction, List<IChemicalTank>> tankSupplier, Action action, AutomationType automationType) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        List<IChemicalTank> chemicalTanks = tankSupplier.apply(side);
        return ChemicalUtils.insert(stack, action, automationType, chemicalTanks.size(), chemicalTanks);
    }

    public static ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType, int size, List<IChemicalTank> chemicalTanks) {
        ChemicalStack remainder;
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        if (size == 0) {
            return stack;
        }
        if (size == 1) {
            return chemicalTanks.get(0).insert(stack, action, automationType);
        }
        ChemicalStack toInsert = stack;
        ArrayList<IChemicalTank> emptyTanks = new ArrayList<IChemicalTank>();
        for (IChemicalTank tank : chemicalTanks) {
            if (tank.isEmpty()) {
                emptyTanks.add(tank);
                continue;
            }
            if (!tank.isTypeEqual(stack)) continue;
            remainder = tank.insert(toInsert, action, automationType);
            if (remainder.isEmpty()) {
                return ChemicalStack.EMPTY;
            }
            toInsert = remainder;
        }
        for (IChemicalTank tank : emptyTanks) {
            remainder = tank.insert(toInsert, action, automationType);
            if (remainder.isEmpty()) {
                return ChemicalStack.EMPTY;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static ChemicalStack extract(long amount, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<ChemicalStack> inTankGetter, LongContainerInteraction<ChemicalStack> extractChemical) {
        if (amount == 0L) {
            return ChemicalStack.EMPTY;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return ChemicalStack.EMPTY;
        }
        if (tanks == 1) {
            return extractChemical.interact(0, amount, side, action);
        }
        ChemicalStack extracted = ChemicalStack.EMPTY;
        long toDrain = amount;
        for (int tank = 0; tank < tanks; ++tank) {
            ChemicalStack drained;
            if (!extracted.isEmpty() && !ChemicalStack.isSameChemical(extracted, inTankGetter.getStored(tank, side)) || (drained = extractChemical.interact(tank, toDrain, side, action)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) == 0L) break;
        }
        return extracted;
    }

    public static ChemicalStack extract(long amount, @Nullable Direction side, Function<@Nullable Direction, List<IChemicalTank>> tankSupplier, Action action, AutomationType automationType) {
        if (amount == 0L) {
            return ChemicalStack.EMPTY;
        }
        List<IChemicalTank> chemicalTanks = tankSupplier.apply(side);
        return ChemicalUtils.extract(amount, action, automationType, chemicalTanks.size(), chemicalTanks);
    }

    public static ChemicalStack extract(long amount, Action action, AutomationType automationType, int size, List<IChemicalTank> chemicalTanks) {
        if (amount == 0L || size == 0) {
            return ChemicalStack.EMPTY;
        }
        if (size == 1) {
            return chemicalTanks.get(0).extract(amount, action, automationType);
        }
        ChemicalStack extracted = ChemicalStack.EMPTY;
        long toDrain = amount;
        for (IChemicalTank tank : chemicalTanks) {
            ChemicalStack drained;
            if (!extracted.isEmpty() && !tank.isTypeEqual(extracted) || (drained = tank.extract(toDrain, action, automationType)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) != 0L) continue;
            break;
        }
        return extracted;
    }

    public static ChemicalStack extract(ChemicalStack stack, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<ChemicalStack> inTankGetter, LongContainerInteraction<ChemicalStack> extractChemical) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return ChemicalStack.EMPTY;
        }
        if (tanks == 1) {
            ChemicalStack inTank = inTankGetter.getStored(0, side);
            if (inTank.isEmpty() || !ChemicalStack.isSameChemical(inTank, stack)) {
                return ChemicalStack.EMPTY;
            }
            return extractChemical.interact(0, stack.getAmount(), side, action);
        }
        ChemicalStack extracted = ChemicalStack.EMPTY;
        long toDrain = stack.getAmount();
        for (int tank = 0; tank < tanks; ++tank) {
            ChemicalStack drained;
            if (!extracted.isEmpty() && !ChemicalStack.isSameChemical(stack, inTankGetter.getStored(tank, side)) || (drained = extractChemical.interact(tank, toDrain, side, action)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) == 0L) break;
        }
        return extracted;
    }

    public static ChemicalStack extract(ChemicalStack stack, @Nullable Direction side, Function<@Nullable Direction, List<IChemicalTank>> tankSupplier, Action action, AutomationType automationType) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        List<IChemicalTank> chemicalTanks = tankSupplier.apply(side);
        return ChemicalUtils.extract(stack, action, automationType, chemicalTanks.size(), chemicalTanks);
    }

    public static ChemicalStack extract(ChemicalStack stack, Action action, AutomationType automationType, int size, Iterable<IChemicalTank> chemicalTanks) {
        if (stack.isEmpty() || size == 0) {
            return ChemicalStack.EMPTY;
        }
        if (size == 1) {
            IChemicalTank tank = chemicalTanks.iterator().next();
            if (tank.isEmpty() || !tank.isTypeEqual(stack)) {
                return ChemicalStack.EMPTY;
            }
            return tank.extract(stack.getAmount(), action, automationType);
        }
        ChemicalStack extracted = ChemicalStack.EMPTY;
        long toDrain = stack.getAmount();
        for (IChemicalTank tank : chemicalTanks) {
            ChemicalStack drained;
            if (!tank.isTypeEqual(stack) || (drained = tank.extract(toDrain, action, automationType)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) != 0L) continue;
            break;
        }
        return extracted;
    }
}

