/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class SerializerHelper {
    public static final Codec<Long> POSITIVE_LONG_CODEC = (Codec)Util.make(() -> {
        Function checker = Codec.checkRange((Number)0L, (Number)Long.MAX_VALUE);
        return Codec.LONG.flatXmap(checker, checker);
    });
    public static final Codec<Long> POSITIVE_NONZERO_LONG_CODEC = (Codec)Util.make(() -> {
        Function checker = Codec.checkRange((Number)1L, (Number)Long.MAX_VALUE);
        return Codec.LONG.flatXmap(checker, checker);
    });
    @Deprecated(since="10.6.6", forRemoval=true)
    private static final Codec<Long> LEGACY_CODEC_FLOATING_LONG = new PrimitiveCodec<Long>(){

        public <T> DataResult<Long> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).flatMap(number -> {
                try {
                    int index = number.indexOf(46);
                    long value = index == -1 ? Long.parseUnsignedLong(number) : Long.parseUnsignedLong(number, 0, index, 10);
                    if (value < 0L) {
                        value = Long.MAX_VALUE;
                    }
                    if (value == 0L && index != -1 && Long.parseLong(number, index + 1, number.length(), 10) > 0L) {
                        return DataResult.success((Object)1L);
                    }
                    return DataResult.success((Object)value);
                }
                catch (NumberFormatException e) {
                    return DataResult.error(e::getMessage);
                }
            });
        }

        public <T> T write(DynamicOps<T> ops, Long value) {
            return (T)ops.createLong(value.longValue());
        }

        public String toString() {
            return "LegacyFloatingLong";
        }
    };
    @Deprecated(since="10.6.6", forRemoval=true)
    public static final Codec<Long> POSITIVE_LONG_CODEC_LEGACY = Codec.withAlternative(POSITIVE_LONG_CODEC, LEGACY_CODEC_FLOATING_LONG);
    @Deprecated(since="10.6.6", forRemoval=true)
    public static final Codec<Long> POSITIVE_NONZERO_LONG_CODEC_LEGACY = Codec.withAlternative(POSITIVE_NONZERO_LONG_CODEC, (Codec)LEGACY_CODEC_FLOATING_LONG.validate(val -> val == 0L ? DataResult.error(() -> "Value must be greater than zero") : DataResult.success((Object)val)));
    private static final Consumer<String> ON_STACK_LOAD_ERROR = error -> MekanismAPI.logger.error("Tried to load invalid item: '{}'", error);
    public static final Codec<ItemStack> LENIENT_OPTIONAL_STACK_CODEC = ItemStack.OPTIONAL_CODEC.promotePartial(ON_STACK_LOAD_ERROR).orElse((Object)ItemStack.EMPTY);
    public static final Codec<ItemStack> OPTIONAL_SINGLE_ITEM_CODEC = ExtraCodecs.optionalEmptyMap((Codec)ItemStack.SINGLE_ITEM_CODEC).xmap(stack -> stack.orElse(ItemStack.EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    public static final Codec<ItemStack> LENIENT_OPTIONAL_SINGLE_ITEM_CODEC = OPTIONAL_SINGLE_ITEM_CODEC.promotePartial(ON_STACK_LOAD_ERROR).orElse((Object)ItemStack.EMPTY);
    public static final Codec<FluidStack> LENIENT_OPTIONAL_FLUID_CODEC = FluidStack.OPTIONAL_CODEC.promotePartial(error -> MekanismAPI.logger.error("Tried to load invalid fluid: '{}'", error)).orElse((Object)FluidStack.EMPTY);
    public static final Codec<ItemStack> OVERSIZED_ITEM_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.POSITIVE_INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> OVERSIZED_ITEM_OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(OVERSIZED_ITEM_CODEC).xmap(optional -> optional.orElse(ItemStack.EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    public static final Codec<ItemStack> LENIENT_OVERSIZED_ITEM_OPTIONAL_CODEC = OVERSIZED_ITEM_OPTIONAL_CODEC.promotePartial(ON_STACK_LOAD_ERROR).orElse((Object)ItemStack.EMPTY);

    private SerializerHelper() {
    }

    public static Tag saveOversized(HolderLookup.Provider registryAccess, ItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (Tag)OVERSIZED_ITEM_CODEC.encodeStart((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack).getOrThrow();
    }

    public static Optional<ItemStack> parseOversized(HolderLookup.Provider pLookupProvider, Tag pTag) {
        return OVERSIZED_ITEM_CODEC.parse((DynamicOps)pLookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)pTag).resultOrPartial(ON_STACK_LOAD_ERROR);
    }

    public static ItemStack parseOversizedOptional(HolderLookup.Provider pLookupProvider, CompoundTag tag) {
        return tag.isEmpty() ? ItemStack.EMPTY : SerializerHelper.parseOversized(pLookupProvider, (Tag)tag).orElse(ItemStack.EMPTY);
    }

    @NotNull
    public static <SOURCE, THIS_TYPE> RecordCodecBuilder<SOURCE, Optional<THIS_TYPE>> dependentOptionality(RecordCodecBuilder<SOURCE, ? extends Optional<?>> primaryField, final MapCodec<Optional<THIS_TYPE>> dependentCodec, Function<SOURCE, Optional<THIS_TYPE>> dependentGetter) {
        MapDecoder.Implementation dependentRequired = new MapDecoder.Implementation<Optional<THIS_TYPE>>(){

            public <T> DataResult<Optional<THIS_TYPE>> decode(DynamicOps<T> ops, MapLike<T> input) {
                DataResult thisField = dependentCodec.decode(ops, input);
                if (thisField.error().isPresent() || thisField.result().orElse(Optional.empty()).isPresent()) {
                    return thisField;
                }
                return DataResult.error(() -> "Missing value");
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return dependentCodec.keys(ops);
            }
        };
        return primaryField.dependent(dependentGetter, dependentCodec, arg_0 -> SerializerHelper.lambda$dependentOptionality$12(dependentCodec, (MapDecoder.Implementation)dependentRequired, arg_0));
    }

    @NotNull
    public static <SOURCE, THIS_TYPE> RecordCodecBuilder<SOURCE, Optional<THIS_TYPE>> oneRequired(RecordCodecBuilder<SOURCE, ? extends Optional<?>> otherField, final MapCodec<Optional<THIS_TYPE>> dependentCodec, Function<SOURCE, Optional<THIS_TYPE>> dependentGetter) {
        MapDecoder.Implementation dependentRequired = new MapDecoder.Implementation<Optional<THIS_TYPE>>(){

            public <T> DataResult<Optional<THIS_TYPE>> decode(DynamicOps<T> ops, MapLike<T> input) {
                DataResult thisField = dependentCodec.decode(ops, input);
                if (thisField.error().isPresent() || thisField.result().orElse(Optional.empty()).isPresent()) {
                    return thisField;
                }
                return DataResult.error(() -> 3.getFieldNames(dependentCodec) + " is required");
            }

            private static <THIS_TYPE> String getFieldNames(MapCodec<Optional<THIS_TYPE>> codec) {
                return codec.keys((DynamicOps)JsonOps.INSTANCE).map(JsonElement::getAsString).collect(Collectors.joining());
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return dependentCodec.keys(ops);
            }
        };
        return otherField.dependent(dependentGetter, dependentCodec, arg_0 -> SerializerHelper.lambda$oneRequired$13(dependentCodec, (MapDecoder.Implementation)dependentRequired, arg_0));
    }

    private static /* synthetic */ MapDecoder lambda$oneRequired$13(MapCodec dependentCodec, MapDecoder.Implementation dependentRequired, Optional primaryValue) {
        return primaryValue.isPresent() ? dependentCodec : dependentRequired;
    }

    private static /* synthetic */ MapDecoder lambda$dependentOptionality$12(MapCodec dependentCodec, MapDecoder.Implementation dependentRequired, Optional primaryValue) {
        return primaryValue.isEmpty() ? dependentCodec : dependentRequired;
    }
}

