/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pncoceanaddons.depth;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pncoceanaddons.Config;
import me.desht.pncoceanaddons.PNCOceanAddons;
import me.desht.pncoceanaddons.client.DepthUpgradeClientHandler;
import me.desht.pncoceanaddons.registry.Upgrades;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.common.PNCDamageSource;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;

public class DepthUtil {
    private static final Map<UUID, Long> LAST_ALARM_TIME = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> LAST_WARN_TIME = new HashMap<UUID, Long>();

    public static void checkForDepth(Player player) {
        if (player.tickCount % 20 == 0) {
            int maxSafeDepth;
            double depth = DepthUtil.getDepth(player);
            if (depth > (double)(maxSafeDepth = DepthUtil.getMaxSafeDepth(DepthUtil.getDepthUpgradeLevel(player)))) {
                DepthUtil.dealDepthDamage(player, maxSafeDepth);
            } else if (player.getDeltaMovement().y < -0.01 && (double)maxSafeDepth - depth < 3.0) {
                DepthUtil.sendDepthWarning(player, maxSafeDepth);
            }
        }
    }

    private static void sendDepthWarning(Player player, int crushDepth) {
        if (player.getRandom().nextFloat() < 0.2f) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.CREAK.get(), SoundSource.NEUTRAL, 1.0f, 0.8f + player.getRandom().nextFloat() * 0.4f);
        }
        DepthUtil.sendCooldownMessage(player, LAST_WARN_TIME, (Component)Component.translatable((String)"pnc_ocean_addons.depth_warning", (Object[])new Object[]{crushDepth}), -2130739200);
    }

    private static void dealDepthDamage(Player player, int crushDepth) {
        player.hurt(PNCDamageSource.pressure((Level)player.level()), ((Double)Config.DEPTH_DAMAGE.get()).floatValue());
        if (player.getRandom().nextFloat() < 0.35f) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.CREAK.get(), SoundSource.NEUTRAL, 1.0f, 0.5f + player.getRandom().nextFloat() * 0.4f);
        }
        DepthUtil.sendCooldownMessage(player, LAST_ALARM_TIME, (Component)Component.translatable((String)"pnc_ocean_addons.depth_alarm", (Object[])new Object[]{crushDepth}), -2130771968);
    }

    private static void sendCooldownMessage(Player player, Map<UUID, Long> map, Component message, int bgColor) {
        long last = map.getOrDefault(player.getUUID(), 0L);
        long now = Util.getMillis();
        if (now - last > 10000L) {
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof PneumaticArmorItem) {
                ICommonArmorHandler handler = PneumaticRegistry.getInstance().getCommonArmorRegistry().getCommonArmorHandler(player);
                handler.addArmorMessage(message, 70, bgColor);
            } else {
                player.displayClientMessage((Component)message.copy().withColor(bgColor), true);
            }
            map.put(player.getUUID(), now);
        }
    }

    private static int getDepthUpgradeLevel(Player player) {
        ItemStack leggings = player.getItemBySlot(EquipmentSlot.LEGS);
        return leggings.getItem() == PNCOceanAddons.LEGGINGS.get() ? PneumaticRegistry.getInstance().getUpgradeRegistry().getUpgradeCount(leggings, Upgrades.DEPTH_UPGRADE) : 0;
    }

    public static double getDepth(Player player) {
        boolean headInFluid;
        if (((Boolean)Config.HEAD_MUST_BE_IN_FLUID.get()).booleanValue()) {
            BlockPos headPos = BlockPos.containing((Position)player.getEyePosition());
            headInFluid = player.level().getBlockState(headPos).getBlock() instanceof LiquidBlock;
        } else {
            headInFluid = true;
        }
        return headInFluid ? Math.max(0.0, (double)DepthUtil.getSeaLevel(player) - player.getEyeY()) : 0.0;
    }

    private static int getSeaLevel(Player player) {
        int n;
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            n = sl.getChunkSource().getGenerator().getSeaLevel();
        } else {
            n = DepthUpgradeClientHandler.getClientSeaLevel(player);
        }
        return n;
    }

    private static int getMaxSafeDepth(int nUpgrades) {
        return switch (nUpgrades) {
            case 0 -> (Integer)Config.DEPTH_UPGRADE_0_LIMIT.get();
            case 1 -> (Integer)Config.DEPTH_UPGRADE_1_LIMIT.get();
            default -> (Integer)Config.DEPTH_UPGRADE_2_LIMIT.get();
        };
    }
}

