/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pncoceanaddons.datagen;

import me.desht.pncoceanaddons.registry.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = ResourceLocation.parse((String)"item/generated");

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "pnc_ocean_addons", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.DEPTH_UPGRADE_1, ModItemModelProvider.upgradeTex("pneumaticcraft", "layer0"), ModItemModelProvider.upgradeTex("pneumaticcraft", "frame_1"), ModItemModelProvider.upgradeTex("pnc_ocean_addons", "depth"));
        this.simpleItem(ModItems.DEPTH_UPGRADE_2, ModItemModelProvider.upgradeTex("pneumaticcraft", "layer0"), ModItemModelProvider.upgradeTex("pneumaticcraft", "frame_2"), ModItemModelProvider.upgradeTex("pnc_ocean_addons", "depth"));
    }

    private ItemModelBuilder simpleItem(DeferredItem<? extends Item> item, String ... textures) {
        return this.simpleItem(item.getId(), textures);
    }

    private ItemModelBuilder simpleItem(ResourceLocation itemKey, String ... textures) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(itemKey.getPath(), GENERATED);
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }

    private static String upgradeTex(String modid, String base) {
        return modid + ":item/upgrades/upgrade_" + base;
    }
}

