/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.sprite;

import it.zerono.mods.zerocore.internal.Lib;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteBuilder;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import net.minecraft.resources.ResourceLocation;

public class SpriteTextureMap
implements ISpriteTextureMap {
    public static final ISpriteTextureMap EMPTY = new SpriteTextureMap(Lib.TEXTURES_LOCATION.buildWithSuffix("empty.png"), 16, 16);
    private final ResourceLocation _texture;
    private final int _width;
    private final int _height;

    public SpriteTextureMap(ResourceLocation textureLocation, int width, int height) {
        this._texture = textureLocation;
        this._width = width;
        this._height = height;
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return this._texture;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public ISpriteBuilder sprite() {
        return new SpriteBuilder(this);
    }

    public String toString() {
        return String.format("%s - %d x %d", this.getTextureLocation(), this.getWidth(), this.getHeight());
    }

    private static class SpriteBuilder
    implements ISpriteBuilder {
        private ISpriteTextureMap _map;
        private int _u;
        private int _v;
        private int _width;
        private int _height;
        private ISprite _overlay;

        SpriteBuilder(ISpriteTextureMap map) {
            this._map = map;
            this._v = 0;
            this._u = 0;
            this._height = 16;
            this._width = 16;
            this._overlay = null;
        }

        @Override
        public ISpriteBuilder from(int u, int v) {
            this._u = u;
            this._v = v;
            return this;
        }

        @Override
        public ISpriteBuilder from(ISprite sprite) {
            this._u = sprite.getU();
            this._v = sprite.getV();
            this._width = sprite.getWidth();
            this._height = sprite.getHeight();
            this._overlay = sprite.getSpriteOverlay().orElse(null);
            this._map = sprite.getTextureMap();
            return this;
        }

        @Override
        public ISpriteBuilder ofSize(int width, int height) {
            this._width = width;
            this._height = height;
            return this;
        }

        @Override
        public ISpriteBuilder with(ISprite overlay) {
            this._overlay = overlay;
            return this;
        }

        @Override
        public ISprite build() {
            return new Sprite(this._width, this._height, this._map, this._u, this._v, this._overlay);
        }
    }
}

