/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut.recipe;

import com.mojang.datafixers.util.Unit;
import de.mari_023.ae2wtlib.api.registration.WTDefinition;
import de.mari_023.ae2wtlib.wut.recipe.Common;
import de.mari_023.ae2wtlib.wut.recipe.InputHelper;
import de.mari_023.ae2wtlib.wut.recipe.UpgradeSerializer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class Upgrade
extends Common {
    public static final UpgradeSerializer serializer = new UpgradeSerializer();
    private final Ingredient terminal;
    private final WTDefinition terminalDefinition;

    public Upgrade(Ingredient terminal, WTDefinition terminalDefinition) {
        this.terminal = terminal;
        this.terminalDefinition = terminalDefinition;
        this.outputStack.set(terminalDefinition.componentType(), (Object)Unit.INSTANCE);
    }

    public Ingredient getTerminal() {
        return this.terminal;
    }

    public WTDefinition getTerminalDefinition() {
        return this.terminalDefinition;
    }

    public boolean matches(CraftingInput inv, Level world) {
        ItemStack wut = InputHelper.getInputStack(inv, InputHelper.WUT);
        return !InputHelper.getInputStack(inv, this.terminal).isEmpty() && !wut.isEmpty() && inv.ingredientCount() == 2 && wut.get(this.terminalDefinition.componentType()) == null;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        return Upgrade.mergeTerminal(InputHelper.getInputStack(inv, InputHelper.WUT).copy(), InputHelper.getInputStack(inv, this.terminal).copy(), this.terminalDefinition);
    }

    public RecipeSerializer<?> getSerializer() {
        return serializer;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList inputs = NonNullList.create();
        inputs.add((Object)this.terminal);
        inputs.add((Object)InputHelper.WUT);
        return inputs;
    }
}

