/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.portingdeadmods.cable_facades.CFMain;
import com.portingdeadmods.cable_facades.data.helper.ChunkFacadeMap;
import com.portingdeadmods.cable_facades.data.helper.LevelFacadeMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CableFacadeSavedData
extends SavedData {
    public static final String ID = "cable_facades_saved_data";
    private final LevelFacadeMap levelFacadeMap;

    public CableFacadeSavedData(LevelFacadeMap levelFacadeMap) {
        this.levelFacadeMap = levelFacadeMap;
    }

    public CableFacadeSavedData() {
        this(new LevelFacadeMap());
    }

    public LevelFacadeMap getLevelFacadeMap() {
        return this.levelFacadeMap;
    }

    @NotNull
    public ChunkFacadeMap getOrCreateFacadeMapForChunk(ChunkPos chunkPos) {
        ChunkFacadeMap map = this.getFacadeMapForChunk(chunkPos);
        if (map == null) {
            map = new ChunkFacadeMap();
            this.levelFacadeMap.getChunkFacadeMaps().put(chunkPos, map);
            this.setDirty();
        }
        return map;
    }

    @Nullable
    public ChunkFacadeMap getFacadeMapForChunk(ChunkPos chunkPos) {
        return this.levelFacadeMap.getChunkFacadeMaps().get(chunkPos);
    }

    @NotNull
    public ChunkFacadeMap getOrCreateFacadeMapForPos(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        return this.getOrCreateFacadeMapForChunk(chunkPos);
    }

    @Nullable
    public ChunkFacadeMap getFacadeMapForPos(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        return this.getFacadeMapForChunk(chunkPos);
    }

    public void addFacade(BlockPos blockPos, BlockState blockState) {
        this.getOrCreateFacadeMapForPos(blockPos).getChunkMap().put(blockPos, blockState);
        this.setDirty();
    }

    public void removeFacade(BlockPos blockPos) {
        this.getOrCreateFacadeMapForPos(blockPos).getChunkMap().remove(blockPos);
        this.setDirty();
    }

    public boolean isEmpty() {
        return this.levelFacadeMap.getChunkFacadeMaps().isEmpty();
    }

    @Nullable
    public BlockState getFacade(BlockPos blockPos) {
        ChunkFacadeMap facadeMapForPos = this.getFacadeMapForPos(blockPos);
        if (facadeMapForPos != null) {
            return facadeMapForPos.getChunkMap().get(blockPos);
        }
        return null;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        DataResult tagDataResult = LevelFacadeMap.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.levelFacadeMap);
        tagDataResult.resultOrPartial(err -> CFMain.LOGGER.error("Encoding error: {}", err)).ifPresent(tag -> compoundTag.put(ID, tag));
        return compoundTag;
    }

    private static CableFacadeSavedData load(CompoundTag compoundTag, ServerLevel serverLevel) {
        DataResult dataResult = LevelFacadeMap.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(ID));
        Optional mapTagPair = dataResult.resultOrPartial(err -> CFMain.LOGGER.error("Decoding error: {}", err));
        if (dataResult.error().isPresent()) {
            CFMain.LOGGER.error("Data may be outdated - attempting migration!");
            dataResult = LevelFacadeMap.MIGRATION_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(ID));
            mapTagPair = dataResult.resultOrPartial(err -> CFMain.LOGGER.error("Migration failed: {}", err));
        }
        if (mapTagPair.isPresent()) {
            LevelFacadeMap facadeMap = (LevelFacadeMap)((Pair)mapTagPair.get()).getFirst();
            return new CableFacadeSavedData(facadeMap);
        }
        return new CableFacadeSavedData();
    }

    public static CableFacadeSavedData get(ServerLevel level) {
        return (CableFacadeSavedData)level.getDataStorage().computeIfAbsent(CableFacadeSavedData.factory(level), ID);
    }

    private static SavedData.Factory<CableFacadeSavedData> factory(ServerLevel pLevel) {
        return new SavedData.Factory(CableFacadeSavedData::new, (tag, provider) -> CableFacadeSavedData.load(tag, pLevel));
    }

    public String toString() {
        return "CableFacadeSavedData{levelFacadeMap=" + String.valueOf(this.levelFacadeMap) + "}";
    }
}

