/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.content.recipes;

import com.portingdeadmods.cable_facades.content.items.FacadeItem;
import com.portingdeadmods.cable_facades.registries.CFDataComponents;
import com.portingdeadmods.cable_facades.registries.CFRecipes;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import org.jetbrains.annotations.NotNull;

public class FacadeCraftingRecipe
extends CustomRecipe {
    public FacadeCraftingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        boolean hasBlock = false;
        boolean hasFacade = false;
        ItemStack facadeStack = null;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack stack = craftingInput.getItem(i);
            Item item = stack.getItem();
            if (item instanceof FacadeItem) {
                if (!hasFacade) {
                    facadeStack = stack.copy();
                    hasFacade = true;
                    continue;
                }
                return false;
            }
            if (item instanceof BlockItem) {
                if (!hasBlock) {
                    hasBlock = true;
                    continue;
                }
                return false;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        if (hasFacade && !hasBlock && ((Optional)facadeStack.getOrDefault(CFDataComponents.FACADE_BLOCK, Optional.empty())).isPresent()) {
            return true;
        }
        return hasFacade && hasBlock;
    }

    @NotNull
    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider registryAccess) {
        Optional optionalBlock;
        Block facadeBlock = null;
        ItemStack originalFacadeStack = ItemStack.EMPTY;
        ItemStack facadeStack = ItemStack.EMPTY;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack item = craftingInput.getItem(i);
            Item item2 = item.getItem();
            if (item2 instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item2;
                facadeBlock = blockItem.getBlock();
                if (facadeBlock.defaultBlockState().getRenderShape() != RenderShape.ENTITYBLOCK_ANIMATED) continue;
                return ItemStack.EMPTY;
            }
            if (!(item.getItem() instanceof FacadeItem)) continue;
            facadeStack = item.copy();
            originalFacadeStack = item;
        }
        if (!facadeStack.isEmpty() && facadeBlock != null) {
            ItemStack stack = facadeStack.getItem().getDefaultInstance();
            stack.set(CFDataComponents.FACADE_BLOCK, Optional.of(facadeBlock));
            return stack;
        }
        if (!facadeStack.isEmpty() && (optionalBlock = (Optional)facadeStack.get(CFDataComponents.FACADE_BLOCK)).isPresent()) {
            originalFacadeStack.set(CFDataComponents.HAS_FACADE_REMAINDER, (Object)true);
            return ((Block)optionalBlock.get()).asItem().getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return CFRecipes.FACADE.get();
    }
}

