/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.portingdeadmods.cable_facades.events.CFClientEvents;
import com.portingdeadmods.cable_facades.registries.CFDataComponents;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FacadeItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public FacadeItemRenderer() {
        super(null, null);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        poseStack.pushPose();
        Optional optionalBlock = (Optional)stack.get(CFDataComponents.FACADE_BLOCK);
        if (optionalBlock.isPresent()) {
            Block block = (Block)optionalBlock.get();
            BlockState state = block.defaultBlockState();
            ItemStack defaultInstance = state.getBlock().asItem().getDefaultInstance();
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.scale(2.0f, 2.0f, 2.0f);
            Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)Minecraft.getInstance().player, defaultInstance, ItemDisplayContext.FIXED, false, poseStack, buffer, (Level)Minecraft.getInstance().level, combinedLight, combinedOverlay, 0);
            poseStack.popPose();
        }
        float scaleFactor = 0.001f;
        poseStack.translate(-(scaleFactor / 2.0f), -(scaleFactor / 2.0f), -(scaleFactor / 2.0f));
        poseStack.scale(1.0f + scaleFactor, 1.0f + scaleFactor, 1.0f + scaleFactor);
        BakedModel model = Minecraft.getInstance().getModelManager().getModel(CFClientEvents.FACADE_OUTLINE);
        Minecraft.getInstance().getItemRenderer().renderModelLists(model, stack, combinedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer.getBuffer((RenderType)model.getRenderTypes(stack, true).getFirst()));
        poseStack.popPose();
    }
}

